/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.cloud.ui.fileSystem.internal;

import oracle.eclipse.tools.cloud.java.FolderFacade;
import oracle.eclipse.tools.cloud.java.ResourceFacade;
import oracle.eclipse.tools.cloud.ui.fileSystem.internal.NameConflict;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.LocalizableText;
import org.eclipse.sapphire.Text;
import org.eclipse.sapphire.ui.def.DefinitionLoader;
import org.eclipse.sapphire.ui.forms.swt.SapphireDialog;
import org.eclipse.sapphire.util.MutableReference;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public final class NameConflictDialog {
    @Text(value="Copy-of-{0}")
    private static LocalizableText copiedResourceNameFirst;
    @Text(value="Copy-({1})-of-{0}")
    private static LocalizableText copiedResourceNameOther;

    static {
        LocalizableText.init(NameConflictDialog.class);
    }

    public static final String open(final ResourceFacade resource) {
        Display display = Display.getCurrent();
        if (display != null) {
            return NameConflictDialog.open(resource, display.getActiveShell());
        }
        final MutableReference result = new MutableReference();
        display = Display.getDefault();
        display.syncExec(new Runnable(){

            @Override
            public void run() {
                result.set((Object)NameConflictDialog.open(resource));
            }
        });
        return (String)result.get();
    }

    public static final String open(ResourceFacade resource, Shell shell) {
        String modified;
        FolderFacade folder = resource.parent();
        String original = resource.name();
        int counter = 0;
        while (folder.contains(modified = ++counter == 1 ? copiedResourceNameFirst.format(new Object[]{original}) : copiedResourceNameOther.format(new Object[]{original, counter}))) {
        }
        NameConflict element = (NameConflict)NameConflict.TYPE.instantiate();
        try {
            element.setOriginalName(original);
            element.setModifiedName(modified);
            SapphireDialog dialog = new SapphireDialog(shell, (Element)element, DefinitionLoader.sdef(NameConflictDialog.class).dialog());
            if (dialog.open() == 1) {
                return null;
            }
            String string = (String)element.getModifiedName().content();
            return string;
        }
        finally {
            element.dispose();
        }
    }
}

