/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.cloud.ui.fileSystem;

import java.io.File;
import java.util.Iterator;
import oracle.eclipse.tools.cloud.java.FolderFacade;
import oracle.eclipse.tools.cloud.java.ResourceFacade;
import oracle.eclipse.tools.cloud.ui.fileSystem.JavaServiceFileSystemCopyJob;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.sapphire.util.SetFactory;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.navigator.CommonNavigator;

public final class JavaServiceFileSystemPasteActionHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) {
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (selection instanceof IStructuredSelection) {
            SetFactory resources = SetFactory.start();
            FolderFacade destination = null;
            IAdapterManager adapterManager = Platform.getAdapterManager();
            Clipboard clipboard = new Clipboard(HandlerUtil.getActiveShell((ExecutionEvent)event).getDisplay());
            try {
                destination = (FolderFacade)adapterManager.getAdapter(((StructuredSelection)selection).getFirstElement(), ResourceFacade.class);
                Object data = clipboard.getContents((Transfer)FileTransfer.getInstance());
                if (data instanceof String[]) {
                    String[] stringArray = (String[])data;
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String name = stringArray[n2];
                        ResourceFacade resToCopy = (ResourceFacade)adapterManager.getAdapter((Object)new File(name), ResourceFacade.class);
                        resources.add((Object)resToCopy);
                        ++n2;
                    }
                }
                if ((data = clipboard.getContents((Transfer)LocalSelectionTransfer.getTransfer())) instanceof StructuredSelection) {
                    Iterator itr = ((StructuredSelection)data).iterator();
                    while (itr.hasNext()) {
                        ResourceFacade resToCopy = (ResourceFacade)adapterManager.getAdapter(itr.next(), ResourceFacade.class);
                        if (resToCopy == destination) {
                            MessageDialog.openError((Shell)HandlerUtil.getActiveShell((ExecutionEvent)event), (String)"Error", (String)"Error: the destination is the same as the source folder.");
                            return null;
                        }
                        resources.add((Object)resToCopy);
                    }
                }
            }
            finally {
                clipboard.dispose();
            }
            if (destination != null && resources.size() != 0) {
                new JavaServiceFileSystemCopyJob(resources.result(), destination, (CommonNavigator)HandlerUtil.getActivePart((ExecutionEvent)event)).schedule();
            }
        }
        return null;
    }
}

