/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.cloud.ui.fileSystem;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import oracle.eclipse.tools.cloud.java.FolderFacade;
import oracle.eclipse.tools.cloud.java.JavaServiceFile;
import oracle.eclipse.tools.cloud.java.JavaServiceFolder;
import oracle.eclipse.tools.cloud.java.ResourceFacade;
import oracle.eclipse.tools.cloud.ui.CloudUiPlugin;
import oracle.eclipse.tools.cloud.ui.fileSystem.CloudTextFileInput;
import oracle.eclipse.tools.cloud.ui.fileSystem.JavaServiceFileSystemOpenActionHandler;
import oracle.eclipse.tools.cloud.ui.fileSystem.internal.NameConflictDialog;
import oracle.eclipse.tools.cloud.ui.fileSystem.internal.PromptingJavaServiceFileSystemConflictResolver;
import oracle.eclipse.tools.common.util.fileio.FileUtil;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.sapphire.LocalizableText;
import org.eclipse.sapphire.Text;
import org.eclipse.sapphire.util.ListFactory;
import org.eclipse.sapphire.util.SetFactory;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.navigator.CommonNavigator;
import org.eclipse.ui.navigator.CommonViewer;

public final class JavaServiceFileSystemCopyJob
extends Job {
    @Text(value="Copying")
    private static LocalizableText jobName;
    @Text(value="Copying...")
    private static LocalizableText taskName;
    @Text(value="Copying \"{0}\"...")
    private static LocalizableText taskNameDetailed;
    @Text(value="Copy Problem")
    private static LocalizableText copyProblemDialogTitle;
    @Text(value="Destination cannot be a descendant of the source.")
    private static LocalizableText destinationCannotBeDescendantOfSourceMessage;
    private final Set<ResourceFacade> resources;
    private final FolderFacade destination;
    private final CommonNavigator navigator;

    static {
        LocalizableText.init(JavaServiceFileSystemCopyJob.class);
    }

    public JavaServiceFileSystemCopyJob(ResourceFacade resource, FolderFacade destination, CommonNavigator navigator) {
        this(SetFactory.singleton((Object)resource), destination, navigator);
    }

    public JavaServiceFileSystemCopyJob(Set<ResourceFacade> resources, FolderFacade destination, CommonNavigator navigator) {
        super(jobName.text());
        if (resources == null || resources.isEmpty()) {
            throw new IllegalArgumentException();
        }
        for (ResourceFacade resource : resources) {
            if (resource instanceof ResourceFacade || resource instanceof IResource || resource instanceof File) continue;
            throw new IllegalArgumentException();
        }
        if (destination == null) {
            throw new IllegalArgumentException();
        }
        this.resources = resources;
        this.destination = destination;
        this.navigator = navigator;
        this.setUser(true);
    }

    protected IStatus run(final IProgressMonitor monitor) {
        monitor.beginTask(taskName.text(), -1);
        File stateLocation = CloudUiPlugin.getDefault().getStateLocation().toFile();
        File scratchRootDir = new File(stateLocation, "/scratch/");
        File scratchDir = new File(scratchRootDir, "" + System.currentTimeMillis());
        try {
            CommonViewer viewer;
            Control control;
            HashSet<Object> resourcesToCopy = new HashSet<Object>();
            for (ResourceFacade resource : this.resources) {
                if (resource instanceof JavaServiceFolder && this.destination.descendant((FolderFacade)((JavaServiceFolder)resource))) {
                    final Display display = Display.getDefault();
                    display.syncExec(new Runnable(){

                        @Override
                        public void run() {
                            MessageDialog.openError((Shell)display.getActiveShell(), (String)copyProblemDialogTitle.text(), (String)destinationCannotBeDescendantOfSourceMessage.text());
                        }
                    });
                    IStatus iStatus = Status.OK_STATUS;
                    return iStatus;
                }
                if (!(resource instanceof ResourceFacade)) continue;
                ResourceFacade resourceFacade = resource;
                if (this.destination instanceof JavaServiceFolder && resourceFacade instanceof JavaServiceFolder && resourceFacade.root() != this.destination.root()) {
                    scratchDir.mkdirs();
                    IAdapterManager adapterManager = Platform.getAdapterManager();
                    FolderFacade scratchFolder = (FolderFacade)adapterManager.getAdapter((Object)scratchDir, ResourceFacade.class);
                    new JavaServiceFileSystemCopyJob(resourceFacade, scratchFolder, null).run(monitor);
                    if (resourceFacade instanceof FolderFacade) {
                        resourcesToCopy.add(scratchFolder.folder(resourceFacade.name()));
                        continue;
                    }
                    resourcesToCopy.add(scratchFolder.file(resourceFacade.name()));
                    continue;
                }
                resourcesToCopy.add(resourceFacade);
            }
            this.destination.members().fetch();
            final ListFactory copiedResourcesListFactory = ListFactory.start();
            final PromptingJavaServiceFileSystemConflictResolver conflictResolver = new PromptingJavaServiceFileSystemConflictResolver();
            for (final ResourceFacade resourceFacade : resourcesToCopy) {
                String name;
                if (monitor.isCanceled()) {
                    IStatus iStatus = Status.CANCEL_STATUS;
                    return iStatus;
                }
                if (this.destination.equals(resourceFacade.parent())) {
                    name = NameConflictDialog.open(resourceFacade);
                    if (name == null) {
                        break;
                    }
                } else {
                    name = resourceFacade.name();
                }
                monitor.setTaskName(taskNameDetailed.format(new Object[]{resourceFacade.name()}));
                final Exception[] exceptions = new Exception[1];
                Thread resourceCopyThread = new Thread(){

                    @Override
                    public void run() {
                        if (monitor.isCanceled()) {
                            return;
                        }
                        try {
                            ResourceFacade copiedResource = resourceFacade.copy(JavaServiceFileSystemCopyJob.this.destination, name, conflictResolver, monitor);
                            if (!this.isInterrupted()) {
                                copiedResourcesListFactory.add((Object)copiedResource);
                            }
                        }
                        catch (Exception e) {
                            exceptions[0] = e;
                        }
                    }
                };
                resourceCopyThread.start();
                while (resourceCopyThread.isAlive()) {
                    if (monitor.isCanceled()) {
                        resourceCopyThread.interrupt();
                        IStatus iStatus = Status.CANCEL_STATUS;
                        return iStatus;
                    }
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                if (conflictResolver.aborted()) break;
                if (exceptions[0] == null) continue;
                IStatus iStatus = CloudUiPlugin.createErrorStatus("Error copying file", exceptions[0]);
                return iStatus;
            }
            final List list = copiedResourcesListFactory.result();
            this.updateOpenedEditors(list);
            if (this.navigator != null && !(control = (viewer = this.navigator.getCommonViewer()).getControl()).isDisposed()) {
                control.getDisplay().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        viewer.setSelection((ISelection)new StructuredSelection(list));
                    }
                });
            }
        }
        finally {
            if (this.destination instanceof JavaServiceFolder && scratchRootDir.exists()) {
                try {
                    FileUtil.delete((File)scratchRootDir, (boolean)true);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            monitor.done();
        }
        return Status.OK_STATUS;
    }

    private void updateOpenedEditors(List<ResourceFacade> resultList) {
        final ArrayList<JavaServiceFile> changedFiles = new ArrayList<JavaServiceFile>();
        for (ResourceFacade res : resultList) {
            if (!(res instanceof JavaServiceFile)) continue;
            changedFiles.add((JavaServiceFile)res);
        }
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                IEditorReference[] iEditorReferenceArray = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getEditorReferences();
                int n = iEditorReferenceArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IEditorInput in;
                    IEditorReference e = iEditorReferenceArray[n2];
                    IEditorPart part = e.getEditor(false);
                    if (part != null && (in = part.getEditorInput()) instanceof CloudTextFileInput) {
                        CloudTextFileInput cin = (CloudTextFileInput)in;
                        JavaServiceFile file = (JavaServiceFile)cin.getCloudFile();
                        for (JavaServiceFile newFile : changedFiles) {
                            if (newFile.parent() != file.parent() || !newFile.path().equals((Object)file.path())) continue;
                            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().closeEditor(part, false);
                            JavaServiceFileSystemOpenActionHandler.openCloudFile(file);
                            break;
                        }
                    }
                    ++n2;
                }
            }
        });
    }
}

