/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.cloud.ui.fileSystem;

import java.util.List;
import oracle.eclipse.tools.cloud.CloudConnection;
import oracle.eclipse.tools.cloud.OracleCloudTools;
import oracle.eclipse.tools.cloud.RemoteData;
import oracle.eclipse.tools.cloud.java.FolderFacade;
import oracle.eclipse.tools.cloud.java.JavaServiceFolder;
import oracle.eclipse.tools.cloud.java.ResourceFacade;
import oracle.eclipse.tools.cloud.server.internal.OracleCloudRuntime;
import oracle.eclipse.tools.cloud.server.internal.OracleCloudServerBehaviour;
import oracle.eclipse.tools.cloud.ui.internal.FetchFailedNode;
import oracle.eclipse.tools.cloud.ui.internal.FetchingRemoteDataNode;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.Listener;
import org.eclipse.ui.navigator.CommonViewer;
import org.eclipse.wst.server.core.IServer;

public final class JavaServiceFileSystemContentProvider
implements ITreeContentProvider {
    private CommonViewer viewer;
    private Listener folderMembersListener = new FilteredListener<RemoteData.Event>(){

        protected void handleTypedEvent(RemoteData.Event event) {
            if (event instanceof RemoteData.ContentEvent || event instanceof RemoteData.FetchFailedEvent) {
                final FolderFacade folder = ((FolderFacade.Members)event.data()).folder();
                JavaServiceFileSystemContentProvider.this.viewer.getControl().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        JavaServiceFileSystemContentProvider.this.viewer.refresh((Object)folder);
                    }
                });
            }
        }
    };

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.viewer = (CommonViewer)viewer;
    }

    public Object[] getElements(Object inputElement) {
        return new Object[]{inputElement};
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof IServer) {
            IServer server = (IServer)parentElement;
            server.loadAdapter(OracleCloudServerBehaviour.class, (IProgressMonitor)new NullProgressMonitor());
            if (server.getServerState() == 4) {
                return new Object[0];
            }
            OracleCloudRuntime crt = (OracleCloudRuntime)server.getRuntime().getAdapter(OracleCloudRuntime.class);
            if (crt != null) {
                return new Object[]{crt.getFileSystem()};
            }
        } else if (parentElement instanceof JavaServiceFolder) {
            JavaServiceFolder folder = (JavaServiceFolder)parentElement;
            folder.members().attach(this.folderMembersListener);
            if (folder.members().available()) {
                return ((List)folder.members().content()).toArray();
            }
            if (folder.members().fetchFailed()) {
                return new Object[]{FetchFailedNode.INSTANCE};
            }
            folder.members().fetch(true, null);
            return new Object[]{FetchingRemoteDataNode.INSTANCE};
        }
        return new Object[0];
    }

    public Object getParent(Object element) {
        if (element instanceof ResourceFacade) {
            return ((ResourceFacade)element).parent();
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        return element instanceof JavaServiceFolder;
    }

    public void dispose() {
        if (this.folderMembersListener != null) {
            for (CloudConnection connection : OracleCloudTools.connections()) {
                if (!connection.services().available()) continue;
                for (Object service : (List)connection.services().content()) {
                    if (!(service instanceof IServer)) continue;
                    OracleCloudRuntime crt = (OracleCloudRuntime)((IServer)service).getRuntime().getAdapter(OracleCloudRuntime.class);
                    this.detach((ResourceFacade)crt.getFileSystem());
                }
            }
            this.folderMembersListener = null;
        }
    }

    private void detach(ResourceFacade resource) {
        JavaServiceFolder folder;
        if (resource instanceof JavaServiceFolder && (folder = (JavaServiceFolder)resource).members().available()) {
            folder.members().detach(this.folderMembersListener);
            for (ResourceFacade member : (List)folder.members().content()) {
                this.detach(member);
            }
        }
    }
}

