/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.cloud.ui.dev.view;

import com.tasktop.c2c.server.tasks.domain.PredefinedTaskQuery;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import oracle.eclipse.tools.cloud.CloudPlugin;
import oracle.eclipse.tools.cloud.dev.CloudProject;
import oracle.eclipse.tools.cloud.dev.CloudProjectService;
import oracle.eclipse.tools.cloud.dev.DevCloudCore;
import oracle.eclipse.tools.cloud.dev.DevServiceDesc;
import oracle.eclipse.tools.cloud.dev.GitRepoNode;
import oracle.eclipse.tools.cloud.dev.TaskService;
import oracle.eclipse.tools.cloud.dev.internal.GitCommitUtil;
import oracle.eclipse.tools.cloud.profile.ICloudProfile;
import oracle.eclipse.tools.cloud.ui.CloudUiPlugin;
import oracle.eclipse.tools.cloud.ui.dev.view.RemoteBranchSelectionDialog;
import oracle.eclipse.tools.cloud.ui.profile.CloudProfileView;
import oracle.eclipse.tools.common.util.fileio.FileUtil;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.egit.core.op.ListRemoteOperation;
import org.eclipse.egit.core.securestorage.UserPasswordCredentials;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.credentials.EGitCredentialsProvider;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.mylyn.commons.net.AuthenticationCredentials;
import org.eclipse.mylyn.commons.net.AuthenticationType;
import org.eclipse.mylyn.internal.tasks.core.RepositoryQuery;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.tasks.core.IRepositoryManager;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class DevCloudUiUtil {
    public static final String ID = CloudPlugin.class.getPackage().getName();
    public static final String CONNECTOR_KIND = "CloudDev";
    public static final String CRITERIA_QUERY = "findTasksWithCriteria";
    public static final String PREDEFINED_QUERY = "findTasksWithQuery";
    public static final String QUERY_CRITERIA = "QueryCriteria";
    public static final String QUERY_NAME = "QueryName";

    public static boolean checkCloudProject(CloudProject cp) {
        DevServiceDesc devService = cp.getDevServiceDesc();
        if (DevCloudCore.findCloudProjectById((DevServiceDesc)devService, (String)cp.getProject().getIdentifier()) == null) {
            String message = String.format("Project \"%s\" not found on Oracle Cloud.", cp.getProject().getName());
            MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Error", (String)message);
            return false;
        }
        return true;
    }

    public static CloudProject getCloudProject(Object obj) {
        if (obj instanceof CloudProject) {
            return (CloudProject)obj;
        }
        if (obj instanceof CloudProjectService) {
            CloudProjectService cps = (CloudProjectService)obj;
            return cps.getCloudProject();
        }
        return null;
    }

    public static boolean cloneGitRepo(final GitRepoNode gitRepoNode) throws URISyntaxException, IOException, GitAPIException {
        CloudProjectService projServ = gitRepoNode.getCloudProjectService();
        final String remoteUrl = gitRepoNode.getUrl();
        final File gitRoot = DevCloudCore.getLocalGitRoot((GitRepoNode)gitRepoNode);
        String[] ff = gitRoot.list();
        if (gitRoot.exists() && ff != null && ff.length > 0) {
            CloudUiPlugin.promptError(String.format("%s is not an empty directory. Please delete the directory and restart Eclipse.", gitRoot.getAbsolutePath()));
            return false;
        }
        File gitDir = new File(gitRoot, ".git");
        FileUtil.delete((File)gitRoot);
        if (!gitDir.exists()) {
            Ref initialBranch;
            String projId = projServ.getCloudProject().getProject().getIdentifier().toLowerCase();
            String cloudProjName = projId.replace(' ', '-');
            final ICloudProfile profile = projServ.getCloudProject().getProfile();
            UserPasswordCredentials credentials = new UserPasswordCredentials((String)profile.getUser().content(), (String)profile.getPassword().content());
            List<Ref> refs = DevCloudUiUtil.listRemoteRepo(remoteUrl, credentials, (IProgressMonitor)new NullProgressMonitor());
            if (refs.size() == 0) {
                GitCommitUtil.initEmptyGitRepo((ICloudProfile)profile, (String)cloudProjName, (String)remoteUrl);
                refs = DevCloudUiUtil.listRemoteRepo(remoteUrl, credentials, (IProgressMonitor)new NullProgressMonitor());
            }
            final ArrayList<Ref> refsToSync = new ArrayList<Ref>();
            if (refs.size() == 1) {
                refsToSync.addAll(refs);
                initialBranch = refs.get(0);
            } else {
                RemoteBranchSelectionDialog dlg = new RemoteBranchSelectionDialog(Display.getDefault().getActiveShell(), refs);
                if (dlg.open() != 0) {
                    return false;
                }
                initialBranch = dlg.getInitialCheckoutBranch();
                Object[] objectArray = dlg.getResult();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object o = objectArray[n2];
                    refsToSync.add((Ref)o);
                    ++n2;
                }
            }
            WorkspaceJob cloneGitRepoJob = new WorkspaceJob("Clone Git repository"){

                public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                    try {
                        GitCommitUtil.cloneRemoteRepo((List)refsToSync, (Ref)initialBranch, (ICloudProfile)profile, (File)gitRoot, (String)remoteUrl, (IProgressMonitor)monitor);
                        Display.getDefault().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                CloudProfileView view = CloudProfileView.getFromActivePerspective();
                                if (view != null) {
                                    view.refresh(gitRepoNode.getCloudProjectService());
                                }
                            }
                        });
                    }
                    catch (Exception e) {
                        CloudPlugin.log((Exception)e);
                        String message = e.getMessage();
                        CloudUiPlugin.promptError(message);
                    }
                    return Status.OK_STATUS;
                }
            };
            cloneGitRepoJob.setUser(true);
            cloneGitRepoJob.schedule();
            return true;
        }
        return false;
    }

    public static List<Ref> listRemoteRepo(String gitUrl, UserPasswordCredentials credentials, IProgressMonitor monitor) {
        ListRemoteOperation listRemoteOp;
        ArrayList<Ref> availableRefs = new ArrayList<Ref>();
        try {
            URIish uri = new URIish(gitUrl);
            Repository db = FileRepositoryBuilder.create((File)new File("/tmp"));
            int timeout = Activator.getDefault().getPreferenceStore().getInt("remote_connection_timeout");
            listRemoteOp = new ListRemoteOperation(db, uri, timeout);
            if (credentials != null) {
                listRemoteOp.setCredentialsProvider((CredentialsProvider)new EGitCredentialsProvider(credentials.getUser(), credentials.getPassword()));
            }
            listRemoteOp.run(monitor);
        }
        catch (Exception exception) {
            return Collections.emptyList();
        }
        Ref idHEAD = listRemoteOp.getRemoteRef("HEAD");
        Ref head = null;
        boolean headIsMaster = false;
        for (Ref r : listRemoteOp.getRemoteRefs()) {
            String n = r.getName();
            if (!n.startsWith("refs/heads/")) continue;
            availableRefs.add(r);
            if (idHEAD == null || headIsMaster || !r.getObjectId().equals((AnyObjectId)idHEAD.getObjectId())) continue;
            headIsMaster = "refs/heads/master".equals(r.getName());
            if (head != null && !headIsMaster) continue;
            head = r;
        }
        Collections.sort(availableRefs, new Comparator<Ref>(){

            @Override
            public int compare(Ref o1, Ref o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        if (idHEAD != null && head == null) {
            head = idHEAD;
            availableRefs.add(0, idHEAD);
        }
        return availableRefs;
    }

    public static RepositoryQuery createPredefinedQuery(TaskService ts, PredefinedTaskQuery query) {
        try {
            CloudProject cp = ts.getCloudProject();
            String url = ts.getProjectService().getUrl();
            TaskRepository taskRepo = DevCloudUiUtil.getTaskRepoitory(url, cp);
            Set queryList = TasksUiPlugin.getTaskList().getRepositoryQueries(url);
            String name = query.name();
            for (RepositoryQuery rq : queryList) {
                if (!rq.getSummary().equals(name)) continue;
                return rq;
            }
            RepositoryQuery pq = DevCloudUiUtil.createPredefinedQuery(taskRepo, name, query.toString());
            return pq;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static RepositoryQuery createPredefinedQuery(TaskRepository taskRepo, String name, String refName) {
        RepositoryQuery mq = (RepositoryQuery)TasksUi.getRepositoryModel().createRepositoryQuery(taskRepo);
        mq.setSummary(name);
        mq.setUrl(PREDEFINED_QUERY);
        mq.setAttribute(QUERY_NAME, refName);
        TasksUiPlugin.getTaskList().addQuery(mq);
        return mq;
    }

    public static TaskRepository getTaskRepoitory(String url, CloudProject cp) {
        TaskRepository taskRepository = null;
        IRepositoryManager repoMgr = TasksUi.getRepositoryManager();
        for (TaskRepository repo : repoMgr.getAllRepositories()) {
            if (!repo.getUrl().equals(url)) continue;
            taskRepository = repo;
            break;
        }
        if (taskRepository == null) {
            taskRepository = new TaskRepository(CONNECTOR_KIND, url);
            String label = String.valueOf((String)cp.getProfile().getConnectionName().content()) + " [" + cp.getProject().getName() + "]";
            taskRepository.setRepositoryLabel(label);
            taskRepository.setProperty("category", "org.eclipse.mylyn.category.tasks");
            taskRepository.setProperty("Connection", (String)cp.getProfile().getId().content());
            taskRepository.setProperty("Project", cp.getProject().getName());
            ICloudProfile cloudProfile = cp.getProfile();
            AuthenticationCredentials webCredentials = new AuthenticationCredentials((String)cloudProfile.getUser().content(), (String)cloudProfile.getPassword().content());
            taskRepository.setCredentials(AuthenticationType.HTTP, webCredentials, true);
            taskRepository.setCredentials(AuthenticationType.REPOSITORY, webCredentials, true);
            repoMgr.addRepository(taskRepository);
        }
        return taskRepository;
    }
}

