/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.cloud.ui.dev.action;

import com.tasktop.c2c.server.cloud.domain.ServiceType;
import com.tasktop.c2c.server.profile.domain.project.Project;
import com.tasktop.c2c.server.profile.domain.project.ProjectService;
import oracle.eclipse.tools.cloud.dev.CloudProject;
import oracle.eclipse.tools.cloud.dev.CloudProjectService;
import oracle.eclipse.tools.cloud.dev.DcsBuildPlan;
import oracle.eclipse.tools.cloud.dev.DevServiceDesc;
import oracle.eclipse.tools.cloud.dev.GitRepoNode;
import oracle.eclipse.tools.cloud.ui.CloudUiPlugin;
import org.eclipse.mylyn.builds.core.IBuild;
import org.eclipse.mylyn.builds.core.IBuildPlan;
import org.eclipse.mylyn.internal.tasks.core.TaskTask;
import org.eclipse.wst.server.ui.internal.Trace;

public class OpenInBrowserActionDelegate {
    public void open(Object element) {
        block28: {
            if (element != null) {
                String url = null;
                if (element instanceof CloudProject) {
                    CloudProject cp = (CloudProject)element;
                    url = String.valueOf(cp.getDevServiceDesc().getDevServiceUrl()) + "/#projects/" + cp.getProject().getIdentifier();
                } else if (element instanceof CloudProjectService) {
                    CloudProjectService cps = (CloudProjectService)element;
                    CloudProject cp = cps.getCloudProject();
                    ProjectService ps = cps.getProjectService();
                    Project proj = cps.getCloudProject().getProject();
                    if (ps.getServiceType() == ServiceType.WIKI) {
                        url = String.valueOf(cp.getDevServiceDesc().getDevServiceUrl()) + "/#projects/" + proj.getIdentifier() + "/wiki";
                    } else if (ps.getServiceType() == ServiceType.SCM) {
                        url = String.valueOf(cp.getDevServiceDesc().getDevServiceUrl()) + "/#projects/" + proj.getIdentifier() + "/scm";
                    } else if (ps.getServiceType() == ServiceType.REVIEWS) {
                        url = String.valueOf(ps.getWebUrl()) + "/mine_as_owner_open";
                    } else {
                        if (ps.getServiceType() == ServiceType.BUILD_SLAVE) {
                            return;
                        }
                        url = ps.getWebUrl();
                    }
                    if (url == null) {
                        url = ps.getUrl().replace("/s/", "/s2/");
                    }
                } else if (element instanceof GitRepoNode) {
                    GitRepoNode gitRepo = (GitRepoNode)element;
                    CloudProject cp = gitRepo.getCloudProjectService().getCloudProject();
                    url = String.valueOf(cp.getDevServiceDesc().getDevServiceUrl()) + "/#projects/" + cp.getProject().getIdentifier() + "/scm";
                } else if (element instanceof DcsBuildPlan) {
                    DcsBuildPlan dcsPlan = (DcsBuildPlan)element;
                    CloudProject cp = dcsPlan.buildSvc().getCloudProject();
                    IBuildPlan buildPlan = dcsPlan.plan();
                    Project proj = cp.getProject();
                    if (buildPlan.getUrl() == null) {
                        String serverUrl = buildPlan.getServer().getUrl().replace("/s/", "/s2/");
                        url = String.valueOf(serverUrl) + "/job/" + proj.getIdentifier() + "." + buildPlan.getName().toLowerCase();
                    } else {
                        url = buildPlan.getUrl();
                    }
                } else if (element instanceof IBuild) {
                    IBuild build = (IBuild)element;
                    url = build.getUrl();
                    if (url == null) {
                        IBuildPlan plan = build.getPlan();
                        if (plan.getUrl() == null) {
                            url = plan.getServer().getUrl();
                        } else {
                            url = plan.getUrl();
                            if (!url.endsWith("/")) {
                                url = String.valueOf(url) + "/";
                            }
                            url = String.valueOf(url) + build.getBuildNumber();
                        }
                    }
                } else if (element instanceof TaskTask) {
                    TaskTask task = (TaskTask)element;
                    url = task.getUrl();
                }
                try {
                    CloudUiPlugin.openURL(url);
                }
                catch (Exception e) {
                    if (!Trace.SEVERE) break block28;
                    Trace.trace((String)"/severe", (String)"Error opening browser", (Throwable)e);
                }
            }
        }
    }

    public boolean canOpen(Object obj) {
        return obj instanceof DevServiceDesc || obj instanceof CloudProject || obj instanceof CloudProjectService || obj instanceof GitRepoNode || obj instanceof DcsBuildPlan || obj instanceof IBuild || obj instanceof TaskTask;
    }
}

