/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.cloud.ui.dev.action;

import java.util.List;
import oracle.eclipse.tools.cloud.dev.DcsBuildPlan;
import oracle.eclipse.tools.cloud.dev.DcsBuilds;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.mylyn.builds.core.IBuild;
import org.eclipse.mylyn.builds.core.IBuildElement;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.internal.builds.ui.editor.BuildEditorInput;
import org.eclipse.mylyn.internal.tasks.ui.util.TasksUiInternal;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.handlers.HandlerUtil;

public class OpenHandler
extends AbstractHandler {
    public void setEnabled(Object evaluationContext) {
        IEvaluationContext context = (IEvaluationContext)evaluationContext;
        Object selection = context.getVariable("selection");
        if (selection instanceof IStructuredSelection) {
            for (Object obj : (IStructuredSelection)selection) {
                if (!(obj instanceof DcsBuildPlan)) continue;
                DcsBuildPlan plan = (DcsBuildPlan)obj;
                DcsBuilds data = plan.dcsBuilds();
                if (data.available() && ((List)data.content()).size() > 0) {
                    this.setBaseEnabled(true);
                } else {
                    this.setBaseEnabled(false);
                }
                return;
            }
        }
        this.setBaseEnabled(true);
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchWindow window = HandlerUtil.getActiveWorkbenchWindowChecked((ExecutionEvent)event);
        IWorkbenchPage page = window.getActivePage();
        if (page == null) {
            throw new ExecutionException("No active workbench window");
        }
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (selection instanceof IStructuredSelection) {
            Object obj = ((IStructuredSelection)selection).getFirstElement();
            if (obj instanceof DcsBuildPlan) {
                OpenHandler.openBuildEditor(page, obj);
            } else if (obj instanceof IBuildElement) {
                OpenHandler.openBuildEditor(page, obj);
            } else if (obj instanceof ITask) {
                TasksUiInternal.openTaskInBackground((ITask)((ITask)obj), (boolean)true);
            }
        }
        return null;
    }

    public static void openBuildEditor(IWorkbenchPage page, Object element) {
        IBuild input = null;
        if (element instanceof DcsBuildPlan) {
            List builds;
            DcsBuildPlan dcsPlan = (DcsBuildPlan)element;
            IBuild build = null;
            if (dcsPlan.dcsBuilds().available()) {
                builds = (List)dcsPlan.dcsBuilds().content();
                if (builds.size() > 0) {
                    build = (IBuild)builds.get(0);
                }
            } else {
                dcsPlan.dcsBuilds().fetch(false);
                builds = (List)dcsPlan.dcsBuilds().content();
                if (builds.size() > 0) {
                    build = (IBuild)builds.get(0);
                }
            }
            if (build == null) {
                return;
            }
            input = build;
        } else if (element instanceof IBuild) {
            input = (IBuild)element;
        }
        try {
            IEditorReference[] iEditorReferenceArray = page.getEditorReferences();
            int n = iEditorReferenceArray.length;
            int build = 0;
            while (build < n) {
                IEditorInput in;
                IEditorReference e = iEditorReferenceArray[build];
                IEditorPart part = e.getEditor(false);
                if (part != null && (in = part.getEditorInput()) instanceof BuildEditorInput) {
                    BuildEditorInput buildIn = (BuildEditorInput)in;
                    if (input.getPlan() == buildIn.getBuild().getPlan() && input.getBuildNumber() == buildIn.getBuild().getBuildNumber()) {
                        page.bringToTop((IWorkbenchPart)part);
                        return;
                    }
                }
                ++build;
            }
            org.eclipse.mylyn.internal.builds.ui.commands.OpenHandler.fetchAndOpen((IWorkbenchPage)page, (IBuild)input);
        }
        catch (Exception e) {
            Status status = new Status(4, "org.eclipse.mylyn.builds.ui", "Unexpected error while opening build", (Throwable)e);
            StatusHandler.log((IStatus)status);
        }
    }
}

