/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.cloud.ui;

import java.net.MalformedURLException;
import java.net.URL;
import oracle.eclipse.tools.cloud.ui.profile.CloudProfileView;
import oracle.eclipse.tools.whitelist.WhitelistBuilder;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.wst.server.ui.internal.ServerUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public final class CloudUiPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "oracle.eclipse.tools.cloud.ui";
    private static IPreferenceStore preferences;
    private static CloudUiPlugin plugin;

    public static final Bundle bundle() {
        return Platform.getBundle((String)PLUGIN_ID);
    }

    public static final IPath state() {
        return Platform.getStateLocation((Bundle)CloudUiPlugin.bundle());
    }

    public static synchronized IPreferenceStore preferences() {
        if (preferences == null) {
            preferences = new ScopedPreferenceStore(InstanceScope.INSTANCE, PLUGIN_ID);
        }
        return preferences;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        WhitelistBuilder.addCloudProjectQuickFixListener();
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static CloudUiPlugin getDefault() {
        return plugin;
    }

    public static void log(int severity, String message, Exception e) {
        Platform.getLog((Bundle)CloudUiPlugin.bundle()).log((IStatus)new Status(severity, PLUGIN_ID, 0, message, (Throwable)e));
    }

    public static void log(Exception e) {
        CloudUiPlugin.log(4, "Encountered an unexpected exception.", e);
    }

    public static IStatus createErrorStatus(String msg, Exception e) {
        String message = msg;
        if (message == null) {
            message = "";
        }
        return new Status(4, PLUGIN_ID, 0, message, (Throwable)e);
    }

    public static IStatus createErrorStatus(int aCode, String aMessage, Throwable exception) {
        return CloudUiPlugin.createStatus(4, aCode, aMessage, exception);
    }

    public static IStatus createStatus(int severity, int aCode, String aMessage, Throwable exception) {
        return new Status(severity, PLUGIN_ID, aCode, aMessage != null ? aMessage : "No message.", exception);
    }

    public static void openURL(String url) throws PartInitException, MalformedURLException {
        boolean useExternalBrowser = true;
        IWorkbenchBrowserSupport browserSupport = ServerUIPlugin.getInstance().getWorkbench().getBrowserSupport();
        IWebBrowser browser = browserSupport.createBrowser(6, null, null, null);
        if (useExternalBrowser) {
            browser = browserSupport.getExternalBrowser();
        }
        browser.openURL(new URL(url));
    }

    public static void updateCloudViewNodeStatus(final Object node) {
        UIJob uiJob = new UIJob("Refresh Git repository status"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                CloudProfileView cloudView = (CloudProfileView)page.findView("oracle.eclipse.tools.cloud.ui.CloudProfileView");
                if (cloudView != null) {
                    cloudView.update(node);
                }
                return Status.OK_STATUS;
            }
        };
        uiJob.schedule(1000L);
    }

    public static void promptError(final String message) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Error", (String)message);
            }
        });
    }
}

