/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.view.facelets.tag.jsf.core;

import java.io.IOException;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import javax.el.ELException;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.view.facelets.FaceletContext;
import javax.faces.view.facelets.FaceletException;
import javax.faces.view.facelets.TagAttribute;
import javax.faces.view.facelets.TagAttributeException;
import javax.faces.view.facelets.TagConfig;
import javax.faces.view.facelets.TagHandler;
import org.apache.myfaces.shared.util.ClassUtils;
import org.apache.myfaces.view.facelets.tag.jsf.ComponentSupport;

public final class LoadBundleHandler
extends TagHandler {
    private final TagAttribute basename = this.getRequiredAttribute("basename");
    private final TagAttribute var = this.getRequiredAttribute("var");

    public LoadBundleHandler(TagConfig config) {
        super(config);
    }

    @Override
    public void apply(FaceletContext ctx, UIComponent parent) throws IOException, FacesException, FaceletException, ELException {
        UIViewRoot root = ComponentSupport.getViewRoot(ctx, parent);
        ResourceBundle bundle = null;
        try {
            String name = this.basename.getValue(ctx);
            ClassLoader cl = ClassUtils.getContextClassLoader();
            bundle = root != null && root.getLocale() != null ? ResourceBundle.getBundle(name, root.getLocale(), cl) : ResourceBundle.getBundle(name, Locale.getDefault(), cl);
        }
        catch (Exception e) {
            throw new TagAttributeException(this.tag, this.basename, (Throwable)e);
        }
        ResourceBundleMap map = new ResourceBundleMap(bundle);
        FacesContext faces = ctx.getFacesContext();
        faces.getExternalContext().getRequestMap().put(this.var.getValue(ctx), map);
    }

    private static final class ResourceBundleMap
    implements Map<String, String> {
        protected final ResourceBundle bundle;

        public ResourceBundleMap(ResourceBundle bundle) {
            this.bundle = bundle;
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean containsKey(Object key) {
            try {
                this.bundle.getString(key.toString());
                return true;
            }
            catch (MissingResourceException missingResourceException) {
                return false;
            }
        }

        @Override
        public boolean containsValue(Object value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Set<Map.Entry<String, String>> entrySet() {
            Enumeration<String> e = this.bundle.getKeys();
            HashSet<Map.Entry<String, String>> s = new HashSet<Map.Entry<String, String>>();
            while (e.hasMoreElements()) {
                String k = e.nextElement();
                s.add(new ResourceEntry(k, this.bundle.getString(k)));
            }
            return s;
        }

        @Override
        public String get(Object key) {
            try {
                return this.bundle.getString((String)key);
            }
            catch (MissingResourceException missingResourceException) {
                return "???" + key + "???";
            }
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public Set<String> keySet() {
            Enumeration<String> e = this.bundle.getKeys();
            HashSet<String> s = new HashSet<String>();
            while (e.hasMoreElements()) {
                s.add(e.nextElement());
            }
            return s;
        }

        @Override
        public String put(String key, String value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void putAll(Map<? extends String, ? extends String> t) {
            throw new UnsupportedOperationException();
        }

        @Override
        public String remove(Object key) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int size() {
            return this.keySet().size();
        }

        @Override
        public Collection<String> values() {
            Enumeration<String> e = this.bundle.getKeys();
            HashSet<String> s = new HashSet<String>();
            while (e.hasMoreElements()) {
                s.add(this.bundle.getString(e.nextElement()));
            }
            return s;
        }

        private static final class ResourceEntry
        implements Map.Entry<String, String> {
            protected final String key;
            protected final String value;

            public ResourceEntry(String key, String value) {
                this.key = key;
                this.value = value;
            }

            @Override
            public String getKey() {
                return this.key;
            }

            @Override
            public String getValue() {
                return this.value;
            }

            @Override
            public String setValue(String value) {
                throw new UnsupportedOperationException();
            }

            @Override
            public int hashCode() {
                return this.key.hashCode();
            }

            @Override
            public boolean equals(Object obj) {
                return obj instanceof ResourceEntry && this.hashCode() == obj.hashCode();
            }
        }
    }
}

