/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.view.facelets.tag.jsf;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.component.UIComponent;
import javax.faces.view.facelets.FaceletContext;
import javax.faces.view.facelets.MetaRule;
import javax.faces.view.facelets.Metadata;
import javax.faces.view.facelets.MetadataTarget;
import javax.faces.view.facelets.TagAttribute;

final class ComponentRule
extends MetaRule {
    private static final Logger log = Logger.getLogger(ComponentRule.class.getName());
    public static final ComponentRule INSTANCE = new ComponentRule();

    @Override
    public Metadata applyRule(String name, TagAttribute attribute, MetadataTarget meta) {
        if (meta.isTargetInstanceOf(UIComponent.class)) {
            if (!attribute.isLiteral()) {
                Class<Object> type = meta.getPropertyType(name);
                if (type == null) {
                    type = Object.class;
                }
                return new ValueExpressionMetadata(name, type, attribute);
            }
            if (meta.getWriteMethod(name) == null) {
                ComponentRule.warnAttr(attribute, meta.getTargetClass(), name);
                return new LiteralAttributeMetadata(name, attribute.getValue());
            }
        }
        return null;
    }

    private static void warnAttr(TagAttribute attr, Class<?> type, String n) {
        if (log.isLoggable(Level.FINER)) {
            log.finer(attr + " Property '" + n + "' is not on type: " + type.getName());
        }
    }

    final class LiteralAttributeMetadata
    extends Metadata {
        private final String _name;
        private final String _value;

        public LiteralAttributeMetadata(String name, String value) {
            this._name = name;
            this._value = value;
        }

        @Override
        public void applyMetadata(FaceletContext ctx, Object instance) {
            ((UIComponent)instance).getAttributes().put(this._name, this._value);
        }
    }

    static final class ValueExpressionMetadata
    extends Metadata {
        private final String _name;
        private final TagAttribute _attr;
        private final Class<?> _type;

        public ValueExpressionMetadata(String name, Class<?> type, TagAttribute attr) {
            this._name = name;
            this._attr = attr;
            this._type = type;
        }

        @Override
        public void applyMetadata(FaceletContext ctx, Object instance) {
            ((UIComponent)instance).setValueExpression(this._name, this._attr.getValueExpression(ctx, this._type));
        }
    }
}

