/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.view.facelets.tag.composite;

import java.beans.FeatureDescriptor;
import java.util.Arrays;
import javax.faces.view.facelets.FaceletContext;
import javax.faces.view.facelets.Tag;
import javax.faces.view.facelets.TagAttribute;

public final class CompositeTagAttributeUtils {
    private CompositeTagAttributeUtils() {
    }

    public static void addUnspecifiedAttributes(FeatureDescriptor descriptor, Tag tag, String[] standardAttributesSorted, FaceletContext ctx) {
        TagAttribute[] tagAttributeArray = tag.getAttributes().getAll();
        int n = tagAttributeArray.length;
        int n2 = 0;
        while (n2 < n) {
            TagAttribute attribute = tagAttributeArray[n2];
            String name = attribute.getLocalName();
            if (Arrays.binarySearch(standardAttributesSorted, name) < 0) {
                descriptor.setValue(name, attribute.getValueExpression(ctx, Object.class));
            }
            ++n2;
        }
    }

    public static boolean containsUnspecifiedAttributes(Tag tag, String[] standardAttributesSorted) {
        TagAttribute[] tagAttributeArray = tag.getAttributes().getAll();
        int n = tagAttributeArray.length;
        int n2 = 0;
        while (n2 < n) {
            TagAttribute attribute = tagAttributeArray[n2];
            String name = attribute.getLocalName();
            if (Arrays.binarySearch(standardAttributesSorted, name) < 0) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static void addDevelopmentAttributes(FeatureDescriptor descriptor, FaceletContext ctx, TagAttribute displayName, TagAttribute shortDescription, TagAttribute expert, TagAttribute hidden, TagAttribute preferred) {
        if (displayName != null) {
            descriptor.setDisplayName(displayName.getValue(ctx));
        }
        if (shortDescription != null) {
            descriptor.setShortDescription(shortDescription.getValue(ctx));
        }
        if (expert != null) {
            descriptor.setExpert(expert.getBoolean(ctx));
        }
        if (hidden != null) {
            descriptor.setHidden(hidden.getBoolean(ctx));
        }
        if (preferred != null) {
            descriptor.setPreferred(preferred.getBoolean(ctx));
        }
    }

    public static void addDevelopmentAttributesLiteral(FeatureDescriptor descriptor, TagAttribute displayName, TagAttribute shortDescription, TagAttribute expert, TagAttribute hidden, TagAttribute preferred) {
        if (displayName != null) {
            descriptor.setDisplayName(displayName.getValue());
        }
        if (shortDescription != null) {
            descriptor.setShortDescription(shortDescription.getValue());
        }
        if (expert != null) {
            descriptor.setExpert(Boolean.valueOf(expert.getValue()));
        }
        if (hidden != null) {
            descriptor.setHidden(Boolean.valueOf(hidden.getValue()));
        }
        if (preferred != null) {
            descriptor.setPreferred(Boolean.valueOf(preferred.getValue()));
        }
    }

    public static boolean areAttributesLiteral(TagAttribute ... attributes) {
        TagAttribute[] tagAttributeArray = attributes;
        int n = attributes.length;
        int n2 = 0;
        while (n2 < n) {
            TagAttribute attribute = tagAttributeArray[n2];
            if (attribute != null && !attribute.isLiteral()) {
                return false;
            }
            ++n2;
        }
        return true;
    }
}

