/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.view.facelets.tag;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import javax.faces.view.facelets.TagAttribute;
import javax.faces.view.facelets.TagAttributes;

public final class TagAttributesImpl
extends TagAttributes {
    private static final TagAttribute[] EMPTY = new TagAttribute[0];
    private final TagAttribute[] _attributes;
    private final String[] _namespaces;
    private final List<TagAttribute[]> _nsattrs;

    public TagAttributesImpl(TagAttribute[] attrs) {
        this._attributes = attrs;
        HashSet<String> set = new HashSet<String>();
        TagAttribute[] tagAttributeArray = this._attributes;
        int n = this._attributes.length;
        int n2 = 0;
        while (n2 < n) {
            TagAttribute attribute = tagAttributeArray[n2];
            set.add(attribute.getNamespace());
            ++n2;
        }
        this._namespaces = set.toArray(new String[set.size()]);
        Arrays.sort(this._namespaces);
        int size = this._namespaces.length;
        ArrayList temp = new ArrayList(size);
        int i = 0;
        while (i < size) {
            temp.add(new ArrayList());
            ++i;
        }
        TagAttribute[] tagAttributeArray2 = this._attributes;
        int n3 = this._attributes.length;
        int n4 = 0;
        while (n4 < n3) {
            TagAttribute attribute = tagAttributeArray2[n4];
            ((List)temp.get(Arrays.binarySearch(this._namespaces, attribute.getNamespace()))).add(attribute);
            ++n4;
        }
        this._nsattrs = new ArrayList<TagAttribute[]>(size);
        i = 0;
        while (i < size) {
            List l = (List)temp.get(i);
            this._nsattrs.add(l.toArray(new TagAttribute[l.size()]));
            ++i;
        }
    }

    @Override
    public TagAttribute[] getAll() {
        return this._attributes;
    }

    @Override
    public TagAttribute get(String localName) {
        return this.get("", localName);
    }

    @Override
    public TagAttribute get(String ns, String localName) {
        int idx;
        if (ns != null && localName != null && (idx = Arrays.binarySearch(this._namespaces, ns)) >= 0) {
            TagAttribute[] tagAttributeArray = this._nsattrs.get(idx);
            int n = tagAttributeArray.length;
            int n2 = 0;
            while (n2 < n) {
                TagAttribute attribute = tagAttributeArray[n2];
                if (localName.equals(attribute.getLocalName())) {
                    return attribute;
                }
                ++n2;
            }
        }
        return null;
    }

    @Override
    public TagAttribute[] getAll(String namespace) {
        int idx = 0;
        idx = namespace == null ? Arrays.binarySearch(this._namespaces, "") : Arrays.binarySearch(this._namespaces, namespace);
        if (idx >= 0) {
            return this._nsattrs.get(idx);
        }
        return EMPTY;
    }

    @Override
    public String[] getNamespaces() {
        return this._namespaces;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        TagAttribute[] tagAttributeArray = this._attributes;
        int n = this._attributes.length;
        int n2 = 0;
        while (n2 < n) {
            TagAttribute attribute = tagAttributeArray[n2];
            sb.append(attribute);
            sb.append(' ');
            ++n2;
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        return sb.toString();
    }
}

