/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.view.facelets.tag;

import java.util.Arrays;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.ExpressionFactory;
import javax.el.MethodExpression;
import javax.el.ValueExpression;
import javax.faces.view.Location;
import javax.faces.view.facelets.FaceletContext;
import javax.faces.view.facelets.TagAttribute;
import javax.faces.view.facelets.TagAttributeException;
import org.apache.myfaces.util.ExternalSpecifications;
import org.apache.myfaces.view.facelets.AbstractFaceletContext;
import org.apache.myfaces.view.facelets.el.CompositeComponentELUtils;
import org.apache.myfaces.view.facelets.el.ContextAwareTagMethodExpression;
import org.apache.myfaces.view.facelets.el.ContextAwareTagValueExpression;
import org.apache.myfaces.view.facelets.el.ContextAwareTagValueExpressionUEL;
import org.apache.myfaces.view.facelets.el.ELText;
import org.apache.myfaces.view.facelets.el.LocationMethodExpression;
import org.apache.myfaces.view.facelets.el.LocationValueExpression;
import org.apache.myfaces.view.facelets.el.LocationValueExpressionUEL;
import org.apache.myfaces.view.facelets.el.ResourceELUtils;
import org.apache.myfaces.view.facelets.el.ResourceLocationValueExpression;
import org.apache.myfaces.view.facelets.el.ResourceLocationValueExpressionUEL;
import org.apache.myfaces.view.facelets.el.TagMethodExpression;
import org.apache.myfaces.view.facelets.el.TagValueExpression;
import org.apache.myfaces.view.facelets.el.TagValueExpressionUEL;
import org.apache.myfaces.view.facelets.el.ValueExpressionMethodExpression;

public final class TagAttributeImpl
extends TagAttribute {
    private static final int EL_LITERAL = 1;
    private static final int EL_CC = 2;
    private static final int EL_CC_ATTR_ME = 4;
    private static final int EL_RESOURCE = 8;
    private final int capabilities;
    private final String localName;
    private final Location location;
    private final String namespace;
    private final String qName;
    private final String value;
    private String string;
    private volatile Object[] cachedExpression;

    public TagAttributeImpl(Location location, String ns, String localName, String qName, String value) {
        boolean literal;
        this.location = location;
        this.namespace = ns;
        this.localName = localName == null ? qName : (localName.length() > 0 ? localName : qName);
        this.qName = qName;
        this.value = value;
        try {
            literal = ELText.isLiteral(this.value);
        }
        catch (ELException e) {
            throw new TagAttributeException((TagAttribute)this, (Throwable)e);
        }
        boolean compositeComponentExpression = !literal ? CompositeComponentELUtils.isCompositeComponentExpression(this.value) : false;
        boolean compositeComponentAttrMethodExpression = compositeComponentExpression ? CompositeComponentELUtils.isCompositeComponentAttrsMethodExpression(this.value) : false;
        boolean resourceExpression = !literal ? ResourceELUtils.isResourceExpression(this.value) : false;
        this.capabilities = (literal ? 1 : 0) | (compositeComponentExpression ? 2 : 0) | (compositeComponentAttrMethodExpression ? 4 : 0) | (resourceExpression ? 8 : 0);
    }

    @Override
    public boolean getBoolean(FaceletContext ctx) {
        if ((this.capabilities & 1) != 0) {
            return Boolean.valueOf(this.value);
        }
        return (Boolean)this.getObject(ctx, Boolean.class);
    }

    @Override
    public int getInt(FaceletContext ctx) {
        if ((this.capabilities & 1) != 0) {
            return Integer.parseInt(this.value);
        }
        return ((Number)this.getObject(ctx, Integer.class)).intValue();
    }

    @Override
    public String getLocalName() {
        return this.localName;
    }

    @Override
    public Location getLocation() {
        return this.location;
    }

    @Override
    public MethodExpression getMethodExpression(FaceletContext ctx, Class type, Class[] paramTypes) {
        AbstractFaceletContext actx = (AbstractFaceletContext)ctx;
        Object[] localCachedExpression = this.cachedExpression;
        if (actx.isAllowCacheELExpressions() && localCachedExpression != null && localCachedExpression.length % 3 == 0) {
            int i = 0;
            while (i < localCachedExpression.length / 3) {
                if ((type == null && localCachedExpression[i * 3] == null || type != null && type.equals(localCachedExpression[i * 3])) && Arrays.equals(paramTypes, (Class[])localCachedExpression[i * 3 + 1])) {
                    if ((this.capabilities & 2) != 0 && localCachedExpression[i * 3 + 2] instanceof LocationMethodExpression) {
                        return ((LocationMethodExpression)localCachedExpression[i * 3 + 2]).apply(actx.getFaceletCompositionContext().getCompositeComponentLevel());
                    }
                    return (MethodExpression)localCachedExpression[i * 3 + 2];
                }
                ++i;
            }
        }
        actx.beforeConstructELExpression();
        try {
            MethodExpression methodExpression = null;
            if ((this.capabilities & 4) != 0) {
                if (ExternalSpecifications.isUnifiedELAvailable() && this.value.contains("(")) {
                    throw new ELException("Cannot add parameters to a MethodExpression pointing to cc.attrs");
                }
                ValueExpression valueExpr = this.getValueExpression(ctx, Object.class);
                methodExpression = new ValueExpressionMethodExpression(valueExpr);
                methodExpression = actx.getFaceletCompositionContext().isWrapTagExceptionsAsContextAware() ? new ContextAwareTagMethodExpression(this, methodExpression) : new TagMethodExpression(this, methodExpression);
            } else {
                ExpressionFactory f = ctx.getExpressionFactory();
                methodExpression = f.createMethodExpression((ELContext)ctx, this.value, type, paramTypes);
                methodExpression = actx.getFaceletCompositionContext().isWrapTagExceptionsAsContextAware() ? new ContextAwareTagMethodExpression(this, methodExpression) : new TagMethodExpression(this, methodExpression);
                if ((this.capabilities & 2) != 0) {
                    methodExpression = new LocationMethodExpression(this.getLocation(), methodExpression, actx.getFaceletCompositionContext().getCompositeComponentLevel());
                }
            }
            if (actx.isAllowCacheELExpressions() && !actx.isAnyFaceletsVariableResolved()) {
                if (localCachedExpression != null && localCachedExpression.length % 3 == 0) {
                    Object[] array = new Object[localCachedExpression.length + 3];
                    array[0] = type;
                    array[1] = paramTypes;
                    array[2] = methodExpression;
                    int i = 0;
                    while (i < localCachedExpression.length) {
                        array[i + 3] = localCachedExpression[i];
                        ++i;
                    }
                    this.cachedExpression = array;
                } else {
                    this.cachedExpression = new Object[]{type, paramTypes, methodExpression};
                }
            }
            MethodExpression methodExpression2 = methodExpression;
            return methodExpression2;
        }
        catch (Exception e) {
            throw new TagAttributeException((TagAttribute)this, (Throwable)e);
        }
        finally {
            actx.afterConstructELExpression();
        }
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    @Override
    public Object getObject(FaceletContext ctx) {
        return this.getObject(ctx, Object.class);
    }

    @Override
    public String getQName() {
        return this.qName;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public String getValue(FaceletContext ctx) {
        if ((this.capabilities & 1) != 0) {
            return this.value;
        }
        return (String)this.getObject(ctx, String.class);
    }

    @Override
    public Object getObject(FaceletContext ctx, Class type) {
        if ((this.capabilities & 1) != 0) {
            if (String.class.equals((Object)type)) {
                return this.value;
            }
            try {
                return ctx.getExpressionFactory().coerceToType((Object)this.value, type);
            }
            catch (Exception e) {
                throw new TagAttributeException((TagAttribute)this, (Throwable)e);
            }
        }
        ValueExpression ve = this.getValueExpression(ctx, type);
        try {
            return ve.getValue((ELContext)ctx);
        }
        catch (Exception e) {
            throw new TagAttributeException((TagAttribute)this, (Throwable)e);
        }
    }

    @Override
    public ValueExpression getValueExpression(FaceletContext ctx, Class type) {
        AbstractFaceletContext actx = (AbstractFaceletContext)ctx;
        Object[] localCachedExpression = this.cachedExpression;
        if (actx.isAllowCacheELExpressions() && localCachedExpression != null && localCachedExpression.length == 2) {
            if (localCachedExpression[0] == null && type == null) {
                if ((this.capabilities & 2) != 0) {
                    return ((LocationValueExpression)localCachedExpression[1]).apply(actx.getFaceletCompositionContext().getCompositeComponentLevel());
                }
                return (ValueExpression)localCachedExpression[1];
            }
            if (localCachedExpression[0] != null && localCachedExpression[0].equals(type)) {
                if ((this.capabilities & 2) != 0) {
                    return ((LocationValueExpression)localCachedExpression[1]).apply(actx.getFaceletCompositionContext().getCompositeComponentLevel());
                }
                return (ValueExpression)localCachedExpression[1];
            }
        }
        actx.beforeConstructELExpression();
        try {
            ExpressionFactory f = ctx.getExpressionFactory();
            ValueExpression valueExpression = f.createValueExpression((ELContext)ctx, this.value, type);
            valueExpression = ExternalSpecifications.isUnifiedELAvailable() ? (actx.getFaceletCompositionContext().isWrapTagExceptionsAsContextAware() ? new ContextAwareTagValueExpressionUEL(this, valueExpression) : new TagValueExpressionUEL(this, valueExpression)) : (actx.getFaceletCompositionContext().isWrapTagExceptionsAsContextAware() ? new ContextAwareTagValueExpression(this, valueExpression) : new TagValueExpression(this, valueExpression));
            if ((this.capabilities & 2) != 0) {
                valueExpression = ExternalSpecifications.isUnifiedELAvailable() ? new LocationValueExpressionUEL(this.getLocation(), valueExpression, actx.getFaceletCompositionContext().getCompositeComponentLevel()) : new LocationValueExpression(this.getLocation(), valueExpression, actx.getFaceletCompositionContext().getCompositeComponentLevel());
            } else if ((this.capabilities & 8) != 0) {
                valueExpression = ExternalSpecifications.isUnifiedELAvailable() ? new ResourceLocationValueExpressionUEL(this.getLocation(), valueExpression) : new ResourceLocationValueExpression(this.getLocation(), valueExpression);
            }
            if (actx.isAllowCacheELExpressions() && !actx.isAnyFaceletsVariableResolved()) {
                this.cachedExpression = new Object[]{type, valueExpression};
            }
            ValueExpression valueExpression2 = valueExpression;
            return valueExpression2;
        }
        catch (Exception e) {
            throw new TagAttributeException((TagAttribute)this, (Throwable)e);
        }
        finally {
            actx.afterConstructELExpression();
        }
    }

    @Override
    public boolean isLiteral() {
        return (this.capabilities & 1) != 0;
    }

    public String toString() {
        if (this.string == null) {
            this.string = this.location + " " + this.qName + "=\"" + this.value + "\"";
        }
        return this.string;
    }
}

