/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.view.facelets.impl;

import java.io.IOException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.el.ELException;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.view.facelets.FaceletContext;
import javax.faces.view.facelets.FaceletException;
import org.apache.myfaces.util.AbstractAttributeMap;
import org.apache.myfaces.view.facelets.AbstractFacelet;
import org.apache.myfaces.view.facelets.AbstractFaceletContext;
import org.apache.myfaces.view.facelets.Facelet;
import org.apache.myfaces.view.facelets.PageContext;
import org.apache.myfaces.view.facelets.TemplateClient;
import org.apache.myfaces.view.facelets.TemplateContext;
import org.apache.myfaces.view.facelets.TemplateManager;
import org.apache.myfaces.view.facelets.impl.DefaultFaceletContext;

public class TemplateContextImpl
extends TemplateContext {
    private static final TemplateClient INITIAL_TEMPLATE_CLIENT = new InitialTemplateClient();
    private static final PageContext INITIAL_PAGE_CONTEXT = new InitialPageContext();
    private final LinkedList<TemplateManagerImpl> _clients = new LinkedList();
    private TemplateManager _compositeComponentClient;
    private TemplateManagerImpl _lastClient;
    private boolean _isCacheELExpressions;

    public TemplateContextImpl() {
        this._clients.add(new TemplateManagerImpl(null, INITIAL_TEMPLATE_CLIENT, true, INITIAL_PAGE_CONTEXT));
        this._lastClient = this._clients.getFirst();
        this._isCacheELExpressions = true;
    }

    @Override
    public TemplateManager popClient(AbstractFaceletContext actx) {
        this._lastClient = null;
        return this._clients.removeFirst();
    }

    @Override
    public void pushClient(AbstractFaceletContext actx, AbstractFacelet owner, TemplateClient client) {
        this._clients.addFirst(new TemplateManagerImpl(owner, client, true, actx.getPageContext()));
        this._lastClient = this._clients.getFirst();
    }

    @Override
    public TemplateManager popExtendedClient(AbstractFaceletContext actx) {
        this._lastClient = null;
        return this._clients.removeLast();
    }

    @Override
    public void extendClient(AbstractFaceletContext actx, AbstractFacelet owner, TemplateClient client) {
        this._clients.addLast(new TemplateManagerImpl(owner, client, false, actx.getPageContext()));
        this._lastClient = this._clients.getLast();
    }

    @Override
    public boolean includeDefinition(FaceletContext ctx, Facelet owner, UIComponent parent, String name) throws IOException, FaceletException, FacesException, ELException {
        boolean found = false;
        Iterator itr = this._clients.iterator();
        while (itr.hasNext() && !found) {
            TemplateManager client = (TemplateManager)itr.next();
            if (client.equals(owner)) continue;
            found = client.apply(ctx, parent, name);
        }
        return found;
    }

    @Override
    public TemplateManager getCompositeComponentClient() {
        return this._compositeComponentClient;
    }

    @Override
    public void setCompositeComponentClient(TemplateManager compositeComponentClient) {
        this._compositeComponentClient = compositeComponentClient;
    }

    @Override
    public ValueExpression getParameter(String key) {
        for (TemplateManagerImpl client : this._clients) {
            if (client.isParamentersMapEmpty() || !client.getParametersMap().containsKey(key)) continue;
            return client.getParametersMap().get(key);
        }
        return null;
    }

    @Override
    public void setParameter(String key, ValueExpression value) {
        if (this._lastClient != null) {
            this._lastClient.getParametersMap().put(key, value);
        }
    }

    @Override
    public boolean isParameterEmpty() {
        for (TemplateManagerImpl client : this._clients) {
            if (client.isParamentersMapEmpty()) continue;
            return false;
        }
        return true;
    }

    @Override
    public Map<String, ValueExpression> getParameterMap() {
        return new TemplateClientAttributeMap();
    }

    @Override
    public boolean isAllowCacheELExpressions() {
        return this._isCacheELExpressions;
    }

    @Override
    public void setAllowCacheELExpressions(boolean cacheELExpressions) {
        this._isCacheELExpressions = cacheELExpressions;
    }

    public static final class InitialPageContext
    extends PageContext {
        private boolean _isCacheELExpressions = true;

        @Override
        public Map<String, ValueExpression> getAttributes() {
            return Collections.emptyMap();
        }

        @Override
        public int getAttributeCount() {
            return 0;
        }

        @Override
        public boolean isAllowCacheELExpressions() {
            return this._isCacheELExpressions;
        }

        @Override
        public void setAllowCacheELExpressions(boolean cacheELExpressions) {
            this._isCacheELExpressions = cacheELExpressions;
        }
    }

    public static final class InitialTemplateClient
    implements TemplateClient {
        @Override
        public boolean apply(FaceletContext ctx, UIComponent parent, String name) throws IOException, FacesException, FaceletException, ELException {
            return false;
        }
    }

    private static class ParameterNameEnumeration
    implements Enumeration<String> {
        private final String[] _parameterNames;
        private final int _length;
        private int _index;

        public ParameterNameEnumeration(String[] parameterNames) {
            this._parameterNames = parameterNames;
            this._length = parameterNames.length;
        }

        @Override
        public boolean hasMoreElements() {
            return this._index < this._length;
        }

        @Override
        public String nextElement() {
            if (!this.hasMoreElements()) {
                throw new NoSuchElementException();
            }
            return this._parameterNames[this._index++];
        }
    }

    private final class TemplateClientAttributeMap
    extends AbstractAttributeMap<ValueExpression> {
        @Override
        protected ValueExpression getAttribute(String key) {
            for (TemplateManagerImpl client : TemplateContextImpl.this._clients) {
                if (client.isParamentersMapEmpty() || !client.getParametersMap().containsKey(key)) continue;
                return client.getParametersMap().get(key);
            }
            return null;
        }

        @Override
        protected void setAttribute(String key, ValueExpression value) {
            if (TemplateContextImpl.this._lastClient != null) {
                TemplateContextImpl.this._lastClient.getParametersMap().put(key, value);
            }
        }

        @Override
        protected void removeAttribute(String key) {
            if (TemplateContextImpl.this._lastClient != null) {
                TemplateContextImpl.this._lastClient.getParametersMap().remove(key);
            }
        }

        @Override
        protected Enumeration<String> getAttributeNames() {
            HashSet<String> attributeNames = new HashSet<String>();
            for (TemplateManagerImpl client : TemplateContextImpl.this._clients) {
                if (client.isParamentersMapEmpty()) continue;
                attributeNames.addAll(client.getParametersMap().keySet());
            }
            return new ParameterNameEnumeration(attributeNames.toArray(new String[attributeNames.size()]));
        }
    }

    private static final class TemplateManagerImpl
    extends TemplateManager
    implements TemplateClient {
        private final AbstractFacelet _owner;
        private final TemplateClient _target;
        private final boolean _root;
        private Set<String> _names;
        private final PageContext _pageContext;
        private Map<String, ValueExpression> _parameters = null;

        public TemplateManagerImpl(AbstractFacelet owner, TemplateClient target, boolean root, PageContext pageContext) {
            this._owner = owner;
            this._target = target;
            this._root = root;
            this._pageContext = pageContext;
        }

        @Override
        public boolean apply(FaceletContext ctx, UIComponent parent, String name) throws IOException, FacesException, FaceletException, ELException {
            String testName;
            String string = testName = name != null ? name : "facelets._NULL_DEF_";
            if (this._owner == null) {
                return false;
            }
            if (this._names != null && this._names.contains(testName)) {
                return false;
            }
            if (this._names == null) {
                this._names = new HashSet<String>();
            }
            this._names.add(testName);
            boolean found = false;
            DefaultFaceletContext actx = new DefaultFaceletContext((DefaultFaceletContext)ctx, this._owner, false);
            ctx.getFacesContext().getAttributes().put("com.sun.faces.facelets.FACELET_CONTEXT", (Object)actx);
            try {
                ((AbstractFaceletContext)actx).pushPageContext(this._pageContext);
                found = this._target.apply(actx, parent, name);
            }
            finally {
                ((AbstractFaceletContext)actx).popPageContext();
            }
            ctx.getFacesContext().getAttributes().put("com.sun.faces.facelets.FACELET_CONTEXT", (Object)ctx);
            this._names.remove(testName);
            return found;
        }

        public Map<String, ValueExpression> getParametersMap() {
            if (this._parameters == null) {
                this._parameters = new HashMap<String, ValueExpression>();
            }
            return this._parameters;
        }

        public boolean isParamentersMapEmpty() {
            return this._parameters == null ? true : this._parameters.isEmpty();
        }

        public boolean equals(Object o) {
            if (this._owner != null) {
                return this._owner == o || this._target == o;
            }
            return this._target == o;
        }

        public int hashCode() {
            int result = this._owner != null ? this._owner.hashCode() : 0;
            result = 31 * result + (this._target != null ? this._target.hashCode() : 0);
            return result;
        }

        public boolean isRoot() {
            return this._root;
        }
    }
}

