/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.view.facelets.el;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.el.FunctionMapper;
import org.apache.myfaces.view.facelets.util.ReflectionUtil;

public final class DefaultFunctionMapper
extends FunctionMapper
implements Externalizable {
    private static final long serialVersionUID = 1L;
    private Map<String, Function> _functions = null;

    public Method resolveFunction(String prefix, String localName) {
        if (this._functions != null) {
            Function f = this._functions.get(String.valueOf(prefix) + ":" + localName);
            return f.getMethod();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFunction(String prefix, String localName, Method m) {
        if (this._functions == null) {
            this._functions = new HashMap<String, Function>();
        }
        Function f = new Function(prefix, localName, m);
        DefaultFunctionMapper defaultFunctionMapper = this;
        synchronized (defaultFunctionMapper) {
            this._functions.put(String.valueOf(prefix) + ":" + localName, f);
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this._functions);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this._functions = (Map)in.readObject();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(128);
        sb.append("FunctionMapper[\n");
        for (Function function : this._functions.values()) {
            sb.append(function).append('\n');
        }
        sb.append(']');
        return sb.toString();
    }

    private static class Function
    implements Externalizable {
        private static final long serialVersionUID = 1L;
        protected transient Method _m;
        protected String _owner;
        protected String _name;
        protected String[] _types;
        protected String _prefix;
        protected String _localName;

        public Function(String prefix, String localName, Method m) {
            if (localName == null) {
                throw new NullPointerException("LocalName cannot be null");
            }
            if (m == null) {
                throw new NullPointerException("Method cannot be null");
            }
            this._prefix = prefix;
            this._localName = localName;
            this._m = m;
        }

        public Function() {
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeUTF(this._prefix != null ? this._prefix : "");
            out.writeUTF(this._localName);
            out.writeUTF(this._m.getDeclaringClass().getName());
            out.writeUTF(this._m.getName());
            out.writeObject(ReflectionUtil.toTypeNameArray(this._m.getParameterTypes()));
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this._prefix = in.readUTF();
            if ("".equals(this._prefix)) {
                this._prefix = null;
            }
            this._localName = in.readUTF();
            this._owner = in.readUTF();
            this._name = in.readUTF();
            this._types = (String[])in.readObject();
        }

        public Method getMethod() {
            if (this._m == null) {
                try {
                    Class<?> t = ReflectionUtil.forName(this._owner);
                    Class<?>[] p = ReflectionUtil.toTypeArray(this._types);
                    this._m = t.getMethod(this._name, p);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return this._m;
        }

        public boolean matches(String prefix, String localName) {
            if (this._prefix != null) {
                if (prefix == null) {
                    return false;
                }
                if (!this._prefix.equals(prefix)) {
                    return false;
                }
            }
            return this._localName.equals(localName);
        }

        public boolean equals(Object obj) {
            if (obj instanceof Function) {
                return this.hashCode() == obj.hashCode();
            }
            return false;
        }

        public int hashCode() {
            return (String.valueOf(this._prefix) + this._localName).hashCode();
        }

        public String toString() {
            StringBuffer sb = new StringBuffer(32);
            sb.append("Function[");
            if (this._prefix != null) {
                sb.append(this._prefix).append(':');
            }
            sb.append(this._name).append("] ");
            sb.append(this._m);
            return sb.toString();
        }
    }
}

