/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.view.facelets.el;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.view.Location;

public final class CompositeComponentELUtils {
    public static final String CURRENT_COMPOSITE_COMPONENT_KEY = "org.apache.myfaces.compositecomponent.current";
    public static final String LOCATION_KEY = "org.apache.myfaces.compositecomponent.location";
    public static final String LEVEL_KEY = "oam.cc.ccLevel";
    public static final Pattern CC_EXPRESSION_REGEX = Pattern.compile(".*[^\\w\\.]cc[^\\w].*");
    public static final Pattern CC_ATTRS_METHOD_EXPRESSION_REGEX = Pattern.compile("[^\\(]*[^\\w\\.\\(]cc\\.attrs\\.[^\\.]*(\\(.*)?");
    private static final String CC = "cc";
    private static final String CC_ATTRS = "cc.attrs";
    public static final String CC_FIND_COMPONENT_EXPRESSION = "oam.CC_FIND_COMPONENT_EXPRESSION";

    private CompositeComponentELUtils() {
    }

    /*
     * Unable to fully structure code
     */
    public static UIComponent getCompositeComponentBasedOnLocation(FacesContext facesContext, Location location) {
        block10: {
            block9: {
                currentComponent = UIComponent.getCurrentComponent(facesContext);
                if (currentComponent == null) {
                    return null;
                }
                currentCompositeComponent = UIComponent.getCurrentCompositeComponent(facesContext);
                if (currentCompositeComponent != null && (componentLocation = (Location)currentCompositeComponent.getAttributes().get("org.apache.myfaces.compositecomponent.location")) != null && componentLocation.getPath().equals(location.getPath())) {
                    return currentCompositeComponent;
                }
                matchingCompositeComponent = CompositeComponentELUtils.lookForCompositeComponentOnStack(facesContext, location, currentComponent);
                if (matchingCompositeComponent != null) {
                    return matchingCompositeComponent;
                }
                if (currentCompositeComponent == null) break block9;
                currentComponent = currentCompositeComponent;
                break block10;
            }
            found = false;
            while (currentComponent != null && !found) {
                block11: {
                    findComponentExpr = (String)currentComponent.getAttributes().get("oam.CC_FIND_COMPONENT_EXPRESSION");
                    if (findComponentExpr == null || (foundComponent = facesContext.getViewRoot().findComponent(findComponentExpr)) == null) break block11;
                    foundComponentLocation = (Location)currentComponent.getAttributes().get("org.apache.myfaces.compositecomponent.location");
                    if (foundComponentLocation == null || !foundComponentLocation.getPath().equals(location.getPath())) ** GOTO lbl25
                    return foundComponent;
lbl-1000:
                    // 1 sources

                    {
                        componentLocation = (Location)foundComponent.getAttributes().get("org.apache.myfaces.compositecomponent.location");
                        if (componentLocation != null && componentLocation.getPath().equals(location.getPath())) {
                            return foundComponent;
                        }
                        foundComponent = UIComponent.getCompositeComponentParent(foundComponent);
lbl25:
                        // 2 sources

                        ** while (foundComponent != null)
                    }
                }
                if (UIComponent.isCompositeComponent(currentComponent)) {
                    found = true;
                    continue;
                }
                currentComponent = currentComponent.getParent();
            }
        }
        while (currentComponent != null) {
            componentLocation = (Location)currentComponent.getAttributes().get("org.apache.myfaces.compositecomponent.location");
            if (componentLocation != null && componentLocation.getPath().equals(location.getPath())) {
                return currentComponent;
            }
            currentComponent = UIComponent.getCompositeComponentParent(currentComponent);
        }
        return null;
    }

    private static UIComponent lookForCompositeComponentOnStack(FacesContext facesContext, Location location, UIComponent currentComponent) {
        Location componentLocation;
        if (UIComponent.isCompositeComponent(currentComponent) && (componentLocation = (Location)currentComponent.getAttributes().get(LOCATION_KEY)) != null && componentLocation.getPath().equals(location.getPath())) {
            return currentComponent;
        }
        currentComponent.popComponentFromEL(facesContext);
        try {
            UIComponent c = UIComponent.getCurrentComponent(facesContext);
            if (c != null) {
                UIComponent uIComponent = CompositeComponentELUtils.lookForCompositeComponentOnStack(facesContext, location, c);
                return uIComponent;
            }
            return null;
        }
        finally {
            currentComponent.pushComponentToEL(facesContext, currentComponent);
        }
    }

    private static int getCCLevel(UIComponent component) {
        Integer ccLevel = (Integer)component.getAttributes().get(LEVEL_KEY);
        if (ccLevel == null) {
            return 0;
        }
        return ccLevel;
    }

    /*
     * Unable to fully structure code
     */
    public static UIComponent getCompositeComponentBasedOnLocation(FacesContext facesContext, Location location, int ccLevel) {
        block10: {
            block9: {
                currentComponent = UIComponent.getCurrentComponent(facesContext);
                if (currentComponent == null) {
                    return null;
                }
                currentCompositeComponent = UIComponent.getCurrentCompositeComponent(facesContext);
                if (currentCompositeComponent != null && (componentLocation = (Location)currentCompositeComponent.getAttributes().get("org.apache.myfaces.compositecomponent.location")) != null && componentLocation.getPath().equals(location.getPath()) && ccLevel == CompositeComponentELUtils.getCCLevel(currentCompositeComponent)) {
                    return currentCompositeComponent;
                }
                matchingCompositeComponent = CompositeComponentELUtils.lookForCompositeComponentOnStack(facesContext, location, ccLevel, currentComponent);
                if (matchingCompositeComponent != null) {
                    return matchingCompositeComponent;
                }
                if (currentCompositeComponent == null) break block9;
                currentComponent = currentCompositeComponent;
                break block10;
            }
            found = false;
            while (currentComponent != null && !found) {
                block11: {
                    findComponentExpr = (String)currentComponent.getAttributes().get("oam.CC_FIND_COMPONENT_EXPRESSION");
                    if (findComponentExpr == null || (foundComponent = facesContext.getViewRoot().findComponent(findComponentExpr)) == null) break block11;
                    foundComponentLocation = (Location)currentComponent.getAttributes().get("org.apache.myfaces.compositecomponent.location");
                    if (foundComponentLocation == null || !foundComponentLocation.getPath().equals(location.getPath()) || ccLevel != CompositeComponentELUtils.getCCLevel(foundComponent)) ** GOTO lbl25
                    return foundComponent;
lbl-1000:
                    // 1 sources

                    {
                        componentLocation = (Location)foundComponent.getAttributes().get("org.apache.myfaces.compositecomponent.location");
                        if (componentLocation != null && componentLocation.getPath().equals(location.getPath()) && ccLevel == CompositeComponentELUtils.getCCLevel(foundComponent)) {
                            return foundComponent;
                        }
                        foundComponent = UIComponent.getCompositeComponentParent(foundComponent);
lbl25:
                        // 2 sources

                        ** while (foundComponent != null)
                    }
                }
                if (UIComponent.isCompositeComponent(currentComponent)) {
                    found = true;
                    continue;
                }
                currentComponent = currentComponent.getParent();
            }
        }
        while (currentComponent != null) {
            componentLocation = (Location)currentComponent.getAttributes().get("org.apache.myfaces.compositecomponent.location");
            if (componentLocation != null && componentLocation.getPath().equals(location.getPath()) && ccLevel == CompositeComponentELUtils.getCCLevel(currentComponent)) {
                return currentComponent;
            }
            currentComponent = UIComponent.getCompositeComponentParent(currentComponent);
        }
        return null;
    }

    private static UIComponent lookForCompositeComponentOnStack(FacesContext facesContext, Location location, int ccLevel, UIComponent currentComponent) {
        Location componentLocation;
        if (UIComponent.isCompositeComponent(currentComponent) && (componentLocation = (Location)currentComponent.getAttributes().get(LOCATION_KEY)) != null && componentLocation.getPath().equals(location.getPath()) && ccLevel == CompositeComponentELUtils.getCCLevel(currentComponent)) {
            return currentComponent;
        }
        currentComponent.popComponentFromEL(facesContext);
        try {
            UIComponent c = UIComponent.getCurrentComponent(facesContext);
            if (c != null) {
                UIComponent uIComponent = CompositeComponentELUtils.lookForCompositeComponentOnStack(facesContext, location, ccLevel, c);
                return uIComponent;
            }
            return null;
        }
        finally {
            currentComponent.pushComponentToEL(facesContext, currentComponent);
        }
    }

    public static void saveCompositeComponentForResolver(FacesContext facesContext, Location location, int ccLevel) {
        UIComponent cc = ccLevel > 0 ? CompositeComponentELUtils.getCompositeComponentBasedOnLocation(facesContext, location, ccLevel) : CompositeComponentELUtils.getCompositeComponentBasedOnLocation(facesContext, location);
        ArrayList<UIComponent> list = (ArrayList<UIComponent>)facesContext.getAttributes().get(CURRENT_COMPOSITE_COMPONENT_KEY);
        if (list == null) {
            list = new ArrayList<UIComponent>();
            facesContext.getAttributes().put(CURRENT_COMPOSITE_COMPONENT_KEY, list);
        }
        list.add(cc);
    }

    public static void removeCompositeComponentForResolver(FacesContext facesContext) {
        List list = (List)facesContext.getAttributes().get(CURRENT_COMPOSITE_COMPONENT_KEY);
        if (list != null) {
            list.remove(list.size() - 1);
        }
    }

    public static boolean isCompositeComponentExpression(String expression) {
        if (expression.contains(CC)) {
            return CC_EXPRESSION_REGEX.matcher(expression).matches();
        }
        return false;
    }

    public static boolean isCompositeComponentAttrsMethodExpression(String expression) {
        if (expression.contains(CC_ATTRS)) {
            return CC_ATTRS_METHOD_EXPRESSION_REGEX.matcher(expression).matches();
        }
        return false;
    }
}

