/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.view.facelets.compiler;

import java.io.IOException;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.ExpressionFactory;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.myfaces.view.facelets.compiler.Instruction;
import org.apache.myfaces.view.facelets.el.ELText;

final class AttributeInstruction
implements Instruction {
    private final String _alias;
    private final String _attr;
    private final ELText _txt;

    public AttributeInstruction(String alias, String attr, ELText txt) {
        this._alias = alias;
        this._attr = attr;
        this._txt = txt;
    }

    @Override
    public void write(FacesContext context) throws IOException {
        ResponseWriter out = context.getResponseWriter();
        try {
            out.writeAttribute(this._attr, this._txt.toString(context.getELContext()), null);
        }
        catch (ELException e) {
            throw new ELException(String.valueOf(this._alias) + ": " + e.getMessage(), e.getCause());
        }
        catch (Exception e) {
            throw new ELException(String.valueOf(this._alias) + ": " + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public Instruction apply(ExpressionFactory factory, ELContext ctx) {
        ELText nt = this._txt.apply(factory, ctx);
        if (nt == this._txt) {
            return this;
        }
        return new AttributeInstruction(this._alias, this._attr, nt);
    }

    @Override
    public boolean isLiteral() {
        return this._txt.isLiteral();
    }
}

