/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.shared.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.lang.reflect.Proxy;
import org.apache.myfaces.shared.util.ClassUtils;

public class MyFacesObjectInputStream
extends ObjectInputStream {
    public MyFacesObjectInputStream(InputStream in) throws IOException {
        super(in);
    }

    protected Class resolveClass(ObjectStreamClass desc) throws ClassNotFoundException, IOException {
        try {
            return ClassUtils.classForName(desc.getName());
        }
        catch (ClassNotFoundException classNotFoundException) {
            return super.resolveClass(desc);
        }
    }

    protected Class resolveProxyClass(String[] interfaces) throws IOException, ClassNotFoundException {
        Class[] cinterfaces = new Class[interfaces.length];
        int i = 0;
        while (i < interfaces.length) {
            cinterfaces[i] = ClassUtils.classForName(interfaces[i]);
            ++i;
        }
        try {
            return Proxy.getProxyClass(ClassUtils.getContextClassLoader(), cinterfaces);
        }
        catch (Exception exception) {
            try {
                return Proxy.getProxyClass(MyFacesObjectInputStream.class.getClassLoader(), cinterfaces);
            }
            catch (IllegalArgumentException e) {
                throw new ClassNotFoundException(e.toString(), e);
            }
        }
    }
}

