/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.shared.renderkit.html.util;

import java.io.IOException;
import java.io.Writer;

public abstract class UnicodeEncoder {
    public static String encode(String string) {
        if (string == null) {
            return "";
        }
        StringBuilder sb = null;
        int i = 0;
        while (i < string.length()) {
            char c = string.charAt(i);
            if (c >= '\u0080') {
                if (sb == null) {
                    sb = new StringBuilder(string.length() + 4);
                    sb.append(string.substring(0, i));
                }
                sb.append("&#");
                sb.append((int)c);
                sb.append(";");
            } else if (sb != null) {
                sb.append(c);
            }
            ++i;
        }
        return sb != null ? sb.toString() : string;
    }

    public static void encode(Writer writer, String string) throws IOException {
        if (string == null) {
            return;
        }
        int start = 0;
        int i = 0;
        while (i < string.length()) {
            char c = string.charAt(i);
            if (c >= '\u0080') {
                if (start < i) {
                    writer.write(string, start, i - start);
                }
                start = i + 1;
                writer.write("&#");
                writer.write(Integer.toString(c));
                writer.write(";");
            }
            ++i;
        }
        if (start == 0) {
            writer.write(string);
        } else if (start < string.length()) {
            writer.write(string, start, string.length() - start);
        }
    }

    public static void encode(Writer writer, char[] cbuf, int off, int len) throws IOException {
        if (cbuf == null) {
            return;
        }
        int start = off;
        int i = off;
        while (i < off + len) {
            char c = cbuf[i];
            if (c >= '\u0080') {
                if (start < i) {
                    writer.write(cbuf, start, i - start);
                }
                start = i + 1;
                writer.write("&#");
                writer.write(Integer.toString(c));
                writer.write(";");
            }
            ++i;
        }
        if (start == off) {
            writer.write(cbuf, off, len);
        } else if (start < off + len) {
            writer.write(cbuf, start, off + len - start);
        }
    }

    public static void encode(Writer writer, String cbuf, int off, int len) throws IOException {
        if (cbuf == null) {
            return;
        }
        int start = off;
        int i = off;
        while (i < off + len) {
            char c = cbuf.charAt(i);
            if (c >= '\u0080') {
                if (start < i) {
                    writer.write(cbuf, start, i - start);
                }
                start = i + 1;
                writer.write("&#");
                writer.write(Integer.toString(c));
                writer.write(";");
            }
            ++i;
        }
        if (start == off) {
            writer.write(cbuf, off, len);
        } else if (start < off + len) {
            writer.write(cbuf, start, off + len - start);
        }
    }
}

