/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.shared.application;

import java.net.MalformedURLException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.application.ProjectStage;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.view.ViewDeclarationLanguage;
import org.apache.myfaces.shared.application.FacesServletMapping;
import org.apache.myfaces.shared.application.InvalidViewIdException;
import org.apache.myfaces.shared.application.ViewHandlerSupport;
import org.apache.myfaces.shared.renderkit.html.util.SharedStringBuilder;
import org.apache.myfaces.shared.util.ConcurrentLRUCache;
import org.apache.myfaces.shared.util.ExternalContextUtils;
import org.apache.myfaces.shared.util.StringUtils;
import org.apache.myfaces.shared.util.WebConfigParamUtils;

public class DefaultViewHandlerSupport
implements ViewHandlerSupport {
    private static final String CACHED_SERVLET_MAPPING = String.valueOf(DefaultViewHandlerSupport.class.getName()) + ".CACHED_SERVLET_MAPPING";
    private static final Logger log = Logger.getLogger(DefaultViewHandlerSupport.class.getName());
    private static final String CHECKED_VIEWID_CACHE_SIZE_ATTRIBUTE = "org.apache.myfaces.CHECKED_VIEWID_CACHE_SIZE";
    private static final int CHECKED_VIEWID_CACHE_DEFAULT_SIZE = 500;
    private static final String CHECKED_VIEWID_CACHE_ENABLED_ATTRIBUTE = "org.apache.myfaces.CHECKED_VIEWID_CACHE_ENABLED";
    private static final boolean CHECKED_VIEWID_CACHE_ENABLED_DEFAULT = true;
    private static final String VIEW_HANDLER_SUPPORT_SB = "oam.viewhandler.SUPPORT_SB";
    private volatile ConcurrentLRUCache<String, Boolean> _checkedViewIdMap = null;
    private Boolean _checkedViewIdCacheEnabled = null;
    private final String[] _faceletsViewMappings;
    private final String[] _contextSuffixes;
    private final String _faceletsContextSufix;
    private final boolean _initialized;

    public DefaultViewHandlerSupport() {
        this._faceletsViewMappings = null;
        this._contextSuffixes = null;
        this._faceletsContextSufix = null;
        this._initialized = false;
    }

    public DefaultViewHandlerSupport(FacesContext facesContext) {
        this._faceletsViewMappings = this.getFaceletsViewMappings(facesContext);
        this._contextSuffixes = this.getContextSuffix(facesContext);
        this._faceletsContextSufix = this.getFaceletsContextSuffix(facesContext);
        this._initialized = true;
    }

    @Override
    public String calculateViewId(FacesContext context, String viewId) {
        if (viewId == null) {
            return null;
        }
        FacesServletMapping mapping = this.getFacesServletMapping(context);
        if (mapping == null || mapping.isExtensionMapping()) {
            viewId = this.handleSuffixMapping(context, viewId);
        } else if (mapping.isPrefixMapping()) {
            if ((viewId = this.handlePrefixMapping(viewId, mapping.getPrefix())) != null && viewId.equals(mapping.getPrefix()) && !ExternalContextUtils.isPortlet(context.getExternalContext())) {
                throw new InvalidViewIdException();
            }
        } else if (viewId != null && mapping.getUrlPattern().startsWith(viewId)) {
            throw new InvalidViewIdException(viewId);
        }
        return viewId;
    }

    @Override
    public String calculateAndCheckViewId(FacesContext context, String viewId) {
        if (viewId == null) {
            return null;
        }
        FacesServletMapping mapping = this.getFacesServletMapping(context);
        if (mapping == null || mapping.isExtensionMapping()) {
            viewId = this.handleSuffixMapping(context, viewId);
        } else if (mapping.isPrefixMapping()) {
            if ((viewId = this.handlePrefixMapping(viewId, mapping.getPrefix())) != null) {
                if (viewId != null && viewId.equals(mapping.getPrefix()) && !ExternalContextUtils.isPortlet(context.getExternalContext())) {
                    throw new InvalidViewIdException();
                }
                return this.checkResourceExists(context, viewId) ? viewId : null;
            }
        } else {
            if (viewId != null && mapping.getUrlPattern().startsWith(viewId)) {
                throw new InvalidViewIdException(viewId);
            }
            if (viewId != null) {
                return this.checkResourceExists(context, viewId) ? viewId : null;
            }
        }
        return viewId;
    }

    @Override
    public String calculateActionURL(FacesContext context, String viewId) {
        if (viewId == null || !viewId.startsWith("/")) {
            throw new IllegalArgumentException("ViewId must start with a '/': " + viewId);
        }
        FacesServletMapping mapping = this.getFacesServletMapping(context);
        ExternalContext externalContext = context.getExternalContext();
        String contextPath = externalContext.getRequestContextPath();
        StringBuilder builder = SharedStringBuilder.get(context, VIEW_HANDLER_SUPPORT_SB);
        builder.append(contextPath);
        if (mapping != null) {
            if (mapping.isExtensionMapping()) {
                String[] contextSuffixes = this._initialized ? this._contextSuffixes : this.getContextSuffix(context);
                boolean founded = false;
                String[] stringArray = contextSuffixes;
                int n = contextSuffixes.length;
                int n2 = 0;
                while (n2 < n) {
                    String contextSuffix = stringArray[n2];
                    if (viewId.endsWith(contextSuffix)) {
                        builder.append(viewId.substring(0, viewId.indexOf(contextSuffix)));
                        builder.append(mapping.getExtension());
                        founded = true;
                        break;
                    }
                    ++n2;
                }
                if (!founded) {
                    if (viewId.endsWith(mapping.getExtension())) {
                        builder.append(viewId);
                    } else if (viewId.lastIndexOf(".") != -1) {
                        builder.append(viewId.substring(0, viewId.lastIndexOf(".")));
                        builder.append(contextSuffixes[0]);
                    } else {
                        builder.append(viewId);
                        builder.append(contextSuffixes[0]);
                    }
                }
            } else {
                builder.append(mapping.getPrefix());
                builder.append(viewId);
            }
        } else {
            builder.append(viewId);
        }
        String calculatedActionURL = builder.toString();
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Calculated actionURL: '" + calculatedActionURL + "' for viewId: '" + viewId + "'");
        }
        return calculatedActionURL;
    }

    protected FacesServletMapping getFacesServletMapping(FacesContext context) {
        Map<Object, Object> attributes = context.getAttributes();
        FacesServletMapping mapping = (FacesServletMapping)attributes.get(CACHED_SERVLET_MAPPING);
        if (mapping == null) {
            ExternalContext externalContext = context.getExternalContext();
            mapping = DefaultViewHandlerSupport.calculateFacesServletMapping(externalContext.getRequestServletPath(), externalContext.getRequestPathInfo());
            attributes.put(CACHED_SERVLET_MAPPING, mapping);
        }
        return mapping;
    }

    protected static FacesServletMapping calculateFacesServletMapping(String servletPath, String pathInfo) {
        if (pathInfo != null) {
            return FacesServletMapping.createPrefixMapping(servletPath);
        }
        int slashPos = servletPath.lastIndexOf(47);
        int extensionPos = servletPath.lastIndexOf(46);
        if (extensionPos > -1 && extensionPos > slashPos) {
            String extension = servletPath.substring(extensionPos);
            return FacesServletMapping.createExtensionMapping(extension);
        }
        return FacesServletMapping.createPrefixMapping(servletPath);
    }

    protected String[] getContextSuffix(FacesContext context) {
        String defaultSuffix = context.getExternalContext().getInitParameter("javax.faces.DEFAULT_SUFFIX");
        if (defaultSuffix == null) {
            defaultSuffix = ".xhtml .view.xml .jsp";
        }
        return StringUtils.splitShortString(defaultSuffix, ' ');
    }

    protected String getFaceletsContextSuffix(FacesContext context) {
        String defaultSuffix = context.getExternalContext().getInitParameter("javax.faces.FACELETS_SUFFIX");
        if (defaultSuffix == null) {
            defaultSuffix = ".xhtml";
        }
        return defaultSuffix;
    }

    protected String[] getFaceletsViewMappings(FacesContext context) {
        String faceletsViewMappings = context.getExternalContext().getInitParameter("javax.faces.FACELETS_VIEW_MAPPINGS");
        if (faceletsViewMappings == null) {
            faceletsViewMappings = context.getExternalContext().getInitParameter("facelets.VIEW_MAPPINGS");
        }
        return faceletsViewMappings == null ? null : StringUtils.splitShortString(faceletsViewMappings, ';');
    }

    protected String handlePrefixMapping(String viewId, String prefix) {
        prefix = "".equals(prefix) ? "//" : String.valueOf(prefix) + '/';
        String uri = viewId;
        while (uri.startsWith(prefix) || uri.startsWith("//")) {
            uri = uri.startsWith(prefix) ? uri.substring(prefix.length() - 1) : uri.substring(1);
        }
        return uri;
    }

    protected String handleSuffixMapping(FacesContext context, String requestViewId) {
        String faceletsDefaultSuffix;
        String[] faceletsViewMappings = this._initialized ? this._faceletsViewMappings : this.getFaceletsViewMappings(context);
        String[] jspDefaultSuffixes = this._initialized ? this._contextSuffixes : this.getContextSuffix(context);
        int slashPos = requestViewId.lastIndexOf(47);
        int extensionPos = requestViewId.lastIndexOf(46);
        StringBuilder builder = SharedStringBuilder.get(context, VIEW_HANDLER_SUPPORT_SB);
        String[] stringArray = jspDefaultSuffixes;
        int n = jspDefaultSuffixes.length;
        int n2 = 0;
        while (n2 < n) {
            String defaultSuffix = stringArray[n2];
            builder.setLength(0);
            builder.append(requestViewId);
            if (extensionPos > -1 && extensionPos > slashPos) {
                builder.replace(extensionPos, requestViewId.length(), defaultSuffix);
            } else {
                builder.append(defaultSuffix);
            }
            String candidateViewId = builder.toString();
            if (faceletsViewMappings != null && faceletsViewMappings.length > 0) {
                String[] stringArray2 = faceletsViewMappings;
                int n3 = faceletsViewMappings.length;
                int n4 = 0;
                while (n4 < n3) {
                    String mapping = stringArray2[n4];
                    if (!mapping.startsWith("/")) {
                        if (mapping.equals(candidateViewId)) {
                            return candidateViewId;
                        }
                        if (mapping.startsWith(".")) {
                            builder.setLength(0);
                            builder.append(candidateViewId);
                            builder.replace(candidateViewId.lastIndexOf(46), candidateViewId.length(), mapping);
                            String tempViewId = builder.toString();
                            if (this.checkResourceExists(context, tempViewId)) {
                                return tempViewId;
                            }
                        }
                    }
                    ++n4;
                }
            }
            if (this.checkResourceExists(context, candidateViewId)) {
                return candidateViewId;
            }
            ++n2;
        }
        String string = faceletsDefaultSuffix = this._initialized ? this._faceletsContextSufix : this.getFaceletsContextSuffix(context);
        if (faceletsDefaultSuffix != null) {
            String[] stringArray3 = jspDefaultSuffixes;
            int n5 = jspDefaultSuffixes.length;
            n = 0;
            while (n < n5) {
                String defaultSuffix = stringArray3[n];
                if (faceletsDefaultSuffix.equals(defaultSuffix)) {
                    faceletsDefaultSuffix = null;
                    break;
                }
                ++n;
            }
        }
        if (faceletsDefaultSuffix != null) {
            builder.setLength(0);
            builder.append(requestViewId);
            if (extensionPos > -1 && extensionPos > slashPos) {
                builder.replace(extensionPos, requestViewId.length(), faceletsDefaultSuffix);
            } else {
                builder.append(faceletsDefaultSuffix);
            }
            String candidateViewId = builder.toString();
            if (this.checkResourceExists(context, candidateViewId)) {
                return candidateViewId;
            }
        }
        if (this.checkResourceExists(context, requestViewId)) {
            return requestViewId;
        }
        return null;
    }

    protected boolean checkResourceExists(FacesContext context, String viewId) {
        block8: {
            block7: {
                try {
                    if (this.isCheckedViewIdCachingEnabled(context)) {
                        Boolean resourceExists = this.getCheckedViewIDMap(context).get(viewId);
                        if (resourceExists == null) {
                            ViewDeclarationLanguage vdl = context.getApplication().getViewHandler().getViewDeclarationLanguage(context, viewId);
                            resourceExists = vdl != null ? Boolean.valueOf(vdl.viewExists(context, viewId)) : Boolean.valueOf(context.getExternalContext().getResource(viewId) != null);
                            this.getCheckedViewIDMap(context).put(viewId, resourceExists);
                        }
                        return resourceExists;
                    }
                    ViewDeclarationLanguage vdl = context.getApplication().getViewHandler().getViewDeclarationLanguage(context, viewId);
                    if (vdl == null) break block7;
                    if (vdl.viewExists(context, viewId)) {
                        return true;
                    }
                    break block8;
                }
                catch (MalformedURLException malformedURLException) {}
            }
            if (context.getExternalContext().getResource(viewId) != null) {
                return true;
            }
        }
        return false;
    }

    private ConcurrentLRUCache<String, Boolean> getCheckedViewIDMap(FacesContext context) {
        if (this._checkedViewIdMap == null) {
            int maxSize = this.getViewIDCacheMaxSize(context);
            this._checkedViewIdMap = new ConcurrentLRUCache((maxSize * 4 + 3) / 3, maxSize);
        }
        return this._checkedViewIdMap;
    }

    private boolean isCheckedViewIdCachingEnabled(FacesContext context) {
        if (this._checkedViewIdCacheEnabled == null) {
            this._checkedViewIdCacheEnabled = context.isProjectStage(ProjectStage.Development) ? Boolean.FALSE : Boolean.valueOf(WebConfigParamUtils.getBooleanInitParameter(context.getExternalContext(), CHECKED_VIEWID_CACHE_ENABLED_ATTRIBUTE, true));
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "MyFaces ViewID Caching Enabled=" + this._checkedViewIdCacheEnabled);
            }
        }
        return this._checkedViewIdCacheEnabled;
    }

    private int getViewIDCacheMaxSize(FacesContext context) {
        ExternalContext externalContext = context.getExternalContext();
        return WebConfigParamUtils.getIntegerInitParameter(externalContext, CHECKED_VIEWID_CACHE_SIZE_ATTRIBUTE, 500);
    }
}

