/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.el.unified.resolver;

import java.beans.FeatureDescriptor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.ELResolver;
import javax.el.PropertyNotFoundException;
import javax.el.PropertyNotWritableException;
import javax.faces.FacesException;
import javax.faces.application.ProjectStage;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import org.apache.myfaces.config.RuntimeConfig;
import org.apache.myfaces.config.element.ManagedBean;

public class ManagedBeanResolver
extends ELResolver {
    private static final Logger log = Logger.getLogger(ManagedBeanResolver.class.getName());
    private static final String BEANS_UNDER_CONSTRUCTION = "org.apache.myfaces.el.unified.resolver.managedbean.beansUnderConstruction";
    private static final String CUSTOM_SCOPE_CYCLIC_REFERENCE_DETECTION = "org.apache.myfaces.el.unified.resolver.managedbean.customScopeCyclicReferenceDetection";
    protected static final Map<String, Scope> STANDARD_SCOPES = new HashMap<String, Scope>(16);
    protected final Map<String, Scope> _scopes = new HashMap<String, Scope>(16);
    private RuntimeConfig runtimeConfig;

    static {
        STANDARD_SCOPES.put("request", new Scope(){

            @Override
            public void put(FacesContext facesContext, ExternalContext extContext, String name, Object obj) {
                extContext.getRequestMap().put(name, obj);
            }
        });
        STANDARD_SCOPES.put("session", new Scope(){

            @Override
            public void put(FacesContext facesContext, ExternalContext extContext, String name, Object obj) {
                extContext.getSessionMap().put(name, obj);
            }
        });
        STANDARD_SCOPES.put("application", new Scope(){

            @Override
            public void put(FacesContext facesContext, ExternalContext extContext, String name, Object obj) {
                extContext.getApplicationMap().put(name, obj);
            }
        });
        STANDARD_SCOPES.put("none", new Scope(){

            @Override
            public void put(FacesContext facesContext, ExternalContext extContext, String name, Object obj) {
            }
        });
        STANDARD_SCOPES.put("view", new Scope(){

            @Override
            public void put(FacesContext facesContext, ExternalContext extContext, String name, Object obj) {
                facesContext.getViewRoot().getViewMap().put(name, obj);
            }
        });
    }

    public ManagedBeanResolver() {
        this._scopes.putAll(STANDARD_SCOPES);
    }

    public void setValue(ELContext context, Object base, Object property, Object value) throws NullPointerException, PropertyNotFoundException, PropertyNotWritableException, ELException {
        if (base == null && property == null) {
            throw new PropertyNotFoundException();
        }
    }

    public boolean isReadOnly(ELContext context, Object base, Object property) throws NullPointerException, PropertyNotFoundException, ELException {
        if (base == null && property == null) {
            throw new PropertyNotFoundException();
        }
        return false;
    }

    public Object getValue(ELContext context, Object base, Object property) throws NullPointerException, PropertyNotFoundException, ELException {
        Map<String, Object> viewMap;
        if (base != null) {
            return null;
        }
        if (property == null) {
            throw new PropertyNotFoundException();
        }
        FacesContext facesContext = ManagedBeanResolver.facesContext(context);
        if (facesContext == null) {
            return null;
        }
        ExternalContext extContext = facesContext.getExternalContext();
        if (extContext == null) {
            return null;
        }
        if (extContext.getRequestMap().containsKey(property)) {
            return null;
        }
        UIViewRoot root = facesContext.getViewRoot();
        if (root != null && (viewMap = root.getViewMap(false)) != null && viewMap.containsKey(property)) {
            return null;
        }
        if (extContext.getSessionMap().containsKey(property)) {
            return null;
        }
        if (extContext.getApplicationMap().containsKey(property)) {
            return null;
        }
        if (!(property instanceof String)) {
            return null;
        }
        String strProperty = (String)property;
        ManagedBean managedBean = this.runtimeConfig(context).getManagedBean(strProperty);
        Object beanInstance = null;
        if (managedBean != null) {
            context.setPropertyResolved(true);
            if (managedBean.isManagedBeanScopeValueExpression()) {
                boolean checkCyclicReferences = !facesContext.isProjectStage(ProjectStage.Production);
                List<String> cyclicReferences = null;
                if (checkCyclicReferences) {
                    Map<String, Object> requestMap = facesContext.getExternalContext().getRequestMap();
                    String managedBeanName = managedBean.getManagedBeanName();
                    cyclicReferences = (List)requestMap.get(CUSTOM_SCOPE_CYCLIC_REFERENCE_DETECTION);
                    if (cyclicReferences == null) {
                        cyclicReferences = new ArrayList<String>();
                        requestMap.put(CUSTOM_SCOPE_CYCLIC_REFERENCE_DETECTION, cyclicReferences);
                    } else if (cyclicReferences.contains(managedBeanName)) {
                        throw new ELException("Detected cyclic reference to managedBean " + managedBeanName);
                    }
                    cyclicReferences.add(managedBeanName);
                }
                try {
                    Object customScope = managedBean.getManagedBeanScopeValueExpression(facesContext).getValue(facesContext.getELContext());
                    if (customScope instanceof Map) {
                        beanInstance = ((Map)customScope).get(managedBean.getManagedBeanName());
                    } else {
                        if (customScope != null) {
                            throw new FacesException("The expression '" + managedBean.getManagedBeanScope() + "' does not evaluate to java.util.Map. It evaluates to '" + customScope + "' of type " + customScope.getClass().getName());
                        }
                        log.warning("Custom scope '" + managedBean.getManagedBeanScope() + "' evaluated to null. Unable to determine if managed bean '" + managedBean.getManagedBeanName() + "' exists.");
                    }
                }
                finally {
                    if (checkCyclicReferences) {
                        cyclicReferences.remove(managedBean.getManagedBeanName());
                    }
                }
            }
            if (beanInstance == null) {
                beanInstance = this.createManagedBean(managedBean, facesContext);
            }
        }
        return beanInstance;
    }

    private Object createManagedBean(ManagedBean managedBean, FacesContext facesContext) throws ELException {
        ExternalContext extContext = facesContext.getExternalContext();
        Map<Object, Object> facesContextMap = facesContext.getAttributes();
        String managedBeanName = managedBean.getManagedBeanName();
        ArrayList<String> beansUnderConstruction = (ArrayList<String>)facesContextMap.get(BEANS_UNDER_CONSTRUCTION);
        if (beansUnderConstruction == null) {
            beansUnderConstruction = new ArrayList<String>();
            facesContextMap.put(BEANS_UNDER_CONSTRUCTION, beansUnderConstruction);
        } else if (beansUnderConstruction.contains(managedBeanName)) {
            throw new ELException("Detected cyclic reference to managedBean " + managedBeanName);
        }
        beansUnderConstruction.add(managedBeanName);
        Object obj = null;
        this.putInScope(managedBean, facesContext, extContext, obj);
        return obj;
    }

    private void putInScope(ManagedBean managedBean, FacesContext facesContext, ExternalContext extContext, Object obj) {
        String managedBeanName = managedBean.getManagedBeanName();
        if (obj == null) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("Variable '" + managedBeanName + "' could not be resolved.");
            }
        } else {
            String scopeKey = managedBean.getManagedBeanScope();
            Scope scope = this._scopes.get(scopeKey);
            if (scope != null) {
                scope.put(facesContext, extContext, managedBeanName, obj);
            } else if (managedBean.isManagedBeanScopeValueExpression()) {
                Object customScope = managedBean.getManagedBeanScopeValueExpression(facesContext).getValue(facesContext.getELContext());
                if (customScope instanceof Map) {
                    ((Map)customScope).put(managedBeanName, obj);
                } else {
                    if (customScope != null) {
                        throw new FacesException("The expression '" + scopeKey + "' does not evaluate to " + "java.util.Map. It evaluates to '" + customScope + "' of type " + customScope.getClass().getName());
                    }
                    log.warning("Custom scope '" + scopeKey + "' evaluated to null. " + "Cannot store managed bean '" + managedBeanName + "' in custom scope.");
                }
            } else {
                log.severe("Managed bean '" + managedBeanName + "' has illegal scope: " + scopeKey);
            }
        }
    }

    private static FacesContext facesContext(ELContext context) {
        return (FacesContext)context.getContext(FacesContext.class);
    }

    public Class<?> getType(ELContext context, Object base, Object property) throws NullPointerException, PropertyNotFoundException, ELException {
        if (base == null && property == null) {
            throw new PropertyNotFoundException();
        }
        return null;
    }

    public Iterator<FeatureDescriptor> getFeatureDescriptors(ELContext context, Object base) {
        if (base != null) {
            return null;
        }
        ArrayList<FeatureDescriptor> descriptors = new ArrayList<FeatureDescriptor>();
        Map<String, ManagedBean> managedBeans = this.runtimeConfig(context).getManagedBeans();
        for (Map.Entry<String, ManagedBean> managedBean : managedBeans.entrySet()) {
            descriptors.add(ManagedBeanResolver.makeDescriptor(managedBean.getKey(), managedBean.getValue()));
        }
        return descriptors.iterator();
    }

    private static FeatureDescriptor makeDescriptor(String beanName, ManagedBean managedBean) {
        FeatureDescriptor fd = new FeatureDescriptor();
        fd.setValue("resolvableAtDesignTime", Boolean.TRUE);
        fd.setValue("type", managedBean.getManagedBeanClass());
        fd.setName(beanName);
        fd.setDisplayName(beanName);
        fd.setShortDescription(managedBean.getDescription());
        fd.setExpert(false);
        fd.setHidden(false);
        fd.setPreferred(true);
        return fd;
    }

    protected RuntimeConfig runtimeConfig(ELContext context) {
        FacesContext facesContext = ManagedBeanResolver.facesContext(context);
        if (this.runtimeConfig == null) {
            this.runtimeConfig = RuntimeConfig.getCurrentInstance(facesContext.getExternalContext());
        }
        return this.runtimeConfig;
    }

    public Class<?> getCommonPropertyType(ELContext context, Object base) {
        if (base == null) {
            return Object.class;
        }
        return null;
    }

    static interface Scope {
        public void put(FacesContext var1, ExternalContext var2, String var3, Object var4);
    }
}

