/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.config;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.faces.context.ExternalContext;
import org.apache.myfaces.config.RuntimeConfig;
import org.apache.myfaces.config.element.ManagedBean;
import org.apache.myfaces.config.element.NavigationCase;
import org.apache.myfaces.config.element.NavigationRule;
import org.apache.myfaces.shared.util.ClassUtils;

public class FacesConfigValidator {
    public static final String VALIDATE_CONTEXT_PARAM = "org.apache.myfaces.VALIDATE";

    private FacesConfigValidator() {
    }

    public static List<String> validate(ExternalContext ctx) {
        RuntimeConfig runtimeConfig = RuntimeConfig.getCurrentInstance(ctx);
        Map<String, ManagedBean> managedBeansMap = runtimeConfig.getManagedBeans();
        Collection<ManagedBean> managedBeans = null;
        if (managedBeansMap != null) {
            managedBeans = managedBeansMap.values();
        }
        Collection<NavigationRule> navRules = runtimeConfig.getNavigationRules();
        return FacesConfigValidator.validate(managedBeans, navRules, ctx);
    }

    public static List<String> validate(Collection<? extends ManagedBean> managedBeans, Collection<? extends NavigationRule> navRules, ExternalContext ctx) {
        ArrayList<String> list = new ArrayList<String>();
        if (managedBeans != null) {
            FacesConfigValidator.validateManagedBeans(managedBeans, list);
        }
        if (navRules != null) {
            FacesConfigValidator.validateNavRules(navRules, list, ctx);
        }
        return list;
    }

    private static void validateNavRules(Collection<? extends NavigationRule> navRules, List<String> list, ExternalContext ctx) {
        for (NavigationRule navigationRule : navRules) {
            FacesConfigValidator.validateNavRule(navigationRule, list, ctx);
        }
    }

    private static void validateNavRule(NavigationRule navRule, List<String> list, ExternalContext ctx) {
        String fromId = navRule.getFromViewId();
        try {
            URL filePath = ctx.getResource(fromId);
            if (fromId != null && !"*".equals(fromId) && filePath == null) {
                list.add("File for navigation 'from id' does not exist " + filePath);
            }
        }
        catch (MalformedURLException malformedURLException) {
            list.add("File for navigation 'from id' does not exist " + fromId);
        }
        for (NavigationCase navigationCase : navRule.getNavigationCases()) {
            try {
                URL toViewPath = ctx.getResource(navigationCase.getToViewId());
                if (toViewPath != null) continue;
                list.add("File for navigation 'to id' does not exist " + toViewPath);
            }
            catch (MalformedURLException malformedURLException) {
                list.add("File for navigation 'from id' does not exist " + navigationCase.getToViewId());
            }
        }
    }

    private static void validateManagedBeans(Collection<? extends ManagedBean> managedBeans, List<String> list) {
        for (ManagedBean managedBean : managedBeans) {
            FacesConfigValidator.validateManagedBean(managedBean, list);
        }
    }

    private static void validateManagedBean(ManagedBean managedBean, List<String> list) {
        String className = managedBean.getManagedBeanClassName();
        try {
            ClassUtils.classForName(className);
        }
        catch (ClassNotFoundException classNotFoundException) {
            String msg = "Could not locate class " + className + " for managed bean '" + managedBean.getManagedBeanName() + "'";
            list.add(msg);
        }
    }
}

