/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.config;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.FacesException;
import javax.faces.context.ExternalContext;
import org.apache.myfaces.config.FacesConfigDispenser;
import org.apache.myfaces.config.LogMetaInfUtils;
import org.apache.myfaces.config.element.ConfigOthersSlot;
import org.apache.myfaces.config.element.FacesConfig;
import org.apache.myfaces.config.element.FacesConfigData;
import org.apache.myfaces.config.element.FacesConfigNameSlot;
import org.apache.myfaces.config.element.OrderSlot;
import org.apache.myfaces.config.element.Ordering;
import org.apache.myfaces.config.impl.digester.DigesterFacesConfigDispenserImpl;
import org.apache.myfaces.config.util.CyclicDependencyException;
import org.apache.myfaces.config.util.DirectedAcyclicGraphVerifier;
import org.apache.myfaces.config.util.Vertex;
import org.apache.myfaces.spi.FacesConfigurationMerger;
import org.apache.myfaces.spi.FacesConfigurationProvider;
import org.apache.myfaces.spi.FacesConfigurationProviderFactory;

public class DefaultFacesConfigurationMerger
extends FacesConfigurationMerger {
    private static final Logger log = Logger.getLogger(DefaultFacesConfigurationMerger.class.getName());

    @Override
    public FacesConfigData getFacesConfigData(ExternalContext externalContext) {
        FacesConfigurationProvider facesConfigProvider = FacesConfigurationProviderFactory.getFacesConfigurationProviderFactory(externalContext).getFacesConfigurationProvider(externalContext);
        DigesterFacesConfigDispenserImpl dispenser = new DigesterFacesConfigDispenserImpl();
        ((FacesConfigDispenser)dispenser).feed(facesConfigProvider.getStandardFacesConfig(externalContext));
        ((FacesConfigDispenser)dispenser).feed(facesConfigProvider.getMetaInfServicesFacesConfig(externalContext));
        FacesConfig webAppFacesConfig = facesConfigProvider.getWebAppFacesConfig(externalContext);
        boolean metadataComplete = false;
        metadataComplete = webAppFacesConfig != null ? Boolean.valueOf(webAppFacesConfig.getMetadataComplete()) : false;
        FacesConfig annotationFacesConfig = facesConfigProvider.getAnnotationsFacesConfig(externalContext, metadataComplete);
        if (annotationFacesConfig != null) {
            ((FacesConfigDispenser)dispenser).feed(annotationFacesConfig);
        }
        ArrayList<FacesConfig> appConfigResources = new ArrayList<FacesConfig>();
        appConfigResources.addAll(facesConfigProvider.getClassloaderFacesConfig(externalContext));
        appConfigResources.addAll(facesConfigProvider.getContextSpecifiedFacesConfig(externalContext));
        this.orderAndFeedArtifacts(dispenser, appConfigResources, webAppFacesConfig);
        LogMetaInfUtils.logMetaInf();
        return dispenser;
    }

    protected void orderAndFeedArtifacts(FacesConfigDispenser dispenser, List<FacesConfig> appConfigResources, FacesConfig webAppConfig) throws FacesException {
        if (webAppConfig != null && webAppConfig.getAbsoluteOrdering() != null) {
            if (webAppConfig.getOrdering() != null && log.isLoggable(Level.WARNING)) {
                log.warning("<ordering> element found in application faces config. This description will be ignored and the actions described in <absolute-ordering> element will be taken into account instead.");
            }
            ArrayList<FacesConfig> othersResources = new ArrayList<FacesConfig>();
            List<OrderSlot> slots = webAppConfig.getAbsoluteOrdering().getOrderList();
            for (FacesConfig resource : appConfigResources) {
                if (resource.getName() != null && (resource.getName() == null || this.containsResourceInSlot(slots, resource.getName()))) continue;
                othersResources.add(resource);
            }
            for (OrderSlot slot : webAppConfig.getAbsoluteOrdering().getOrderList()) {
                if (slot instanceof ConfigOthersSlot) {
                    for (FacesConfig resource : othersResources) {
                        dispenser.feed(resource);
                    }
                    continue;
                }
                FacesConfigNameSlot nameSlot = (FacesConfigNameSlot)slot;
                FacesConfig targetFacesConfig = this.getFacesConfig(appConfigResources, nameSlot.getName());
                if (targetFacesConfig == null) continue;
                dispenser.feed(targetFacesConfig);
            }
        } else if (!appConfigResources.isEmpty()) {
            for (FacesConfig resource : appConfigResources) {
                if (resource.getAbsoluteOrdering() == null || !log.isLoggable(Level.WARNING)) continue;
                log.warning("<absolute-ordering> element found in application configuration resource " + resource.getName() + ". " + "This description will be ignored and the actions described " + "in <ordering> elements will be taken into account instead.");
            }
            List<FacesConfig> postOrderedList = this.getPostOrderedList(appConfigResources);
            List<FacesConfig> sortedList = this.sortRelativeOrderingList(postOrderedList);
            if (sortedList == null) {
                sortedList = this.applySortingAlgorithm(appConfigResources);
            }
            for (FacesConfig resource : sortedList) {
                dispenser.feed(resource);
            }
        }
        if (webAppConfig != null) {
            dispenser.feed(webAppConfig);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected List<FacesConfig> applySortingAlgorithm(List<FacesConfig> appConfigResources) throws FacesException {
        void var8_25;
        Vertex<FacesConfig> v;
        ArrayList vertexList = new ArrayList();
        for (FacesConfig config : appConfigResources) {
            v = null;
            v = config.getName() != null ? new Vertex<FacesConfig>(config.getName(), config) : new Vertex<FacesConfig>(config);
            vertexList.add(v);
        }
        boolean[] referencedVertex = new boolean[vertexList.size()];
        int i = 0;
        while (i < vertexList.size()) {
            v = (Vertex<FacesConfig>)vertexList.get(i);
            FacesConfig f = v.getNode();
            if (f.getOrdering() != null) {
                String name;
                int j;
                Vertex v1;
                for (OrderSlot slot : f.getOrdering().getBeforeList()) {
                    if (!(slot instanceof FacesConfigNameSlot) || (v1 = (Vertex)vertexList.get(j = DirectedAcyclicGraphVerifier.findVertex(vertexList, name = ((FacesConfigNameSlot)slot).getName()))) == null) continue;
                    referencedVertex[i] = true;
                    referencedVertex[j] = true;
                    v1.addDependency(v);
                }
                for (OrderSlot slot : f.getOrdering().getAfterList()) {
                    if (!(slot instanceof FacesConfigNameSlot) || (v1 = (Vertex)vertexList.get(j = DirectedAcyclicGraphVerifier.findVertex(vertexList, name = ((FacesConfigNameSlot)slot).getName()))) == null) continue;
                    referencedVertex[i] = true;
                    referencedVertex[j] = true;
                    v.addDependency(v1);
                }
            }
            ++i;
        }
        ArrayList<Vertex> beforeAfterOthersList = new ArrayList<Vertex>();
        ArrayList<Vertex> othersList = new ArrayList<Vertex>();
        ArrayList referencedList = new ArrayList();
        int i2 = 0;
        while (i2 < vertexList.size()) {
            if (!referencedVertex[i2]) {
                Vertex vertex = (Vertex)vertexList.get(i2);
                Iterator f = (FacesConfig)vertex.getNode();
                boolean added = false;
                if (((FacesConfig)((Object)f)).getOrdering() != null) {
                    if (!((FacesConfig)((Object)f)).getOrdering().getBeforeList().isEmpty()) {
                        added = true;
                        beforeAfterOthersList.add(vertex);
                    } else if (!((FacesConfig)((Object)f)).getOrdering().getAfterList().isEmpty()) {
                        added = true;
                        beforeAfterOthersList.add(vertex);
                    }
                }
                if (!added) {
                    othersList.add(vertex);
                }
            } else {
                referencedList.add((Vertex)vertexList.get(i2));
            }
            ++i2;
        }
        try {
            DirectedAcyclicGraphVerifier.topologicalSort(referencedList);
        }
        catch (CyclicDependencyException e) {
            e.printStackTrace();
        }
        ArrayList<FacesConfig> sortedList = new ArrayList<FacesConfig>();
        for (Vertex vertex : referencedList) {
            sortedList.add((FacesConfig)vertex.getNode());
        }
        for (Vertex vertex : othersList) {
            sortedList.add((FacesConfig)vertex.getNode());
        }
        for (Vertex vertex : beforeAfterOthersList) {
            FacesConfig f = (FacesConfig)vertex.getNode();
            boolean added = false;
            if (f.getOrdering() != null && !f.getOrdering().getBeforeList().isEmpty()) {
                added = true;
                sortedList.add(0, f);
            }
            if (added) continue;
            sortedList.add(f);
        }
        boolean bl = false;
        while (var8_25 < sortedList.size()) {
            FacesConfig resource = (FacesConfig)sortedList.get((int)var8_25);
            if (resource.getOrdering() != null) {
                void j;
                boolean founded;
                String name;
                for (OrderSlot slot : resource.getOrdering().getBeforeList()) {
                    if (!(slot instanceof FacesConfigNameSlot) || (name = ((FacesConfigNameSlot)slot).getName()) == null || "".equals(name)) continue;
                    founded = false;
                    j = var8_25 - true;
                    while (j >= 0) {
                        if (name.equals(((FacesConfig)sortedList.get((int)j)).getName())) {
                            founded = true;
                            break;
                        }
                        --j;
                    }
                    if (!founded) continue;
                    log.severe("Circular references detected when sorting application config resources. Use absolute ordering instead.");
                    throw new FacesException("Circular references detected when sorting application config resources. Use absolute ordering instead.");
                }
                for (OrderSlot slot : resource.getOrdering().getAfterList()) {
                    if (!(slot instanceof FacesConfigNameSlot) || (name = ((FacesConfigNameSlot)slot).getName()) == null || "".equals(name)) continue;
                    founded = false;
                    j = var8_25 + true;
                    while (j < sortedList.size()) {
                        if (name.equals(((FacesConfig)sortedList.get((int)j)).getName())) {
                            founded = true;
                            break;
                        }
                        ++j;
                    }
                    if (!founded) continue;
                    log.severe("Circular references detected when sorting application config resources. Use absolute ordering instead.");
                    throw new FacesException("Circular references detected when sorting application config resources. Use absolute ordering instead.");
                }
            }
            ++var8_25;
        }
        return sortedList;
    }

    protected List<FacesConfig> sortRelativeOrderingList(List<FacesConfig> preOrderedList) {
        FacesConfig resource;
        ArrayList<FacesConfig> sortedList = new ArrayList<FacesConfig>();
        int i = 0;
        while (i < preOrderedList.size()) {
            resource = preOrderedList.get(i);
            if (resource.getOrdering() != null) {
                if (resource.getOrdering().getBeforeList().isEmpty() && resource.getOrdering().getAfterList().isEmpty()) {
                    sortedList.add(resource);
                } else if (resource.getOrdering().getBeforeList().isEmpty()) {
                    this.applyAfterRule(sortedList, resource);
                } else if (resource.getOrdering().getAfterList().isEmpty()) {
                    boolean referenceNode = false;
                    int j = i + 1;
                    while (j < preOrderedList.size()) {
                        FacesConfig pointingResource = preOrderedList.get(j);
                        for (OrderSlot orderSlot : pointingResource.getOrdering().getBeforeList()) {
                            if (orderSlot instanceof FacesConfigNameSlot && resource.getName().equals(((FacesConfigNameSlot)orderSlot).getName())) {
                                referenceNode = true;
                            }
                            if (!(orderSlot instanceof ConfigOthersSlot)) continue;
                            referenceNode = false;
                            break;
                        }
                        if (referenceNode) break;
                        for (OrderSlot orderSlot : pointingResource.getOrdering().getAfterList()) {
                            if (!(orderSlot instanceof FacesConfigNameSlot) || !resource.getName().equals(((FacesConfigNameSlot)orderSlot).getName())) continue;
                            referenceNode = true;
                            break;
                        }
                        ++j;
                    }
                    this.applyBeforeRule(sortedList, resource, referenceNode);
                } else {
                    int beforeWeight = 0;
                    int afterWeight = 0;
                    for (OrderSlot slot2 : resource.getOrdering().getBeforeList()) {
                        if (!(slot2 instanceof FacesConfigNameSlot)) continue;
                        ++beforeWeight;
                    }
                    for (OrderSlot slot : resource.getOrdering().getAfterList()) {
                        if (!(slot instanceof FacesConfigNameSlot)) continue;
                        ++afterWeight;
                    }
                    if (beforeWeight >= afterWeight) {
                        this.applyBeforeRule(sortedList, resource, false);
                    } else {
                        this.applyAfterRule(sortedList, resource);
                    }
                }
            } else {
                sortedList.add(resource);
            }
            ++i;
        }
        i = 0;
        while (i < sortedList.size()) {
            resource = (FacesConfig)sortedList.get(i);
            if (resource.getOrdering() != null) {
                String name;
                for (OrderSlot slot : resource.getOrdering().getBeforeList()) {
                    if (!(slot instanceof FacesConfigNameSlot) || (name = ((FacesConfigNameSlot)slot).getName()) == null || "".equals(name)) continue;
                    boolean bl = false;
                    int j = i - 1;
                    while (j >= 0) {
                        if (name.equals(((FacesConfig)sortedList.get(j)).getName())) {
                            bl = true;
                            break;
                        }
                        --j;
                    }
                    if (!bl) continue;
                    return null;
                }
                for (OrderSlot slot : resource.getOrdering().getAfterList()) {
                    if (!(slot instanceof FacesConfigNameSlot) || (name = ((FacesConfigNameSlot)slot).getName()) == null || "".equals(name)) continue;
                    boolean bl = false;
                    int j = i + 1;
                    while (j < sortedList.size()) {
                        if (name.equals(((FacesConfig)sortedList.get(j)).getName())) {
                            bl = true;
                            break;
                        }
                        ++j;
                    }
                    if (!bl) continue;
                    return null;
                }
            }
            ++i;
        }
        return sortedList;
    }

    private void applyBeforeRule(List<FacesConfig> sortedList, FacesConfig resource, boolean referenced) throws FacesException {
        boolean configOthers = false;
        ArrayList<String> names = new ArrayList<String>();
        for (OrderSlot slot : resource.getOrdering().getBeforeList()) {
            if (slot instanceof ConfigOthersSlot) {
                configOthers = true;
                break;
            }
            FacesConfigNameSlot nameSlot = (FacesConfigNameSlot)slot;
            names.add(nameSlot.getName());
        }
        if (configOthers) {
            if (resource.getOrdering().getBeforeList().size() > 1) {
                sortedList.add(0, resource);
            } else if (!referenced) {
                sortedList.add(0, resource);
            } else {
                sortedList.add(resource);
            }
        } else {
            boolean founded = false;
            int i = 0;
            while (i < sortedList.size()) {
                if (names.contains(sortedList.get(i).getName())) {
                    sortedList.add(i, resource);
                    founded = true;
                    break;
                }
                ++i;
            }
            if (!founded) {
                sortedList.add(resource);
            }
        }
    }

    private void applyAfterRule(List<FacesConfig> sortedList, FacesConfig resource) throws FacesException {
        boolean configOthers = false;
        ArrayList<String> names = new ArrayList<String>();
        for (OrderSlot slot : resource.getOrdering().getAfterList()) {
            if (slot instanceof ConfigOthersSlot) {
                configOthers = true;
                break;
            }
            FacesConfigNameSlot nameSlot = (FacesConfigNameSlot)slot;
            names.add(nameSlot.getName());
        }
        if (configOthers) {
            sortedList.add(resource);
        } else {
            boolean founded = false;
            int i = sortedList.size() - 1;
            while (i >= 0) {
                if (names.contains(sortedList.get(i).getName())) {
                    if (i + 1 < sortedList.size()) {
                        sortedList.add(i + 1, resource);
                    } else {
                        sortedList.add(resource);
                    }
                    founded = true;
                    break;
                }
                --i;
            }
            if (!founded) {
                sortedList.add(resource);
            }
        }
    }

    protected List<FacesConfig> getPostOrderedList(List<FacesConfig> appConfigResources) throws FacesException {
        ArrayList<String> availableReferences = new ArrayList<String>();
        for (FacesConfig resource : appConfigResources) {
            String name = resource.getName();
            if (name == null || "".equals(name)) continue;
            availableReferences.add(name);
        }
        for (FacesConfig resource : appConfigResources) {
            String name;
            OrderSlot slot;
            Ordering ordering = resource.getOrdering();
            if (ordering == null) continue;
            Iterator<OrderSlot> it = resource.getOrdering().getBeforeList().iterator();
            while (it.hasNext()) {
                slot = it.next();
                if (!(slot instanceof FacesConfigNameSlot) || availableReferences.contains(name = ((FacesConfigNameSlot)slot).getName())) continue;
                it.remove();
            }
            it = resource.getOrdering().getAfterList().iterator();
            while (it.hasNext()) {
                slot = it.next();
                if (!(slot instanceof FacesConfigNameSlot) || availableReferences.contains(name = ((FacesConfigNameSlot)slot).getName())) continue;
                it.remove();
            }
        }
        List<FacesConfig> appFilteredConfigResources = null;
        if (appConfigResources instanceof ArrayList) {
            appFilteredConfigResources = (List)((ArrayList)appConfigResources).clone();
        } else {
            appFilteredConfigResources = new ArrayList();
            appFilteredConfigResources.addAll(appConfigResources);
        }
        Collections.sort(appFilteredConfigResources, new Comparator<FacesConfig>(){

            @Override
            public int compare(FacesConfig o1, FacesConfig o2) {
                int o1Weight = 0;
                int o2Weight = 0;
                if (o1.getOrdering() != null) {
                    for (OrderSlot slot : o1.getOrdering().getBeforeList()) {
                        if (!(slot instanceof FacesConfigNameSlot)) continue;
                        ++o1Weight;
                    }
                    for (OrderSlot slot : o1.getOrdering().getAfterList()) {
                        if (!(slot instanceof FacesConfigNameSlot)) continue;
                        ++o1Weight;
                    }
                }
                if (o2.getOrdering() != null) {
                    for (OrderSlot slot : o2.getOrdering().getBeforeList()) {
                        if (!(slot instanceof FacesConfigNameSlot)) continue;
                        ++o2Weight;
                    }
                    for (OrderSlot slot : o2.getOrdering().getAfterList()) {
                        if (!(slot instanceof FacesConfigNameSlot)) continue;
                        ++o2Weight;
                    }
                }
                return o2Weight - o1Weight;
            }
        });
        LinkedList<FacesConfig> postOrderedList = new LinkedList<FacesConfig>();
        ArrayList<FacesConfig> othersList = new ArrayList<FacesConfig>();
        ArrayList<String> nameBeforeStack = new ArrayList<String>();
        ArrayList<String> nameAfterStack = new ArrayList<String>();
        boolean[] visitedSlots = new boolean[appFilteredConfigResources.size()];
        int i = 0;
        while (i < appFilteredConfigResources.size()) {
            if (!visitedSlots[i]) {
                this.resolveConflicts(appFilteredConfigResources, i, visitedSlots, nameBeforeStack, nameAfterStack, postOrderedList, othersList, false);
            }
            ++i;
        }
        postOrderedList.addAll(othersList);
        return postOrderedList;
    }

    private void resolveConflicts(List<FacesConfig> appConfigResources, int index, boolean[] visitedSlots, List<String> nameBeforeStack, List<String> nameAfterStack, List<FacesConfig> postOrderedList, List<FacesConfig> othersList, boolean indexReferenced) throws FacesException {
        FacesConfig facesConfig = appConfigResources.get(index);
        if (nameBeforeStack.contains(facesConfig.getName())) {
            return;
        }
        if (nameAfterStack.contains(facesConfig.getName())) {
            return;
        }
        if (facesConfig.getOrdering() != null) {
            FacesConfig resource;
            boolean alreadyAdded;
            FacesConfigNameSlot nameSlot;
            boolean pointingResource = false;
            for (OrderSlot slot : facesConfig.getOrdering().getBeforeList()) {
                if (!(slot instanceof FacesConfigNameSlot)) continue;
                nameSlot = (FacesConfigNameSlot)slot;
                alreadyAdded = false;
                for (FacesConfig res : postOrderedList) {
                    if (!nameSlot.getName().equals(res.getName())) continue;
                    alreadyAdded = true;
                    break;
                }
                if (!alreadyAdded) {
                    int indexSlot = -1;
                    int i = 0;
                    while (i < appConfigResources.size()) {
                        resource = appConfigResources.get(i);
                        if (resource.getName() != null && nameSlot.getName().equals(resource.getName())) {
                            indexSlot = i;
                            break;
                        }
                        ++i;
                    }
                    if (indexSlot == -1) continue;
                    pointingResource = true;
                    nameBeforeStack.add(facesConfig.getName());
                    this.resolveConflicts(appConfigResources, indexSlot, visitedSlots, nameBeforeStack, nameAfterStack, postOrderedList, othersList, true);
                    nameBeforeStack.remove(facesConfig.getName());
                    continue;
                }
                pointingResource = true;
            }
            for (OrderSlot slot : facesConfig.getOrdering().getAfterList()) {
                if (!(slot instanceof FacesConfigNameSlot)) continue;
                nameSlot = (FacesConfigNameSlot)slot;
                alreadyAdded = false;
                for (FacesConfig res : postOrderedList) {
                    if (!nameSlot.getName().equals(res.getName())) continue;
                    alreadyAdded = true;
                    break;
                }
                if (!alreadyAdded) {
                    int indexSlot = -1;
                    int i = 0;
                    while (i < appConfigResources.size()) {
                        resource = appConfigResources.get(i);
                        if (resource.getName() != null && nameSlot.getName().equals(resource.getName())) {
                            indexSlot = i;
                            break;
                        }
                        ++i;
                    }
                    if (indexSlot == -1) continue;
                    pointingResource = true;
                    nameAfterStack.add(facesConfig.getName());
                    this.resolveConflicts(appConfigResources, indexSlot, visitedSlots, nameBeforeStack, nameAfterStack, postOrderedList, othersList, true);
                    nameAfterStack.remove(facesConfig.getName());
                    continue;
                }
                pointingResource = true;
            }
            if (facesConfig.getOrdering().getBeforeList().isEmpty() && facesConfig.getOrdering().getAfterList().isEmpty()) {
                postOrderedList.add(0, appConfigResources.get(index));
            } else if (pointingResource || indexReferenced) {
                postOrderedList.add(appConfigResources.get(index));
            } else {
                othersList.add(appConfigResources.get(index));
            }
        } else {
            postOrderedList.add(0, appConfigResources.get(index));
        }
        visitedSlots[index] = true;
    }

    private FacesConfig getFacesConfig(List<FacesConfig> appConfigResources, String name) {
        for (FacesConfig cfg : appConfigResources) {
            if (cfg.getName() == null || !name.equals(cfg.getName())) continue;
            return cfg;
        }
        return null;
    }

    private boolean containsResourceInSlot(List<OrderSlot> slots, String name) {
        for (OrderSlot slot : slots) {
            FacesConfigNameSlot nameSlot;
            if (!(slot instanceof FacesConfigNameSlot) || !name.equals((nameSlot = (FacesConfigNameSlot)slot).getName())) continue;
            return true;
        }
        return false;
    }
}

