/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.jsf.facelet.dtcompiler.handler;

import java.io.IOException;
import javax.el.ELException;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.view.facelets.FaceletContext;
import javax.faces.view.facelets.FaceletHandler;
import javax.faces.view.facelets.TagAttributeException;
import javax.faces.view.facelets.TagException;
import oracle.eclipse.tools.webtier.jsf.facelet.dtcontext.DesignTimeContext;
import oracle.eclipse.tools.webtier.jsf.facelet.dtcontext.TagError;
import oracle.eclipse.tools.webtier.jsf.facelet.dtcontext.XMLTextRange;

public class FaceletHandlerWrapper
implements FaceletHandler {
    private FaceletHandler wrapped;
    private XMLTextRange xmlTextRange;

    public FaceletHandlerWrapper(FaceletHandler wrapped, XMLTextRange xmlTextRange) {
        if (wrapped == null) {
            throw new IllegalArgumentException();
        }
        this.wrapped = wrapped;
        this.xmlTextRange = xmlTextRange;
    }

    @Override
    public void apply(FaceletContext ctx, UIComponent parent) throws IOException {
        try {
            this.wrapped.apply(ctx, parent);
        }
        catch (TagException e) {
            DesignTimeContext.getCurrentInstance().reportTagError(new TagError("", "", e.getLocalizedMessage(), this.xmlTextRange));
        }
        catch (TagAttributeException e) {
            DesignTimeContext.getCurrentInstance().reportTagError(new TagError("", "", e.getLocalizedMessage(), this.xmlTextRange));
        }
        catch (FacesException e) {
            Throwable cause = e.getCause();
            if (!(cause instanceof ELException)) {
                throw e;
            }
        }
        catch (ELException eLException) {
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public FaceletHandler getWrapped() {
        return this.wrapped;
    }
}

