/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.jsf.facelet.dtcompiler.handler;

import java.io.IOException;
import javax.el.ELException;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.component.UniqueIdVendor;
import javax.faces.view.facelets.FaceletContext;
import javax.faces.view.facelets.FaceletException;
import oracle.eclipse.tools.webtier.jsf.facelet.dtcompiler.handler.DTAbstractUIHandler;
import oracle.eclipse.tools.webtier.jsf.facelet.dtcompiler.uiinstructions.DTUIText;
import org.apache.myfaces.view.facelets.FaceletCompositionContext;
import org.apache.myfaces.view.facelets.el.ELText;
import org.apache.myfaces.view.facelets.tag.jsf.ComponentSupport;
import org.apache.myfaces.view.facelets.util.FastWriter;

public final class DTUITextHandler
extends DTAbstractUIHandler {
    private final ELText txt;
    private final String alias;
    private final int length;

    public DTUITextHandler(String alias, ELText txt) {
        this.alias = alias;
        this.txt = txt;
        this.length = txt.toString().length();
    }

    @Override
    public void apply(FaceletContext ctx, UIComponent parent) throws IOException, FacesException, FaceletException, ELException {
        if (parent != null) {
            try {
                ELText nt = this.txt.apply(ctx.getExpressionFactory(), ctx);
                DTUIText c = new DTUIText(this.alias, nt);
                UniqueIdVendor uniqueIdVendor = FaceletCompositionContext.getCurrentInstance(ctx).getUniqueIdVendorFromStack();
                if (uniqueIdVendor == null) {
                    uniqueIdVendor = ComponentSupport.getViewRoot(ctx, parent);
                }
                if (uniqueIdVendor != null) {
                    String uid = uniqueIdVendor.createUniqueId(ctx.getFacesContext(), null);
                    ((UIComponent)c).setId(uid);
                }
                this.addComponent(ctx, parent, c);
            }
            catch (Exception e) {
                throw new ELException(String.valueOf(this.alias) + ": " + e.getMessage(), e.getCause());
            }
        }
    }

    public String toString() {
        return this.txt.toString();
    }

    @Override
    public String getText() {
        return this.txt.toString();
    }

    @Override
    public String getText(FaceletContext ctx) {
        FastWriter writer = new FastWriter(this.length);
        try {
            this.txt.apply(ctx.getExpressionFactory(), ctx).write(writer, ctx);
        }
        catch (IOException e) {
            throw new ELException(String.valueOf(this.alias) + ": " + e.getMessage(), e.getCause());
        }
        return ((Object)writer).toString();
    }
}

