/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.jsf.facelet.dtcompiler.handler;

import java.io.IOException;
import javax.el.ELException;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.component.UniqueIdVendor;
import javax.faces.view.facelets.FaceletContext;
import javax.faces.view.facelets.FaceletException;
import oracle.eclipse.tools.webtier.jsf.facelet.dtcompiler.handler.DTAbstractUIHandler;
import oracle.eclipse.tools.webtier.jsf.facelet.dtcompiler.instruction.DTInstruction;
import oracle.eclipse.tools.webtier.jsf.facelet.dtcompiler.uiinstructions.DTUIInstructions;
import org.apache.myfaces.view.facelets.FaceletCompositionContext;
import org.apache.myfaces.view.facelets.el.ELText;
import org.apache.myfaces.view.facelets.tag.jsf.ComponentSupport;
import org.apache.myfaces.view.facelets.util.FastWriter;

public final class DTUIInstructionHandler
extends DTAbstractUIHandler {
    private final String alias;
    private final String id;
    private final ELText txt;
    private final DTInstruction[] instructions;
    private final int length;
    private final boolean literal;

    public DTUIInstructionHandler(String alias, String id, DTInstruction[] instructions, ELText txt) {
        this.alias = alias;
        this.id = id;
        this.instructions = instructions;
        this.txt = txt;
        this.length = txt.toString().length();
        boolean literal = true;
        int size = instructions.length;
        int i = 0;
        while (i < size) {
            DTInstruction ins = this.instructions[i];
            if (!ins.isLiteral()) {
                literal = false;
                break;
            }
            ++i;
        }
        this.literal = literal;
    }

    @Override
    public void apply(FaceletContext ctx, UIComponent parent) throws IOException, FacesException, FaceletException, ELException {
        if (parent != null) {
            String facetName = this.getFacetName(ctx, parent);
            String id = ctx.generateUniqueId(this.id);
            UIComponent c = null;
            FaceletCompositionContext mctx = FaceletCompositionContext.getCurrentInstance(ctx);
            if (mctx.isRefreshingSection()) {
                c = ComponentSupport.findChildByTagId(parent, id);
            }
            boolean componentFound = false;
            if (c != null) {
                componentFound = true;
                mctx.incrementUniqueComponentId();
                mctx.markForDeletion(c);
            } else {
                DTInstruction[] applied;
                String componentId = mctx.generateUniqueComponentId();
                if (this.literal) {
                    applied = this.instructions;
                } else {
                    int size = this.instructions.length;
                    applied = new DTInstruction[size];
                    int i = 0;
                    while (i < size) {
                        DTInstruction ins = this.instructions[i];
                        applied[i] = ins.apply(ctx.getExpressionFactory(), ctx);
                        ++i;
                    }
                }
                c = new DTUIInstructions(this.txt, applied);
                UniqueIdVendor uniqueIdVendor = mctx.getUniqueIdVendorFromStack();
                if (uniqueIdVendor == null) {
                    uniqueIdVendor = ComponentSupport.getViewRoot(ctx, parent);
                }
                if (uniqueIdVendor != null) {
                    String uid = uniqueIdVendor.createUniqueId(ctx.getFacesContext(), componentId);
                    c.setId(uid);
                }
                ((DTUIInstructions)c).setMarkCreated(id);
            }
            boolean oldProcessingEvents = ctx.getFacesContext().isProcessingEvents();
            if (componentFound) {
                mctx.finalizeForDeletion(c);
                if (mctx.isRefreshingSection()) {
                    ctx.getFacesContext().setProcessingEvents(false);
                }
                if (facetName == null) {
                    parent.getChildren().remove(c);
                } else {
                    ComponentSupport.removeFacet(ctx, parent, c, facetName);
                }
                if (mctx.isRefreshingSection()) {
                    ctx.getFacesContext().setProcessingEvents(oldProcessingEvents);
                }
            }
            if (componentFound && mctx.isRefreshingSection()) {
                ctx.getFacesContext().setProcessingEvents(false);
            }
            if (facetName == null) {
                parent.getChildren().add(c);
            } else {
                ComponentSupport.addFacet(ctx, parent, c, facetName);
            }
            if (componentFound && mctx.isRefreshingSection()) {
                ctx.getFacesContext().setProcessingEvents(oldProcessingEvents);
            }
        }
    }

    public String toString() {
        return this.txt.toString();
    }

    @Override
    public String getText() {
        return this.txt.toString();
    }

    @Override
    public String getText(FaceletContext ctx) {
        FastWriter writer = new FastWriter(this.length);
        try {
            this.txt.apply(ctx.getExpressionFactory(), ctx).write(writer, ctx);
        }
        catch (IOException e) {
            throw new ELException(String.valueOf(this.alias) + ": " + e.getMessage(), e.getCause());
        }
        return ((Object)writer).toString();
    }
}

