/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.jsf.facelet.dtcompiler.el;

import de.odysseus.el.tree.Node;
import de.odysseus.el.tree.Tree;
import de.odysseus.el.tree.impl.Scanner;
import de.odysseus.el.tree.impl.TreeVisitor;
import de.odysseus.el.tree.impl.ast.AstBinary;
import de.odysseus.el.tree.impl.ast.AstBoolean;
import de.odysseus.el.tree.impl.ast.AstBracket;
import de.odysseus.el.tree.impl.ast.AstChoice;
import de.odysseus.el.tree.impl.ast.AstDot;
import de.odysseus.el.tree.impl.ast.AstFunction;
import de.odysseus.el.tree.impl.ast.AstIdentifier;
import de.odysseus.el.tree.impl.ast.AstMethod;
import de.odysseus.el.tree.impl.ast.AstNode;
import de.odysseus.el.tree.impl.ast.AstNull;
import de.odysseus.el.tree.impl.ast.AstNumber;
import de.odysseus.el.tree.impl.ast.AstParameters;
import de.odysseus.el.tree.impl.ast.AstString;
import de.odysseus.el.tree.impl.ast.AstText;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import oracle.eclipse.tools.webtier.jsf.facelet.dtcontext.ELModelObjectSubExpression;
import oracle.eclipse.tools.webtier.jsf.facelet.dtcontext.IdentifierSubexpression;
import oracle.eclipse.tools.webtier.jsf.facelet.dtcontext.LocationBasedXMLTextRange;
import oracle.eclipse.tools.webtier.jsf.facelet.dtcontext.TextLocation;

public class ObjectSubExprVisitor
extends TreeVisitor {
    private final List<ELModelObjectSubExpression> _valueRefExprs = new ArrayList<ELModelObjectSubExpression>(2){
        private static final long serialVersionUID = 467566887372648196L;

        @Override
        public void add(int index, ELModelObjectSubExpression element) {
            if (element == null) {
                throw new NullPointerException("element cannot be null");
            }
            super.add(index, element);
        }

        @Override
        public boolean add(ELModelObjectSubExpression element) {
            if (element == null) {
                throw new NullPointerException("element cannot be null");
            }
            return super.add(element);
        }
    };
    private ELModelObjectSubExpression _curValueRefExpr;
    private boolean _isSimpleElExpr = true;
    private boolean _isInsideBracket;
    private boolean escapeIsHash;
    private String elText;
    private int absoluteOffsetOfStart;

    public ObjectSubExprVisitor(int absoluteOffsetOfStart) {
        this.absoluteOffsetOfStart = absoluteOffsetOfStart;
    }

    public void accept(Tree tree) {
        super.accept(tree);
        this.escapeIsHash = tree.isDeferred();
        Node child = tree.getRoot().getChild(0);
        if (child instanceof AstNode) {
            StringBuilder builder = new StringBuilder();
            ((AstNode)child).appendStructure(builder, null);
            this.elText = builder.toString();
        }
    }

    protected void endVisitIdentifier(AstIdentifier node) {
        IdentifierSubexpression subexpr = this.createIdSubExpr(node.getName(), node.getToken().getPosition(), node.getToken().getSize(), 0);
        this._curValueRefExpr = new ELModelObjectSubExpression(subexpr);
        this._valueRefExprs.add(this._curValueRefExpr);
    }

    private IdentifierSubexpression createIdSubExpr(String name, int pos, int length, int offsetIntoToken) {
        TextLocation.TextLocationWorkingCopy startLocation = new TextLocation.TextLocationWorkingCopy();
        startLocation.setAbsOffset(pos + offsetIntoToken + this.absoluteOffsetOfStart);
        TextLocation.TextLocationWorkingCopy endLocation = new TextLocation.TextLocationWorkingCopy();
        endLocation.setAbsOffset(pos - offsetIntoToken + length + this.absoluteOffsetOfStart);
        LocationBasedXMLTextRange textRange = new LocationBasedXMLTextRange(startLocation, endLocation);
        IdentifierSubexpression subexpr = new IdentifierSubexpression(name, textRange);
        return subexpr;
    }

    protected void endVisitDot(AstDot node) {
        if (this._curValueRefExpr == null) {
            this._curValueRefExpr = new ELModelObjectSubExpression();
            this._valueRefExprs.add(this._curValueRefExpr);
        }
        int pos = node.getToken().getSize();
        AstNode child = node.getChild(0);
        while (child != null) {
            Scanner.Token token;
            if (child instanceof AstDot) {
                token = ((AstDot)child).getToken();
                String propertyValue = ((AstDot)child).getPropertyValue();
                pos += token.getSize() + (propertyValue != null ? propertyValue.length() : 0);
                child = ((AstDot)child).getChild(0);
                continue;
            }
            if (!(child instanceof AstIdentifier)) continue;
            token = ((AstIdentifier)child).getToken();
            pos += token.getPosition();
            pos += token.getSize();
            child = ((AstIdentifier)child).getChild(0);
        }
        this._curValueRefExpr.addPropertyObjectName(this.createIdSubExpr(node.getPropertyValue(), pos, node.getPropertyValue().length(), 0));
    }

    protected boolean visitString(AstString node) {
        if (this._isInsideBracket) {
            if (this._curValueRefExpr == null) {
                this._curValueRefExpr = new ELModelObjectSubExpression();
            }
            this._curValueRefExpr.addPropertyObjectName(this.createIdSubExpr(this.stripQuotes(node.getValue()), node.getToken().getPosition(), node.getToken().getSize(), 1));
        } else {
            this._isSimpleElExpr = false;
        }
        return false;
    }

    protected boolean visitBracket(AstBracket node) {
        this._isInsideBracket = true;
        return true;
    }

    protected void endVisitBracket(AstBracket node) {
        this._isInsideBracket = false;
    }

    protected boolean visitChoice(AstChoice node) {
        this._isSimpleElExpr = false;
        return true;
    }

    protected boolean visitBoolean(AstBoolean node) {
        this._isSimpleElExpr = false;
        return true;
    }

    protected boolean visitMethod(AstMethod node) {
        this._isSimpleElExpr = false;
        return true;
    }

    protected boolean visitBinary(AstBinary node) {
        this._isSimpleElExpr = false;
        return true;
    }

    protected boolean visitOtherNode(Node node) {
        this._isSimpleElExpr = false;
        return false;
    }

    protected boolean visitText(AstText node) {
        this._isSimpleElExpr = false;
        return false;
    }

    protected boolean visitParameters(AstParameters node) {
        this._isSimpleElExpr = false;
        return false;
    }

    protected boolean visitNumber(AstNumber node) {
        this._isSimpleElExpr = false;
        return false;
    }

    protected boolean visitNull(AstNull node) {
        this._isSimpleElExpr = false;
        return false;
    }

    protected boolean visitFunction(AstFunction node) {
        this._isSimpleElExpr = false;
        return true;
    }

    protected final boolean isSimpleElExpr() {
        return this._isSimpleElExpr;
    }

    public List<ELModelObjectSubExpression> getValueRefExprs() {
        if (this._valueRefExprs.isEmpty()) {
            return Collections.emptyList();
        }
        return this._valueRefExprs;
    }

    public boolean getEscapeTypeIsHash() {
        return this.escapeIsHash;
    }

    public String getElText() {
        return this.elText;
    }

    private String stripQuotes(String stringLiteral) {
        if (stringLiteral.startsWith("'") || stringLiteral.startsWith("\"")) {
            if (stringLiteral.length() > 2) {
                return stringLiteral.substring(1, stringLiteral.length() - 1);
            }
            return "";
        }
        return stringLiteral;
    }
}

