/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.jsf.facelet.dtcompiler.cu;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import javax.el.ELException;
import javax.faces.application.FacesMessage;
import javax.faces.view.facelets.FaceletException;
import javax.faces.view.facelets.FaceletHandler;
import javax.faces.view.facelets.Tag;
import javax.faces.view.facelets.TagAttribute;
import javax.faces.view.facelets.TagException;
import oracle.eclipse.tools.webtier.jsf.facelet.dtcompiler.DTLocation;
import oracle.eclipse.tools.webtier.jsf.facelet.dtcompiler.ELBufferScanner;
import oracle.eclipse.tools.webtier.jsf.facelet.dtcompiler.cu.DTCompilationUnit;
import oracle.eclipse.tools.webtier.jsf.facelet.dtcompiler.cu.UnknownDTTagUnit;
import oracle.eclipse.tools.webtier.jsf.facelet.dtcompiler.handler.DTCompositeFaceletHandler;
import oracle.eclipse.tools.webtier.jsf.facelet.dtcompiler.handler.DTUIInstructionHandler;
import oracle.eclipse.tools.webtier.jsf.facelet.dtcompiler.instruction.DTAddFacesMessageInstruction;
import oracle.eclipse.tools.webtier.jsf.facelet.dtcompiler.instruction.DTAttributeInstruction;
import oracle.eclipse.tools.webtier.jsf.facelet.dtcompiler.instruction.DTBodyEndElementInstruction;
import oracle.eclipse.tools.webtier.jsf.facelet.dtcompiler.instruction.DTCommentInstruction;
import oracle.eclipse.tools.webtier.jsf.facelet.dtcompiler.instruction.DTEndElementInstruction;
import oracle.eclipse.tools.webtier.jsf.facelet.dtcompiler.instruction.DTInstruction;
import oracle.eclipse.tools.webtier.jsf.facelet.dtcompiler.instruction.DTLiteralAttributeInstruction;
import oracle.eclipse.tools.webtier.jsf.facelet.dtcompiler.instruction.DTLiteralCommentInstruction;
import oracle.eclipse.tools.webtier.jsf.facelet.dtcompiler.instruction.DTLiteralNonExcapedTextInstruction;
import oracle.eclipse.tools.webtier.jsf.facelet.dtcompiler.instruction.DTLiteralTextInstruction;
import oracle.eclipse.tools.webtier.jsf.facelet.dtcompiler.instruction.DTLiteralXMLInstruction;
import oracle.eclipse.tools.webtier.jsf.facelet.dtcompiler.instruction.DTStartElementInstruction;
import oracle.eclipse.tools.webtier.jsf.facelet.dtcompiler.instruction.DTXMLInstruction;
import oracle.eclipse.tools.webtier.jsf.facelet.dtcontext.DesignTimeContext;
import oracle.eclipse.tools.webtier.jsf.facelet.dtcontext.DesignTimeContextData;
import oracle.eclipse.tools.webtier.jsf.facelet.dtcontext.LocationBasedXMLTextRange;
import oracle.eclipse.tools.webtier.jsf.facelet.dtcontext.TagError;
import org.apache.myfaces.view.facelets.el.ELText;
import org.apache.myfaces.view.facelets.tag.TagAttributeImpl;
import org.apache.myfaces.view.facelets.tag.TagAttributesImpl;

public final class DTTextUnit
extends DTCompilationUnit {
    private final StringBuffer buffer;
    private final StringBuffer textBuffer;
    private final List<DTInstruction> instructionBuffer;
    private final Stack<Tag> tags;
    private final List<Object> children;
    private boolean startTagOpen;
    private final String alias;
    private final String id;
    private final List<Object> messages;
    private final boolean compressSpaces;

    public DTTextUnit(String alias, String id, DTLocation location) {
        this(alias, id, true, location);
    }

    public DTTextUnit(String alias, String id, boolean escapeInlineText, DTLocation location) {
        this(alias, id, escapeInlineText, false, location);
    }

    public DTTextUnit(String alias, String id, boolean escapeInlineText, boolean compressSpaces, DTLocation location) {
        this.alias = alias;
        this.id = id;
        this.buffer = new StringBuffer();
        this.textBuffer = new StringBuffer();
        this.instructionBuffer = new ArrayList<DTInstruction>();
        this.tags = new Stack();
        this.children = new ArrayList<Object>();
        this.startTagOpen = false;
        this.messages = new ArrayList<Object>(4);
        this.compressSpaces = compressSpaces;
    }

    @Override
    public FaceletHandler createFaceletHandler() {
        this.flushBufferToConfig(true);
        if (this.children.size() == 0) {
            return LEAF;
        }
        FaceletHandler[] h = new FaceletHandler[this.children.size()];
        int i = 0;
        while (i < h.length) {
            Object obj = this.children.get(i);
            if (obj instanceof FaceletHandler) {
                h[i] = (FaceletHandler)obj;
            } else {
                try {
                    h[i] = ((DTCompilationUnit)obj).createFaceletHandler();
                }
                catch (FaceletException fe) {
                    DesignTimeContext.getCurrentInstance().reportTagError(new TagError("", "", fe));
                    TagAttribute[] attrs = new TagAttribute[]{new TagAttributeImpl(null, "", "name", "name", "unknownTagname")};
                    h[i] = new UnknownDTTagUnit(null, "http://oracle.com/unknown", "unknownTag", new Tag(null, "http://oracle.com/unknown", "unknownTag", null, new TagAttributesImpl(attrs)), this.id).createFaceletHandler();
                }
            }
            ++i;
        }
        if (h.length == 1) {
            return h[0];
        }
        return new DTCompositeFaceletHandler(h);
    }

    private void addInstruction(DTInstruction instruction) {
        this.flushTextBuffer(false);
        this.instructionBuffer.add(instruction);
    }

    private void flushTextBuffer(boolean child) {
        if (this.textBuffer.length() > 0) {
            String s = this.textBuffer.toString();
            s.length();
        }
        this.textBuffer.setLength(0);
    }

    public void write(String text, int startOffset) {
        List<DesignTimeContextData.ELRange> ranges = ELBufferScanner.scanText(text.toCharArray(), 0, text.length(), startOffset);
        if (!ranges.isEmpty()) {
            for (DesignTimeContextData.ELRange range : ranges) {
                DesignTimeContext.getCurrentInstance().reportELText(range);
            }
        }
        this.finishStartTag();
        this.textBuffer.append(text);
        this.buffer.append(text);
    }

    public void writeInstruction(String text) {
        this.finishStartTag();
        ELText el = ELText.parse(text);
        if (el.isLiteral()) {
            this.addInstruction(new DTLiteralXMLInstruction(text));
        } else {
            this.addInstruction(new DTXMLInstruction(el));
        }
        this.buffer.append(text);
    }

    public void writeComment(String text) {
        this.finishStartTag();
        ELText el = ELText.parse(text);
        if (el.isLiteral()) {
            this.addInstruction(new DTLiteralCommentInstruction(text));
        } else {
            this.addInstruction(new DTCommentInstruction(el));
        }
        this.buffer.append("<!--" + text + "-->");
    }

    public void startTag(Tag tag) {
        this.finishStartTag();
        this.tags.push(tag);
        this.buffer.append('<');
        this.buffer.append(tag.getQName());
        this.addInstruction(new DTStartElementInstruction(tag.getQName()));
        TagAttribute[] attrs = tag.getAttributes().getAll();
        if (attrs.length > 0) {
            int i = 0;
            while (i < attrs.length) {
                String qname = attrs[i].getQName();
                String value = attrs[i].getValue();
                this.buffer.append(' ').append(qname).append("=\"").append(value).append("\"");
                ELText txt = ELText.parse(value);
                if (txt != null) {
                    if (txt.isLiteral()) {
                        this.addInstruction(new DTLiteralAttributeInstruction(qname, txt.toString()));
                    } else {
                        this.addInstruction(new DTAttributeInstruction(this.alias, qname, txt));
                    }
                }
                ++i;
            }
        }
        if (!this.messages.isEmpty()) {
            Iterator<Object> it = this.messages.iterator();
            while (it.hasNext()) {
                Object[] message = (Object[])it.next();
                this.addInstruction(new DTAddFacesMessageInstruction((FacesMessage.Severity)message[0], (String)message[1], (String)message[2]));
                it.remove();
            }
        }
        this.startTagOpen = true;
    }

    private void finishStartTag() {
        if (this.tags.size() > 0 && this.startTagOpen) {
            this.buffer.append(">");
            this.startTagOpen = false;
        }
    }

    public void endTag() {
        Tag tag = this.tags.pop();
        if ("body".equalsIgnoreCase(tag.getQName())) {
            this.addInstruction(new DTBodyEndElementInstruction(tag.getQName()));
        } else {
            this.addInstruction(new DTEndElementInstruction(tag.getQName()));
        }
        if (this.startTagOpen) {
            this.buffer.append("/>");
            this.startTagOpen = false;
        } else {
            this.buffer.append("</").append(tag.getQName()).append('>');
        }
    }

    @Override
    public void addChild(DTCompilationUnit unit) {
        this.finishStartTag();
        this.flushBufferToConfig(true);
        this.children.add(unit);
    }

    protected void flushBufferToConfig(boolean child) {
        this.flushTextBuffer(child);
        int size = this.instructionBuffer.size();
        if (size > 0) {
            try {
                ELText txt;
                String s = this.buffer.toString();
                if (child) {
                    s = DTTextUnit.trimRight(s);
                }
                if ((txt = ELText.parse(s)) != null) {
                    if (this.compressSpaces) {
                        size = DTTextUnit.compressSpaces(this.instructionBuffer, size);
                    }
                    DTInstruction[] instructions = this.instructionBuffer.toArray(new DTInstruction[size]);
                    this.children.add(new DTUIInstructionHandler(this.alias, this.id, instructions, txt));
                    this.instructionBuffer.clear();
                }
            }
            catch (ELException e) {
                if (this.tags.size() > 0) {
                    throw new TagException(this.tags.peek(), e.getMessage());
                }
                throw new ELException(String.valueOf(this.alias) + ": " + e.getMessage(), e.getCause());
            }
        }
        this.buffer.setLength(0);
    }

    public boolean isClosed() {
        return this.tags.empty();
    }

    private static final String trimRight(String s) {
        int i = s.length() - 1;
        while (i >= 0 && Character.isWhitespace(s.charAt(i))) {
            --i;
        }
        if (i >= 0) {
            return s;
        }
        return "";
    }

    static final String compressELText(String text) {
        int firstCharLocation = DTTextUnit.getFirstTextCharLocationIgnoringSpacesTabsAndCarriageReturn(text);
        int lastCharLocation = DTTextUnit.getLastTextCharLocationIgnoringSpacesTabsAndCarriageReturn(text);
        if (firstCharLocation == 0 && lastCharLocation == text.length() - 1) {
            return text;
        }
        if (lastCharLocation + 1 < text.length()) {
            ++lastCharLocation;
        }
        if (firstCharLocation == 0) {
            return text.substring(firstCharLocation, lastCharLocation + 1);
        }
        return String.valueOf(text.substring(0, 1)) + text.substring(firstCharLocation, lastCharLocation + 1);
    }

    static final int compressSpaces(List<DTInstruction> instructionBuffer, int size) {
        boolean addleftspace = true;
        boolean addrightspace = false;
        int i = 0;
        while (i < size) {
            int lastCharLocation;
            int firstCharLocation;
            String text;
            DTInstruction ins = instructionBuffer.get(i);
            if (i + 1 == size) {
                addrightspace = true;
            }
            if (ins instanceof DTLiteralTextInstruction) {
                text = ((DTLiteralTextInstruction)ins).getText();
                firstCharLocation = DTTextUnit.getFirstTextCharLocationIgnoringSpacesTabsAndCarriageReturn(text);
                if (firstCharLocation == text.length() && text.length() > 1) {
                    if (addleftspace || addrightspace) {
                        instructionBuffer.set(i, new DTLiteralTextInstruction(text.substring(0, 1)));
                    } else {
                        instructionBuffer.remove(i);
                        --i;
                        --size;
                    }
                } else if (firstCharLocation > 0) {
                    lastCharLocation = DTTextUnit.getLastTextCharLocationIgnoringSpacesTabsAndCarriageReturn(text);
                    if (lastCharLocation + 1 < text.length()) {
                        ++lastCharLocation;
                    }
                    instructionBuffer.set(i, new DTLiteralTextInstruction(String.valueOf(text.substring(0, 1)) + text.substring(firstCharLocation, lastCharLocation + 1)));
                } else {
                    lastCharLocation = DTTextUnit.getLastTextCharLocationIgnoringSpacesTabsAndCarriageReturn(text);
                    if (lastCharLocation + 1 < text.length()) {
                        ++lastCharLocation;
                    }
                    instructionBuffer.set(i, new DTLiteralTextInstruction(text.substring(firstCharLocation, lastCharLocation + 1)));
                }
            } else if (ins instanceof DTLiteralNonExcapedTextInstruction) {
                text = ((DTLiteralTextInstruction)ins).getText();
                firstCharLocation = DTTextUnit.getFirstTextCharLocationIgnoringSpacesTabsAndCarriageReturn(text);
                if (firstCharLocation == text.length()) {
                    if (addleftspace || addrightspace) {
                        instructionBuffer.set(i, new DTLiteralNonExcapedTextInstruction(text.substring(0, 1)));
                    } else {
                        instructionBuffer.remove(i);
                        --i;
                        --size;
                    }
                } else if (firstCharLocation > 1) {
                    lastCharLocation = DTTextUnit.getLastTextCharLocationIgnoringSpacesTabsAndCarriageReturn(text);
                    if (lastCharLocation + 1 < text.length()) {
                        ++lastCharLocation;
                    }
                    instructionBuffer.set(i, new DTLiteralNonExcapedTextInstruction(String.valueOf(text.substring(0, 1)) + text.substring(firstCharLocation, lastCharLocation + 1)));
                } else {
                    lastCharLocation = DTTextUnit.getLastTextCharLocationIgnoringSpacesTabsAndCarriageReturn(text);
                    if (lastCharLocation + 1 < text.length()) {
                        ++lastCharLocation;
                    }
                    instructionBuffer.set(i, new DTLiteralNonExcapedTextInstruction(text.substring(firstCharLocation, lastCharLocation + 1)));
                }
            }
            addleftspace = false;
            ++i;
        }
        return size;
    }

    private static int getFirstTextCharLocationIgnoringSpacesTabsAndCarriageReturn(String text) {
        int i = 0;
        while (i < text.length()) {
            if (!Character.isWhitespace(text.charAt(i))) {
                return i;
            }
            ++i;
        }
        return text.length();
    }

    private static int getLastTextCharLocationIgnoringSpacesTabsAndCarriageReturn(String text) {
        int i = text.length() - 1;
        while (i >= 0) {
            if (!Character.isWhitespace(text.charAt(i))) {
                return i;
            }
            --i;
        }
        return 0;
    }

    public String toString() {
        return "TextUnit[" + this.children.size() + "]";
    }

    public void addMessage(FacesMessage.Severity severity, String summary, String detail) {
        this.messages.add(new Object[]{severity, summary, detail});
        DesignTimeContext.getCurrentInstance().reportTagError(new TagError("", "", detail, new LocationBasedXMLTextRange()));
    }
}

