/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.jsf.facelet.dtcompiler;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import oracle.eclipse.tools.webtier.jsf.facelet.dtcompiler.DTLocator3;
import oracle.eclipse.tools.webtier.jsf.facelet.dtcompiler.OffsetRecordingBufferedReader;
import oracle.eclipse.tools.webtier.jsf.facelet.dtcontext.DesignTimeContextData;
import oracle.eclipse.tools.webtier.jsf.facelet.dtcontext.TextLocation;
import oracle.eclipse.tools.webtier.jsf.facelet.dtcontext.XMLTextRange;
import org.codehaus.stax2.LocationInfo;
import org.codehaus.stax2.XMLStreamReader2;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.ext.Locator2;
import org.xml.sax.helpers.AttributesImpl;

public class StaxStreamXMLReader
implements XMLReader {
    private static final String DEFAULT_XML_VERSION = "1.0";
    private static final String NAMESPACES_FEATURE_NAME = "http://xml.org/sax/features/namespaces";
    private static final String NAMESPACE_PREFIXES_FEATURE_NAME = "http://xml.org/sax/features/namespace-prefixes";
    private static final String IS_STANDALONE_FEATURE_NAME = "http://xml.org/sax/features/is-standalone";
    private DTDHandler dtdHandler;
    private ContentHandler contentHandler;
    private EntityResolver entityResolver;
    private ErrorHandler errorHandler;
    private LexicalHandler lexicalHandler;
    private boolean namespacesFeature = true;
    private boolean namespacePrefixesFeature = false;
    private Boolean isStandalone;
    private final Map<String, String> namespaces = new LinkedHashMap<String, String>();
    private final XMLStreamReader2 reader;
    private String xmlVersion = "1.0";
    private String encoding;
    private final OffsetRecordingBufferedReader bfr;
    private Object undeclaredEntityResolver;

    StaxStreamXMLReader(XMLStreamReader2 reader, OffsetRecordingBufferedReader bfr) {
        if (reader == null) {
            throw new IllegalArgumentException("'reader' must not be null");
        }
        int event = reader.getEventType();
        if (event != 7 && event != 1) {
            throw new IllegalStateException("XMLEventReader not at start of document or element");
        }
        this.reader = reader;
        this.bfr = bfr;
    }

    protected void parseInternal() throws SAXException, XMLStreamException {
        boolean documentStarted = false;
        boolean documentEnded = false;
        int elementDepth = 0;
        if (this.undeclaredEntityResolver != null) {
            this.reader.setProperty("com.ctc.wstx.undeclaredEntityResolver", this.undeclaredEntityResolver);
        }
        int eventType = this.reader.getEventType();
        while (true) {
            if (eventType != 7 && eventType != 8 && !documentStarted) {
                this.handleStartDocument();
                documentStarted = true;
            }
            switch (eventType) {
                case 1: {
                    ++elementDepth;
                    this.handleStartElement();
                    break;
                }
                case 2: {
                    if (--elementDepth < 0) break;
                    this.handleEndElement();
                    break;
                }
                case 3: {
                    this.handleProcessingInstruction();
                    break;
                }
                case 4: 
                case 6: 
                case 12: {
                    this.handleCharacters();
                    break;
                }
                case 7: {
                    this.handleStartDocument();
                    documentStarted = true;
                    break;
                }
                case 8: {
                    this.handleEndDocument();
                    documentEnded = true;
                    break;
                }
                case 5: {
                    this.handleComment();
                    break;
                }
                case 11: {
                    this.handleDtd();
                    break;
                }
                case 9: {
                    this.handleEntityReference();
                }
            }
            if (!this.reader.hasNext() || elementDepth < 0) break;
            eventType = this.reader.next();
        }
        if (!documentEnded) {
            this.handleEndDocument();
        }
    }

    private void handleStartDocument() throws SAXException, XMLStreamException {
        if (7 == this.reader.getEventType()) {
            String xmlVersion = this.reader.getVersion();
            if (StaxStreamXMLReader.isNotEmpty(xmlVersion)) {
                this.xmlVersion = xmlVersion;
            }
            this.encoding = this.reader.getCharacterEncodingScheme();
        }
        if (this.getContentHandler() != null) {
            this.setLocatorForStartDocument();
            this.getContentHandler().startDocument();
            if (this.reader.standaloneSet()) {
                this.setStandalone(this.reader.isStandalone());
            }
        }
    }

    private void handleStartElement() throws SAXException, XMLStreamException {
        if (this.getContentHandler() != null) {
            this.setLocatorForElements(this.reader.getAttributeCount());
            QName qName = this.reader.getName();
            if (this.hasNamespacesFeature()) {
                int i = 0;
                while (i < this.reader.getNamespaceCount()) {
                    this.startPrefixMapping(this.reader.getNamespacePrefix(i), this.reader.getNamespaceURI(i));
                    ++i;
                }
                i = 0;
                while (i < this.reader.getAttributeCount()) {
                    String prefix = this.reader.getAttributePrefix(i);
                    String namespace = this.reader.getAttributeNamespace(i);
                    if (StaxStreamXMLReader.isNotEmpty(namespace)) {
                        this.startPrefixMapping(prefix, namespace);
                    }
                    ++i;
                }
                this.getContentHandler().startElement(qName.getNamespaceURI(), qName.getLocalPart(), this.toQualifiedName(qName), this.getAttributes());
            } else {
                this.getContentHandler().startElement("", "", this.toQualifiedName(qName), this.getAttributes());
            }
        }
    }

    private void setLocatorForStartDocument() throws XMLStreamException {
        LocationInfo locationInfo = this.reader.getLocationInfo();
        long startingCharOffset = locationInfo.getStartingCharOffset();
        if (startingCharOffset >= (long)this.bfr.getStartOffset() && startingCharOffset < (long)this.bfr.getEndOffset()) {
            this.getContentHandler().setDocumentLocator(new DTLocator3(this.reader.getLocation(), locationInfo, this.xmlVersion, this.encoding, null, null, 0, this.bfr));
        }
    }

    private void setLocatorForElements(int numAttrs) throws XMLStreamException {
        LocationInfo locationInfo = this.reader.getLocationInfo();
        String prefix = this.reader.getPrefix();
        QName elemName = this.reader.getName();
        this.getContentHandler().setDocumentLocator(new DTLocator3(this.reader.getLocation(), locationInfo, this.xmlVersion, this.encoding, prefix, elemName, numAttrs, this.bfr));
    }

    private void setLocatorForCharacters() throws XMLStreamException {
        LocationInfo locationInfo = this.reader.getLocationInfo();
        this.getContentHandler().setDocumentLocator(new DTLocator3(this.reader.getLocation(), locationInfo, this.xmlVersion, this.encoding, null, null, 0, this.bfr));
    }

    private void handleEndElement() throws SAXException, XMLStreamException {
        if (this.getContentHandler() != null) {
            QName qName = this.reader.getName();
            this.setLocatorForElements(-1);
            if (this.hasNamespacesFeature()) {
                this.getContentHandler().endElement(qName.getNamespaceURI(), qName.getLocalPart(), this.toQualifiedName(qName));
                int i = 0;
                while (i < this.reader.getNamespaceCount()) {
                    String prefix = this.reader.getNamespacePrefix(i);
                    if (prefix == null) {
                        prefix = "";
                    }
                    this.endPrefixMapping(prefix);
                    ++i;
                }
            } else {
                this.getContentHandler().endElement("", "", this.toQualifiedName(qName));
            }
        }
    }

    private void handleCharacters() throws SAXException, XMLStreamException {
        if (this.getContentHandler() != null) {
            this.setLocatorForCharacters();
        }
        if (this.getContentHandler() != null && this.reader.isWhiteSpace()) {
            this.getContentHandler().ignorableWhitespace(this.reader.getTextCharacters(), this.reader.getTextStart(), this.reader.getTextLength());
            return;
        }
        if (12 == this.reader.getEventType() && this.getLexicalHandler() != null) {
            this.getLexicalHandler().startCDATA();
        }
        if (this.getContentHandler() != null) {
            this.getContentHandler().characters(this.reader.getTextCharacters(), this.reader.getTextStart(), this.reader.getTextLength());
        }
        if (12 == this.reader.getEventType() && this.getLexicalHandler() != null) {
            this.getLexicalHandler().endCDATA();
        }
    }

    private void handleComment() throws SAXException {
        if (this.getLexicalHandler() != null) {
            this.getLexicalHandler().comment(this.reader.getTextCharacters(), this.reader.getTextStart(), this.reader.getTextLength());
        }
    }

    private void handleDtd() throws SAXException {
        if (this.getLexicalHandler() != null) {
            Location location = this.reader.getLocation();
            this.getLexicalHandler().startDTD(null, location.getPublicId(), location.getSystemId());
        }
        if (this.getLexicalHandler() != null) {
            this.getLexicalHandler().endDTD();
        }
    }

    private void handleEntityReference() throws SAXException {
        if (this.getLexicalHandler() != null) {
            this.getLexicalHandler().startEntity(this.reader.getLocalName());
        }
        if (this.getLexicalHandler() != null) {
            this.getLexicalHandler().endEntity(this.reader.getLocalName());
        }
    }

    private void handleEndDocument() throws SAXException {
        if (this.getContentHandler() != null) {
            this.getContentHandler().endDocument();
        }
    }

    private void handleProcessingInstruction() throws SAXException {
        if (this.getContentHandler() != null) {
            this.getContentHandler().processingInstruction(this.reader.getPITarget(), this.reader.getPIData());
        }
    }

    private Attributes getAttributes() {
        AttributesImpl attributes = new AttributesImpl();
        int i = 0;
        while (i < this.reader.getAttributeCount()) {
            String type;
            String namespace = this.reader.getAttributeNamespace(i);
            if (namespace == null || !this.hasNamespacesFeature()) {
                namespace = "";
            }
            if ((type = this.reader.getAttributeType(i)) == null) {
                type = "CDATA";
            }
            attributes.addAttribute(namespace, this.reader.getAttributeLocalName(i), this.toQualifiedName(this.reader.getAttributeName(i)), type, this.reader.getAttributeValue(i));
            ++i;
        }
        if (this.hasNamespacePrefixesFeature()) {
            i = 0;
            while (i < this.reader.getNamespaceCount()) {
                String prefix = this.reader.getNamespacePrefix(i);
                String namespaceUri = this.reader.getNamespaceURI(i);
                String qName = StaxStreamXMLReader.isNotEmpty(prefix) ? "xmlns:" + prefix : "xmlns";
                attributes.addAttribute("", "", qName, "CDATA", namespaceUri);
                ++i;
            }
        }
        return attributes;
    }

    @Override
    public boolean getFeature(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (NAMESPACES_FEATURE_NAME.equals(name)) {
            return this.namespacesFeature;
        }
        if (NAMESPACE_PREFIXES_FEATURE_NAME.equals(name)) {
            return this.namespacePrefixesFeature;
        }
        if (IS_STANDALONE_FEATURE_NAME.equals(name)) {
            if (this.isStandalone != null) {
                return this.isStandalone;
            }
            throw new SAXNotSupportedException("startDocument() callback not completed yet");
        }
        throw new SAXNotRecognizedException(name);
    }

    @Override
    public void setFeature(String name, boolean value) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (NAMESPACES_FEATURE_NAME.equals(name)) {
            this.namespacesFeature = value;
        } else if (NAMESPACE_PREFIXES_FEATURE_NAME.equals(name)) {
            this.namespacePrefixesFeature = value;
        } else {
            throw new SAXNotRecognizedException(name);
        }
    }

    protected void setStandalone(boolean standalone) {
        this.isStandalone = standalone;
    }

    protected boolean hasNamespacesFeature() {
        return this.namespacesFeature;
    }

    protected boolean hasNamespacePrefixesFeature() {
        return this.namespacePrefixesFeature;
    }

    protected String toQualifiedName(QName qName) {
        String prefix = qName.getPrefix();
        if (!StaxStreamXMLReader.isNotEmpty(prefix)) {
            return qName.getLocalPart();
        }
        return String.valueOf(prefix) + ":" + qName.getLocalPart();
    }

    @Override
    public final void parse(InputSource ignored) throws SAXException {
        this.parse();
    }

    @Override
    public final void parse(String ignored) throws SAXException {
        this.parse();
    }

    private void parse() throws SAXException {
        try {
            this.parseInternal();
        }
        catch (XMLStreamException ex) {
            StaxLocator locator = null;
            if (ex.getLocation() != null) {
                locator = new StaxLocator(ex.getLocation());
            }
            SAXParseException saxException = new SAXParseException(ex.getMessage(), locator, ex);
            if (this.getErrorHandler() != null) {
                this.getErrorHandler().fatalError(saxException);
            }
            throw saxException;
        }
    }

    protected void startPrefixMapping(String prefix, String namespace) throws SAXException {
        if (this.getContentHandler() != null) {
            if (prefix == null) {
                prefix = "";
            }
            if (!StaxStreamXMLReader.isNotEmpty(namespace)) {
                return;
            }
            if (!namespace.equals(this.namespaces.get(prefix))) {
                this.getContentHandler().startPrefixMapping(prefix, namespace);
                this.namespaces.put(prefix, namespace);
            }
        }
    }

    protected void endPrefixMapping(String prefix) throws SAXException {
        if (this.getContentHandler() != null && this.namespaces.containsKey(prefix)) {
            this.getContentHandler().endPrefixMapping(prefix);
            this.namespaces.remove(prefix);
        }
    }

    @Override
    public ContentHandler getContentHandler() {
        return this.contentHandler;
    }

    @Override
    public void setContentHandler(ContentHandler contentHandler) {
        this.contentHandler = contentHandler;
    }

    @Override
    public void setDTDHandler(DTDHandler dtdHandler) {
        this.dtdHandler = dtdHandler;
    }

    @Override
    public DTDHandler getDTDHandler() {
        return this.dtdHandler;
    }

    @Override
    public EntityResolver getEntityResolver() {
        return this.entityResolver;
    }

    @Override
    public void setEntityResolver(EntityResolver entityResolver) {
        this.entityResolver = entityResolver;
    }

    @Override
    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    @Override
    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    protected LexicalHandler getLexicalHandler() {
        return this.lexicalHandler;
    }

    @Override
    public Object getProperty(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        if ("http://xml.org/sax/properties/lexical-handler".equals(name)) {
            return this.lexicalHandler;
        }
        throw new SAXNotRecognizedException(name);
    }

    @Override
    public void setProperty(String name, Object value) throws SAXNotRecognizedException, SAXNotSupportedException {
        if ("http://xml.org/sax/properties/lexical-handler".equals(name)) {
            this.lexicalHandler = (LexicalHandler)value;
        } else if ("com.ctc.wstx.undeclaredEntityResolver".equals(name)) {
            this.undeclaredEntityResolver = value;
        } else {
            throw new SAXNotRecognizedException(name);
        }
    }

    public String getEncoding() {
        return this.encoding;
    }

    public int getEndOffset() {
        return 0;
    }

    public int getStartOffset() {
        return 0;
    }

    public TextLocation getTextLocation() {
        return null;
    }

    public XMLTextRange getElementRange() {
        return null;
    }

    public static boolean isNotEmpty(Object value) {
        if (value == null) {
            return false;
        }
        if (value instanceof String) {
            String text = (String)value;
            return text.trim().length() > 0;
        }
        return true;
    }

    public static interface Locator3
    extends Locator2 {
        public int getCharacterOffset();

        public Location getLocation();

        public XMLTextRange getAttributeValueRange(String var1);

        public List<DesignTimeContextData.ELRange> getELRanges(String var1);

        public int getEndOffset();

        public int getStartOffset();

        public TextLocation getTextLocation();

        public XMLTextRange getAttributeNameRange(String var1);

        public XMLTextRange getElementRange();

        public XMLTextRange getStartElementRange();
    }

    private static class StaxLocator
    implements Locator {
        private final Location location;

        protected StaxLocator(Location location) {
            this.location = location;
        }

        @Override
        public String getPublicId() {
            return this.location.getPublicId();
        }

        @Override
        public String getSystemId() {
            return this.location.getSystemId();
        }

        @Override
        public int getLineNumber() {
            return this.location.getLineNumber();
        }

        @Override
        public int getColumnNumber() {
            return this.location.getColumnNumber();
        }
    }
}

