/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.jsf.facelet.dtcompiler;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;

public class OffsetRecordingBufferedReader
extends BufferedReader {
    private char[] lastBuffer = null;
    private char[] prevBuffer = null;
    private int prevReadSize = 0;
    private int lastReadSize = 0;
    private int startOffset = 0;
    private int endOffset = 0;
    private int markStartLocation = -1;
    private int markEndLocation = -1;
    private char[] markedBuffer;

    public OffsetRecordingBufferedReader(Reader in) {
        super(in);
    }

    public OffsetRecordingBufferedReader(Reader in, int sz) {
        super(in, sz);
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        this.prevReadSize = this.lastReadSize;
        this.lastReadSize = super.read(cbuf, off, len);
        if (this.lastReadSize > -1) {
            this.startOffset = this.endOffset;
            this.prevBuffer = this.lastBuffer;
            this.endOffset = this.startOffset + this.lastReadSize;
            this.lastBuffer = new char[this.lastReadSize];
            System.arraycopy(cbuf, off, this.lastBuffer, 0, this.lastReadSize);
        }
        return this.lastReadSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mark(int readAheadLimit) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            super.mark(readAheadLimit);
            this.markStartLocation = this.startOffset;
            this.markEndLocation = this.endOffset;
            if (this.lastBuffer != null) {
                this.markedBuffer = new char[this.lastBuffer.length];
                System.arraycopy(this.lastBuffer, 0, this.markedBuffer, 0, this.lastBuffer.length);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            super.reset();
            if (this.markStartLocation > -1) {
                this.startOffset = this.markStartLocation;
                this.markStartLocation = -1;
                this.endOffset = this.markEndLocation;
                this.markEndLocation = -1;
                this.lastBuffer = this.markedBuffer;
                this.markedBuffer = null;
            }
        }
    }

    public int getBytesRead() {
        return this.lastReadSize;
    }

    public char getByte(int offset) {
        if (offset >= this.startOffset) {
            if (offset < this.endOffset) {
                return this.lastBuffer[offset - this.startOffset];
            }
            throw new ArrayIndexOutOfBoundsException(String.format("%d is beyond the buffer read so far which is %d", offset, this.endOffset));
        }
        if (offset > this.startOffset - this.prevReadSize) {
            return this.prevBuffer[this.prevReadSize - (this.startOffset - offset)];
        }
        throw new ArrayIndexOutOfBoundsException("Trying to read too far back in buffer");
    }

    public char[] getBufferRange(int startOffset, int endOffset) {
        if (endOffset - startOffset < 0) {
            endOffset = startOffset;
        }
        char[] buffer = new char[endOffset - startOffset];
        if (startOffset >= this.startOffset) {
            System.arraycopy(this.lastBuffer, startOffset - this.startOffset, buffer, 0, buffer.length);
        } else {
            int offsetIntoPrev = -1;
            int lengthInPrev = -1;
            if (endOffset < this.startOffset) {
                offsetIntoPrev = this.prevReadSize - (this.startOffset - startOffset);
                lengthInPrev = endOffset - startOffset;
            } else {
                offsetIntoPrev = this.prevReadSize - (this.startOffset - startOffset);
                lengthInPrev = this.prevReadSize - offsetIntoPrev;
            }
            System.arraycopy(this.prevBuffer, offsetIntoPrev, buffer, 0, lengthInPrev);
            if (startOffset + lengthInPrev >= this.startOffset) {
                System.arraycopy(this.lastBuffer, 0, buffer, lengthInPrev, buffer.length - lengthInPrev);
            }
        }
        return buffer;
    }

    public char[] getBytes(int startOffset, int endOffset) {
        return this.lastBuffer;
    }

    public int getStartOffset() {
        return this.startOffset;
    }

    public int getEndOffset() {
        return this.endOffset;
    }
}

