/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.jsf.facelet.dtcompiler;

import java.util.ArrayList;
import java.util.List;
import oracle.eclipse.tools.webtier.jsf.facelet.dtcontext.DesignTimeContextData;

public class ELBufferScanner {
    public static List<DesignTimeContextData.ELRange> scanText(char[] chars, int bufferFrom, int length, int adjustStartOffset) {
        ArrayList<DesignTimeContextData.ELRange> ranges = new ArrayList<DesignTimeContextData.ELRange>();
        ELParseState state = ELParseState.START;
        int i = bufferFrom;
        while (i < bufferFrom + length) {
            state = ELBufferScanner.handleAttributeValueChar(chars[i], i, state, ranges);
            ++i;
        }
        for (DesignTimeContextData.ELRange range : ranges) {
            int startOffset = range.getStartOffset();
            range.setELText(new String(chars, startOffset, range.getEndOffset() - startOffset));
            range.setStartOffset(startOffset + adjustStartOffset + 1);
            range.setEndOffset(range.getEndOffset() + adjustStartOffset);
        }
        return ranges;
    }

    public static ELParseState handleAttributeValueChar(char curChar, int i, ELParseState elstate, List<DesignTimeContextData.ELRange> elRanges) {
        switch (elstate) {
            case START: 
            case LITERAL_TEXT: 
            case EL_CLOSE_BRACE: {
                if (curChar == '#') {
                    return ELParseState.HASH_START;
                }
                if (curChar == '$') {
                    return ELParseState.DOLLAR_START;
                }
                if (curChar == '\\') {
                    return ELParseState.BACK_SLASH;
                }
                return ELParseState.LITERAL_TEXT;
            }
            case BACK_SLASH: {
                if (curChar == '\\') {
                    return ELParseState.BACK_SLASH;
                }
                return ELParseState.LITERAL_TEXT;
            }
            case HASH_START: 
            case DOLLAR_START: {
                if (curChar == '{') {
                    ELBufferScanner.recordStartELExpr(i - 1, elstate, elRanges);
                    return ELParseState.EL_OPEN_BRACE;
                }
                return ELParseState.LITERAL_TEXT;
            }
            case EL_OPEN_BRACE: 
            case EL_EXPRESSION_TEXT: {
                if (curChar == '}') {
                    ELBufferScanner.recordEndELExpression(i + 1, elRanges);
                    return ELParseState.EL_CLOSE_BRACE;
                }
                return ELParseState.EL_EXPRESSION_TEXT;
            }
        }
        throw new IllegalStateException("Uncovered state: " + elstate.toString());
    }

    private static void recordEndELExpression(int offset, List<DesignTimeContextData.ELRange> elRanges) {
        DesignTimeContextData.ELRange elRange = elRanges.get(elRanges.size() - 1);
        elRange.setEndOffset(offset);
    }

    private static void recordStartELExpr(int offset, ELParseState elstate, List<DesignTimeContextData.ELRange> elRanges) {
        elRanges.add(new DesignTimeContextData.ELRange(elstate == ELParseState.HASH_START, offset));
    }

    public static enum ELParseState {
        START,
        LITERAL_TEXT,
        HASH_START,
        DOLLAR_START,
        EL_OPEN_BRACE,
        EL_CLOSE_BRACE,
        EL_EXPRESSION_TEXT,
        BACK_SLASH;

    }
}

