/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.jsf.facelet.dtcompiler;

import java.util.ArrayList;
import java.util.List;
import javax.faces.view.Location;
import oracle.eclipse.tools.webtier.jsf.facelet.dtcompiler.cu.DTNamespaceUnit;
import org.apache.myfaces.view.facelets.tag.TagLibrary;

final class DTNamespaceManager {
    private final List<NS> namespaces = new ArrayList<NS>();

    public void reset() {
        this.namespaces.clear();
    }

    public void pushNamespace(Location location, String prefix, String namespace) {
        NS ns = new NS(location, prefix, namespace);
        this.namespaces.add(0, ns);
    }

    public String getNamespace(String prefix) {
        NS ns = null;
        int i = 0;
        while (i < this.namespaces.size()) {
            ns = this.namespaces.get(i);
            if (ns.prefix.equals(prefix)) {
                return ns.namespace;
            }
            ++i;
        }
        return null;
    }

    public void popNamespace(String prefix) {
        NS ns = null;
        int i = 0;
        while (i < this.namespaces.size()) {
            ns = this.namespaces.get(i);
            if (ns.prefix.equals(prefix)) {
                this.namespaces.remove(i);
                return;
            }
            ++i;
        }
    }

    public final DTNamespaceUnit toNamespaceUnit(TagLibrary library) {
        DTNamespaceUnit unit = new DTNamespaceUnit(library);
        if (this.namespaces.size() > 0) {
            NS ns = null;
            int i = this.namespaces.size() - 1;
            while (i >= 0) {
                ns = this.namespaces.get(i);
                unit.setNamespace(ns.prefix, ns.namespace);
                --i;
            }
        }
        return unit;
    }

    private static final class NS {
        public final String prefix;
        public final String namespace;
        private final Location location;

        public NS(Location location, String prefix, String ns) {
            this.prefix = prefix;
            this.namespace = ns;
            this.location = location;
        }

        public String toString() {
            return String.format("namespace usage prefix=%s, namespace=%s, location=%s", this.prefix, this.namespace, this.location);
        }
    }
}

