/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.jsf.facelet.dtcompiler;

import com.ctc.wstx.io.WstxInputData;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import oracle.eclipse.tools.webtier.jsf.facelet.dtcompiler.ELBufferScanner;
import oracle.eclipse.tools.webtier.jsf.facelet.dtcompiler.OffsetRecordingBufferedReader;
import oracle.eclipse.tools.webtier.jsf.facelet.dtcontext.DesignTimeContextData;
import oracle.eclipse.tools.webtier.jsf.facelet.dtcontext.LocationBasedXMLTextRange;
import oracle.eclipse.tools.webtier.jsf.facelet.dtcontext.TextLocation;
import oracle.eclipse.tools.webtier.jsf.facelet.dtcontext.XMLTextRange;

public class BufferReparser {
    private int elementStartOffset;
    private int elementOpenTagEndOffset;
    private boolean tagHasNoBody;
    private List<DesignTimeContextData.ELRange> elRanges;
    private Map<String, ExtendedAttributeInfo> attributeOffsets;
    private boolean init;

    public boolean isInit() {
        return this.init;
    }

    public ParsedEntity reparse(OffsetRecordingBufferedReader bfr, XMLTextRange range, String prefix, QName elemName, boolean isXml11, int numAttrs) {
        if (prefix == null && elemName == null || numAttrs < 0) {
            this.init = true;
            return null;
        }
        int offsetIntoBuffer = range.getStartOffset();
        int length = range.getLength();
        if (offsetIntoBuffer < 0 || offsetIntoBuffer + length < offsetIntoBuffer) {
            throw new AssertionError();
        }
        boolean seenElementStart = false;
        this.elRanges = new ArrayList<DesignTimeContextData.ELRange>();
        ParsedEntity startEntity = new ParsedEntity();
        startEntity.startOffset = -1;
        startEntity.endOffset = 0;
        startEntity.type = ParseState.START;
        ParsedEntity curEntity = startEntity;
        ParseState state = ParseState.START;
        ParseState openQuoteState = null;
        ELBufferScanner.ELParseState elstate = ELBufferScanner.ELParseState.START;
        int i = offsetIntoBuffer;
        while (i < offsetIntoBuffer + length) {
            char curChar = bfr.getByte(i);
            block0 : switch (curChar) {
                case '<': {
                    assert (state == ParseState.START);
                    ParsedEntity nextEntity = new ParsedEntity();
                    int n = i;
                    nextEntity.startOffset = n;
                    curEntity.endOffset = n;
                    nextEntity.type = ParseState.OPEN_ELEMENT;
                    curEntity.next = nextEntity;
                    curEntity = nextEntity;
                    state = ParseState.OPEN_ELEMENT;
                    break;
                }
                case ':': {
                    ParsedEntity nextEntity;
                    if (state == ParseState.PREFIX_START || state == ParseState.ATTRIBUTE_PREFIX_START) {
                        nextEntity = new ParsedEntity();
                        curEntity.endOffset = i;
                        nextEntity.startOffset = i + 1;
                        nextEntity.type = state == ParseState.PREFIX_START ? ParseState.LOCAL_NAME_START : ParseState.ATTRIBUTE_NAME_START;
                        state = state;
                        curEntity.next = nextEntity;
                        curEntity = nextEntity;
                        break;
                    }
                    if (state == ParseState.ATTRIBUTE_OPEN_QUOTE_DOUBLE || state == ParseState.ATTRIBUTE_OPEN_QUOTE_SINGLE || state == ParseState.ATTRIBUTE_VALUE_START) {
                        elstate = ELBufferScanner.handleAttributeValueChar(curChar, i, elstate, this.elRanges);
                        curEntity.endOffset = i;
                        break;
                    }
                    String curAttrName = new String(bfr.getBufferRange(curEntity.startOffset, i));
                    if ("xmlns".equals(curAttrName)) {
                        curEntity.endOffset = i;
                        curEntity.type = ParseState.NS_DECL_START;
                        ParsedEntity nextEntity2 = new ParsedEntity();
                        nextEntity2.startOffset = i + 1;
                        nextEntity2.type = ParseState.NS_DECL_PREFIX_START;
                        curEntity.next = nextEntity2;
                        curEntity = nextEntity2;
                        break;
                    }
                    throw new AssertionError();
                }
                case '\"': 
                case '\'': {
                    ParsedEntity nextEntity;
                    switch (state) {
                        case ATTRIBUTE_EQUALS_START: {
                            nextEntity = new ParsedEntity();
                            nextEntity.startOffset = i;
                            curEntity.endOffset = i;
                            nextEntity.type = curChar == '\"' ? ParseState.ATTRIBUTE_OPEN_QUOTE_DOUBLE : ParseState.ATTRIBUTE_OPEN_QUOTE_SINGLE;
                            state = state;
                            openQuoteState = state;
                            curEntity.next = nextEntity;
                            curEntity = nextEntity;
                            break block0;
                        }
                        case ATTRIBUTE_OPEN_QUOTE_SINGLE: 
                        case ATTRIBUTE_OPEN_QUOTE_DOUBLE: 
                        case ATTRIBUTE_VALUE_START: {
                            if (openQuoteState == ParseState.ATTRIBUTE_OPEN_QUOTE_SINGLE && curChar != '\'' || openQuoteState == ParseState.ATTRIBUTE_OPEN_QUOTE_DOUBLE && curChar != '\"') break block0;
                            if (state == openQuoteState && i - curEntity.startOffset == 1) {
                                ParsedEntity emptyValueEntity = new ParsedEntity();
                                emptyValueEntity.startOffset = i - 1;
                                emptyValueEntity.type = ParseState.ATTRIBUTE_VALUE_START;
                                curEntity.endOffset = i;
                                curEntity.next = emptyValueEntity;
                                curEntity = emptyValueEntity;
                            }
                            nextEntity = new ParsedEntity();
                            nextEntity.startOffset = i;
                            curEntity.endOffset = i;
                            nextEntity.type = state == ParseState.ATTRIBUTE_OPEN_QUOTE_DOUBLE ? ParseState.ATTRIBUTE_CLOSE_QUOTE_DOUBLE : ParseState.ATTRIBUTE_CLOSE_QUOTE_SINGLE;
                            state = state;
                            curEntity.next = nextEntity;
                            curEntity = nextEntity;
                            break block0;
                        }
                        default: {
                            throw new AssertionError();
                        }
                    }
                }
                case '=': {
                    ParsedEntity nextEntity;
                    switch (state) {
                        case ATTRIBUTE_NAME_START: {
                            nextEntity = new ParsedEntity();
                            int n = i;
                            curEntity.endOffset = n;
                            nextEntity.startOffset = n;
                            state = ParseState.ATTRIBUTE_EQUALS_START;
                            nextEntity.type = state;
                            curEntity.next = nextEntity;
                            break block0;
                        }
                        case ATTRIBUTE_VALUE_START: {
                            elstate = ELBufferScanner.handleAttributeValueChar(curChar, i, elstate, this.elRanges);
                            curEntity.endOffset = i;
                            break block0;
                        }
                        case NS_DECL_PREFIX_START: {
                            curEntity.endOffset = i;
                            curEntity.type = ParseState.NS_DECL_START;
                            nextEntity = new ParsedEntity();
                            nextEntity.startOffset = i + 1;
                            nextEntity.type = ParseState.ATTRIBUTE_EQUALS_START;
                            curEntity.next = nextEntity;
                            curEntity = nextEntity;
                            break block0;
                        }
                        case WHITESPACE: {
                            nextEntity = new ParsedEntity();
                            int n = i;
                            curEntity.endOffset = n;
                            nextEntity.startOffset = n;
                            state = ParseState.ATTRIBUTE_EQUALS_START;
                            nextEntity.type = state;
                            curEntity.next = nextEntity;
                            break block0;
                        }
                    }
                    throw new AssertionError();
                }
                case '/': {
                    ParsedEntity nextEntity;
                    if (state == ParseState.OPEN_ELEMENT) {
                        this.init = true;
                        return null;
                    }
                    if (state != ParseState.ATTRIBUTE_VALUE_START && state != ParseState.ATTRIBUTE_OPEN_QUOTE_DOUBLE && state != ParseState.ATTRIBUTE_CLOSE_QUOTE_SINGLE) {
                        nextEntity = new ParsedEntity();
                        int n = i;
                        curEntity.endOffset = n;
                        nextEntity.startOffset = n;
                        state = ParseState.CLOSE_ELEMENT_NO_BODY;
                        nextEntity.type = state;
                        curEntity.next = nextEntity;
                        break;
                    }
                    elstate = ELBufferScanner.handleAttributeValueChar(curChar, i, elstate, this.elRanges);
                    curEntity.endOffset = i;
                    break;
                }
                case '>': {
                    ParsedEntity nextEntity;
                    if (state == ParseState.ATTRIBUTE_VALUE_START) {
                        elstate = ELBufferScanner.handleAttributeValueChar(curChar, i, elstate, this.elRanges);
                        curEntity.endOffset = i;
                        break;
                    }
                    if (state != ParseState.CLOSE_ELEMENT_NO_BODY) {
                        nextEntity = new ParsedEntity();
                        int n = i;
                        curEntity.endOffset = n;
                        nextEntity.startOffset = n;
                        state = ParseState.CLOSE_ELEMENT;
                        nextEntity.type = state;
                        curEntity.next = nextEntity;
                        break;
                    }
                    curEntity.endOffset = i;
                    break;
                }
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    ParsedEntity nextEntity;
                    switch (state) {
                        case LOCAL_NAME_START: {
                            seenElementStart = true;
                        }
                        case PREFIX_START: 
                        case ATTRIBUTE_PREFIX_START: 
                        case ATTRIBUTE_NAME_START: 
                        case ATTRIBUTE_CLOSE_QUOTE_SINGLE: 
                        case ATTRIBUTE_CLOSE_QUOTE_DOUBLE: {
                            nextEntity = new ParsedEntity();
                            int n = i;
                            curEntity.endOffset = n;
                            nextEntity.startOffset = n;
                            nextEntity.type = ParseState.WHITESPACE;
                            curEntity.next = nextEntity;
                            curEntity = nextEntity;
                        }
                    }
                    break;
                }
                default: {
                    ParsedEntity nextEntity;
                    switch (state) {
                        case ATTRIBUTE_OPEN_QUOTE_SINGLE: 
                        case ATTRIBUTE_OPEN_QUOTE_DOUBLE: {
                            nextEntity = new ParsedEntity();
                            nextEntity.startOffset = i;
                            curEntity.endOffset = i;
                            nextEntity.type = ParseState.ATTRIBUTE_VALUE_START;
                            curEntity.next = nextEntity;
                            elstate = ELBufferScanner.ELParseState.START;
                            elstate = ELBufferScanner.handleAttributeValueChar(curChar, i, elstate, this.elRanges);
                            break block0;
                        }
                        case ATTRIBUTE_VALUE_START: {
                            elstate = ELBufferScanner.handleAttributeValueChar(curChar, i, elstate, this.elRanges);
                            curEntity.endOffset = i;
                            break block0;
                        }
                        case OPEN_ELEMENT: {
                            if (WstxInputData.isNameStartChar((char)curChar, (boolean)true, (boolean)isXml11)) {
                                nextEntity = new ParsedEntity();
                                nextEntity.startOffset = i;
                                if (prefix == null || prefix.isEmpty()) {
                                    nextEntity.type = ParseState.LOCAL_NAME_START;
                                } else {
                                    nextEntity.type = ParseState.PREFIX_START;
                                }
                                curEntity.next = nextEntity;
                                curEntity.endOffset = i;
                                curEntity = nextEntity;
                                break block0;
                            }
                            WstxInputData.isNameStartChar((char)curChar, (boolean)true, (boolean)isXml11);
                            throw new AssertionError();
                        }
                        case PREFIX_START: 
                        case LOCAL_NAME_START: 
                        case ATTRIBUTE_NAME_START: 
                        case NS_DECL_PREFIX_START: {
                            if (!WstxInputData.isNameChar((char)curChar, (boolean)true, (boolean)isXml11)) {
                                throw new AssertionError();
                            }
                            break block0;
                        }
                        case WHITESPACE: {
                            if (WstxInputData.isNameStartChar((char)curChar, (boolean)true, (boolean)isXml11)) {
                                nextEntity = new ParsedEntity();
                                nextEntity.startOffset = i;
                                curEntity.endOffset = i;
                                curEntity.next = nextEntity;
                                if (seenElementStart) {
                                    nextEntity.type = ParseState.ATTRIBUTE_NAME_START;
                                } else {
                                    nextEntity.type = prefix == null || prefix.isEmpty() ? ParseState.LOCAL_NAME_START : ParseState.PREFIX_START;
                                    state = state;
                                }
                                curEntity = nextEntity;
                                break block0;
                            }
                            throw new AssertionError();
                        }
                        default: {
                            throw new UnsupportedOperationException();
                        }
                    }
                }
            }
            ++i;
        }
        curEntity.endOffset = offsetIntoBuffer + length;
        curEntity = startEntity;
        if (numAttrs < 0) {
            System.out.println();
        }
        this.attributeOffsets = new HashMap<String, ExtendedAttributeInfo>(numAttrs);
        String curName = null;
        int curELRange = 0;
        while (curEntity != null) {
            ExtendedAttributeInfo extendedAttributeInfo;
            if (curEntity.type == ParseState.ATTRIBUTE_NAME_START) {
                curName = new String(bfr.getBufferRange(curEntity.startOffset, curEntity.endOffset));
                extendedAttributeInfo = this.getOrCreateExtendedAttributeInfo(curName);
                extendedAttributeInfo.setNameRange(this.createXMLTextRange(curEntity));
            } else if (curEntity.type == ParseState.ATTRIBUTE_VALUE_START) {
                extendedAttributeInfo = this.getOrCreateExtendedAttributeInfo(curName);
                extendedAttributeInfo.setValueRange(this.createXMLTextRange(curEntity));
                while (curELRange < this.elRanges.size() && this.elRanges.get(curELRange).getStartOffset() >= curEntity.startOffset && this.elRanges.get(curELRange).getEndOffset() <= curEntity.endOffset) {
                    DesignTimeContextData.ELRange elRange = this.elRanges.get(curELRange);
                    elRange.setELText(new String(bfr.getBufferRange(elRange.getStartOffset(), elRange.getEndOffset())));
                    elRange.setStartOffset(elRange.getStartOffset());
                    elRange.setEndOffset(elRange.getEndOffset());
                    extendedAttributeInfo.addELRange(elRange);
                    ++curELRange;
                }
            } else if (curEntity.type == ParseState.OPEN_ELEMENT) {
                this.elementStartOffset = curEntity.startOffset;
            } else if (curEntity.type == ParseState.CLOSE_ELEMENT_NO_BODY) {
                this.elementOpenTagEndOffset = curEntity.endOffset;
                this.tagHasNoBody = true;
            } else if (curEntity.type == ParseState.CLOSE_ELEMENT) {
                this.elementOpenTagEndOffset = curEntity.endOffset;
                this.tagHasNoBody = false;
            }
            curEntity = curEntity.next;
        }
        this.init = true;
        return startEntity;
    }

    private XMLTextRange createXMLTextRange(ParsedEntity curEntity) {
        TextLocation.TextLocationWorkingCopy valueLocationStart = new TextLocation.TextLocationWorkingCopy();
        valueLocationStart.setAbsOffset(curEntity.startOffset);
        TextLocation.TextLocationWorkingCopy valueLocationEnd = new TextLocation.TextLocationWorkingCopy();
        valueLocationEnd.setAbsOffset(curEntity.endOffset);
        LocationBasedXMLTextRange valueRange = new LocationBasedXMLTextRange(valueLocationStart, valueLocationEnd);
        return valueRange;
    }

    private ExtendedAttributeInfo getOrCreateExtendedAttributeInfo(String curName) {
        ExtendedAttributeInfo extendedAttributeInfo = this.attributeOffsets.get(curName);
        if (extendedAttributeInfo == null) {
            extendedAttributeInfo = new ExtendedAttributeInfo();
            this.attributeOffsets.put(curName, extendedAttributeInfo);
        }
        return extendedAttributeInfo;
    }

    public int getElementStartOffset() {
        return this.elementStartOffset;
    }

    public int getElementOpenTagEndOffset() {
        return this.elementOpenTagEndOffset;
    }

    public boolean isTagHasNoBody() {
        return this.tagHasNoBody;
    }

    public ExtendedAttributeInfo getExtendedAttributeInfo(String attrName) {
        return this.attributeOffsets.get(attrName);
    }

    public static class ExtendedAttributeInfo {
        private XMLTextRange nameRange;
        private XMLTextRange valueRange;
        private List<DesignTimeContextData.ELRange> elRanges;

        protected void addELRange(DesignTimeContextData.ELRange elRange) {
            if (this.elRanges == null) {
                this.elRanges = new ArrayList<DesignTimeContextData.ELRange>(1);
            }
            this.elRanges.add(elRange);
        }

        public List<DesignTimeContextData.ELRange> getELRanges() {
            if (this.elRanges != null) {
                return Collections.unmodifiableList(this.elRanges);
            }
            return Collections.EMPTY_LIST;
        }

        public boolean isLiteral() {
            return this.elRanges.isEmpty();
        }

        public XMLTextRange getNameRange() {
            return this.nameRange;
        }

        protected void setNameRange(XMLTextRange nameRange) {
            this.nameRange = nameRange;
        }

        public XMLTextRange getValueRange() {
            return this.valueRange;
        }

        protected void setValueRange(XMLTextRange valueRange) {
            this.valueRange = valueRange;
        }
    }

    public static enum ParseState {
        START,
        OPEN_ELEMENT,
        PREFIX_START,
        LOCAL_NAME_START,
        ATTRIBUTE_PREFIX_START,
        ATTRIBUTE_NAME_START,
        ATTRIBUTE_EQUALS_START,
        ATTRIBUTE_OPEN_QUOTE_SINGLE,
        ATTRIBUTE_OPEN_QUOTE_DOUBLE,
        ATTRIBUTE_VALUE_START,
        ATTRIBUTE_CLOSE_QUOTE_SINGLE,
        ATTRIBUTE_CLOSE_QUOTE_DOUBLE,
        CLOSE_ELEMENT_NO_BODY,
        CLOSE_ELEMENT,
        WHITESPACE,
        NS_DECL_START,
        NS_DECL_PREFIX_START,
        NS_DECL_URI_START;

    }

    public static class ParsedEntity {
        private int startOffset;
        private int endOffset;
        private ParsedEntity next;
        private ParseState type;
    }
}

