/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.jsf.facelet.cmdline;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.FileHandler;
import java.util.logging.Logger;
import javax.xml.bind.JAXBException;
import oracle.eclipse.tools.webtier.jsf.facelet.DTFaceletCompilerExecutor;
import oracle.eclipse.tools.webtier.jsf.facelet.FaceletCompilerConfigurator;
import oracle.eclipse.tools.webtier.jsf.facelet.URLHandler;
import oracle.eclipse.tools.webtier.jsf.facelet.dtcontext.DesignTimeContext;
import oracle.eclipse.tools.webtier.jsf.facelet.dtcontext.DesignTimeContextData;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.IFileSystem;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.jetty.util.resource.Resource;

public class StandaloneApp
implements IApplication {
    public Object start(IApplicationContext context) throws Exception {
        try {
            Logger.getLogger("").addHandler(new FileHandler("." + System.currentTimeMillis() + ".log"));
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        long startTime = System.currentTimeMillis();
        String[] appArgs = (String[])context.getArguments().get("application.args");
        CommandLine cmdLine = this.getCommandLine(appArgs);
        if (!this.validateCommandLine(cmdLine)) {
            return IApplication.EXIT_OK;
        }
        Config config = new Config();
        if (!this.loadConfig(cmdLine, config)) {
            return IApplication.EXIT_OK;
        }
        if (cmdLine.hasOption('s')) {
            this.simulate(config);
        } else {
            this.compile(config);
            System.out.printf("Total Execution Time: %dms\n", System.currentTimeMillis() - startTime);
        }
        return IApplication.EXIT_OK;
    }

    private void simulate(Config config) {
        System.out.println("Simulating compile on war file: " + config.getWarFile().toURI().toString());
        try {
            Resource rootDir = this.getRootDir(config);
            List<Resource> faceletsToCompile = this.getFaceletsToCompile(rootDir);
            for (Resource facelet : faceletsToCompile) {
                System.out.printf("Compiling: %s\n", facelet.getURI());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
    }

    private void compile(Config config) throws IOException, URISyntaxException {
        Resource rootDir = this.getRootDir(config);
        List<Resource> faceletsToCompile = this.getFaceletsToCompile(rootDir);
        for (Resource facelet : faceletsToCompile) {
            System.out.printf("Compiling: %s\n", facelet.getURI());
            long startTimeMs = System.currentTimeMillis();
            DesignTimeContext dtContext = new DesignTimeContext(facelet.getURL());
            FaceletCompilerConfigurator.DTFaceletCompilerConfig compilerConfig = new FaceletCompilerConfigurator().configure(rootDir.getURL(), facelet.getURL(), dtContext, StandaloneApp.class.getClassLoader(), new MyURLHandler());
            new DTFaceletCompilerExecutor(compilerConfig).execute();
            DesignTimeContextData data = dtContext.getData();
            if (data.hasReportableProblems()) {
                System.out.printf("\tTag Errors: %d, Include Errors %d\n", data.getTagErrors().size(), data.getTagIncludeErrors().size());
            }
            System.out.printf("\tCompilation took %d ms\n", System.currentTimeMillis() - startTimeMs);
            if (config.getOutputDir() == null) continue;
            startTimeMs = System.currentTimeMillis();
            this.printReport(facelet, dtContext);
            System.out.printf("\tReport generated in %d ms\n", System.currentTimeMillis() - startTimeMs);
        }
    }

    private void printReport(Resource facelet, DesignTimeContext dtContext) {
        IFileStore reportStore;
        String reportName;
        IFileStore fromLocalFile = EFS.getLocalFileSystem().fromLocalFile(new File("."));
        IFileStore child = fromLocalFile.getChild("output");
        if (!child.fetchInfo().exists()) {
            try {
                child.mkdir(4, null);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        if ((reportName = this.getReportName(facelet)) != null && (reportStore = child.getChild(reportName)) != null) {
            try {
                dtContext.printXmlReport(reportStore.openOutputStream(0, null));
            }
            catch (JAXBException e) {
                e.printStackTrace();
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
    }

    private String getReportName(Resource facelet) {
        int indexOfDot;
        int indexOfLastSep;
        String name = facelet.getName();
        if (name != null && (indexOfLastSep = name.lastIndexOf(47)) > -1 && (indexOfDot = (name = name.substring(indexOfLastSep + 1)).indexOf(46)) > -1) {
            name = name.substring(0, indexOfDot);
            name = String.valueOf(name) + ".rpt";
            return name;
        }
        return null;
    }

    private Resource getRootDir(Config config) throws IOException, URISyntaxException {
        URI warUri = config.getWarFile().toURI();
        if (!warUri.toString().startsWith("jar:")) {
            warUri = new URI("jar:" + warUri.toString() + "!/");
        }
        return Resource.newResource((URI)warUri);
    }

    private List<Resource> getFaceletsToCompile(Resource rootDir) {
        ArrayList<Resource> resources = new ArrayList<Resource>();
        try {
            this.traverseSubDir(resources, rootDir);
        }
        catch (MalformedURLException e) {
            e.printStackTrace(System.err);
        }
        catch (IOException e) {
            e.printStackTrace(System.err);
        }
        return resources.isEmpty() ? Collections.EMPTY_LIST : resources;
    }

    private void traverseSubDir(List<Resource> resources, Resource dir) throws MalformedURLException, IOException {
        String[] stringArray = dir.list();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String elem = stringArray[n2];
            if (elem.endsWith("html") || elem.endsWith("xml")) {
                resources.add(dir.addPath(elem));
            } else if (elem.endsWith("/") && !elem.endsWith("WEB-INF/")) {
                this.traverseSubDir(resources, dir.addPath(elem));
            }
            ++n2;
        }
    }

    private boolean loadConfig(CommandLine cmdLine, Config config) {
        String optionValue;
        String warFileName;
        File file;
        IFileSystem fs = EFS.getLocalFileSystem();
        IFileStore warFile = fs.fromLocalFile(file = new File(warFileName = cmdLine.getOptionValue("w")));
        if (!warFile.fetchInfo().exists()) {
            System.out.printf("Warfile %s doesn't exist\n", warFileName);
            return false;
        }
        if (warFile.fetchInfo().isDirectory()) {
            System.out.printf("Warfile %s is a directory\n", file.getAbsoluteFile());
            return false;
        }
        config.setWarFile(warFile);
        if (cmdLine.hasOption('o') && (optionValue = cmdLine.getOptionValue('o', "output")) != null) {
            config.setOutputDir(optionValue);
        }
        return true;
    }

    private boolean validateCommandLine(CommandLine cmdLine) {
        if (!cmdLine.hasOption("w")) {
            System.out.println("Error Warfile option required: [-w | --warFile] warFileName");
            return false;
        }
        return true;
    }

    private CommandLine getCommandLine(String[] appArgs) throws ParseException {
        BasicParser cmdParser = new BasicParser();
        Options options = new Options();
        options.addOption("w", "warFile", true, "The war file to compile");
        options.getOption("w").setRequired(true);
        options.addOption("s", "simulate", false, "Simulates what the compiler would do without executing.  No output will generated except logging to stdout");
        options.addOption("o", "output", true, "Output results for each facelet processed");
        CommandLine cmdLine = cmdParser.parse(options, appArgs, true);
        return cmdLine;
    }

    public void stop() {
    }

    private static class Config {
        private IFileStore warFile;
        private String outputDir;

        private Config() {
        }

        public void setWarFile(IFileStore warFile) {
            this.warFile = warFile;
        }

        public void setOutputDir(String outputDir) {
            this.outputDir = outputDir;
        }

        public String getOutputDir() {
            return this.outputDir;
        }

        public IFileStore getWarFile() {
            return this.warFile;
        }
    }

    private static class MyURLHandler
    extends URLHandler {
        private MyURLHandler() {
        }

        @Override
        public URL getRelative(URL baseDir, String relativeObject) throws MalformedURLException {
            if (relativeObject.startsWith("/")) {
                relativeObject = relativeObject.substring(1);
            }
            try {
                Resource baseDirRes = Resource.newResource((URL)baseDir);
                Resource pathRes = baseDirRes.addPath(relativeObject);
                return pathRes.getURL();
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        }

        @Override
        protected Set<String> handle(URL baseDir, String relativeObject) throws URISyntaxException, IOException {
            if (baseDir.getProtocol().startsWith("jar")) {
                Resource baseDirRes = Resource.newResource((URL)baseDir);
                Resource pathRes = baseDirRes.addPath(relativeObject);
                String[] list = pathRes.list();
                if (list != null) {
                    int i = 0;
                    while (i < list.length) {
                        if (!list[i].startsWith("/") && !relativeObject.endsWith("/")) {
                            list[i] = "/" + list[i];
                        }
                        list[i] = "/" + relativeObject + list[i];
                        ++i;
                    }
                    return new HashSet<String>(Arrays.asList(list));
                }
                return Collections.emptySet();
            }
            return super.handle(baseDir, relativeObject);
        }
    }
}

