/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.jsf.facelet.cmdline;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;

class JarInJarUrlConnection
extends URLConnection {
    private String pathIntoNested;
    private InputStream nestedJarInputStream;

    public JarInJarUrlConnection(URL urlIntoRootJar, String pathIntoNested) {
        super(urlIntoRootJar);
        this.pathIntoNested = pathIntoNested;
    }

    @Override
    public void connect() throws IOException {
        URLConnection jarConnection = this.url.openConnection();
        jarConnection.connect();
        InputStream inputStream = null;
        try {
            inputStream = jarConnection.getInputStream();
            BufferedInputStream ios = new BufferedInputStream(inputStream);
            JarInputStream jarStream = new JarInputStream(ios);
            String entryNameInNested = this.pathIntoNested;
            if (entryNameInNested.startsWith("/")) {
                entryNameInNested = entryNameInNested.substring(1);
            }
            JarEntry nextJarEntry = jarStream.getNextJarEntry();
            while (nextJarEntry != null) {
                if (nextJarEntry.getName().equals(entryNameInNested)) {
                    this.nestedJarInputStream = this.readEntry(jarStream, nextJarEntry);
                    break;
                }
                nextJarEntry = jarStream.getNextJarEntry();
            }
            if (this.nestedJarInputStream == null) {
                throw new FileNotFoundException();
            }
        }
        catch (IOException ioe) {
            this.closeStreamIfOpen(inputStream);
            throw ioe;
        }
        catch (RuntimeException e) {
            this.closeStreamIfOpen(inputStream);
            throw e;
        }
    }

    private InputStream readEntry(JarInputStream jarStream, JarEntry nextJarEntry) throws IOException {
        int numRead;
        int size = (int)nextJarEntry.getSize();
        int bufPos = 0;
        byte[] buffer = new byte[size];
        while (size > 0 && (numRead = jarStream.read(buffer, bufPos, size)) > -1) {
            size -= numRead;
            bufPos += numRead;
        }
        return new ByteArrayInputStream(buffer);
    }

    private void closeStreamIfOpen(InputStream inputStream) throws IOException {
        if (inputStream != null) {
            inputStream.close();
        }
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.nestedJarInputStream;
    }
}

