/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.jsf.facelet;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.logging.FileHandler;
import java.util.logging.Logger;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import oracle.eclipse.tools.webtier.jsf.facelet.DTFaceletCompilerExecutor;
import oracle.eclipse.tools.webtier.jsf.facelet.FaceletCompilerConfigurator;
import oracle.eclipse.tools.webtier.jsf.facelet.URLHandler;
import oracle.eclipse.tools.webtier.jsf.facelet.dtcontext.DesignTimeContext;

public class FaceletCompileDriver {
    static Logger log = Logger.getLogger(FaceletCompileDriver.class.getName());

    public static void main(String[] args) throws Exception {
        try {
            Logger.getLogger("").addHandler(new FileHandler("./logs/compile" + System.currentTimeMillis() + ".log"));
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        File rootDir = new File("./simple-facelet");
        File targetFile = new File("./simple-facelet/test1.xhtml");
        DesignTimeContext dtContext = new DesignTimeContext(targetFile.toURL());
        FaceletCompilerConfigurator.DTFaceletCompilerConfig config = new FaceletCompilerConfigurator().configure(rootDir.toURL(), targetFile.toURL(), dtContext, FaceletCompileDriver.class.getClassLoader(), new URLHandler());
        new DTFaceletCompilerExecutor(config).execute();
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        DesignTimeContext.getCurrentInstance().printXmlReport(os);
        ByteArrayInputStream is = new ByteArrayInputStream(os.toByteArray());
        TransformerFactory newInstance = TransformerFactory.newInstance();
        Transformer newTransformer = newInstance.newTransformer(new StreamSource(DesignTimeContext.class.getResourceAsStream("report1.xslt")));
        newTransformer.transform(new StreamSource(is), new StreamResult(System.out));
    }
}

