/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.jsf.facelet;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.application.Application;
import javax.faces.application.ApplicationFactory;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import oracle.eclipse.tools.webtier.jsf.facelet.DTApplicationImpl;

public class DTApplicationFactoryImpl
extends ApplicationFactory {
    private static final Logger log = Logger.getLogger(DTApplicationFactoryImpl.class.getName());
    private Application _application;
    private boolean _myfacesInstanceAddedToApplicationMap = false;

    public DTApplicationFactoryImpl() {
        this.createAndLogNewApplication();
    }

    private void createAndLogNewApplication() {
        this._application = new DTApplicationImpl();
        this.putApplicationOnMap();
        if (log.isLoggable(Level.FINEST)) {
            log.finest("New ApplicationFactory instance created");
        }
    }

    public void purgeApplication() {
        this.createAndLogNewApplication();
    }

    @Override
    public Application getApplication() {
        if (this._application != null && !this._myfacesInstanceAddedToApplicationMap) {
            this.putApplicationOnMap();
        }
        return this._application;
    }

    @Override
    public void setApplication(Application application) {
        if (application == null) {
            throw new NullPointerException("Cannot set a null application in the ApplicationFactory");
        }
        this._application = application;
        this.putApplicationOnMap();
    }

    private void putApplicationOnMap() {
        ExternalContext externalContext;
        FacesContext facesContext = FacesContext.getCurrentInstance();
        if (facesContext != null && (externalContext = facesContext.getExternalContext()) != null) {
            externalContext.getApplicationMap().put("org.apache.myfaces.application.ApplicationImpl", this._application);
            this._myfacesInstanceAddedToApplicationMap = true;
        }
    }
}

