/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.webapp;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.FacesException;
import javax.faces.FactoryFinder;
import javax.faces.application.ResourceHandler;
import javax.faces.context.FacesContext;
import javax.faces.context.FacesContextFactory;
import javax.faces.lifecycle.Lifecycle;
import javax.faces.lifecycle.LifecycleFactory;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public final class FacesServlet
implements Servlet {
    private static final Logger log = Logger.getLogger(FacesServlet.class.getName());
    public static final String CONFIG_FILES_ATTR = "javax.faces.CONFIG_FILES";
    public static final String LIFECYCLE_ID_ATTR = "javax.faces.LIFECYCLE_ID";
    private static final String SERVLET_INFO = "FacesServlet of the MyFaces API implementation";
    private ServletConfig _servletConfig;
    private FacesContextFactory _facesContextFactory;
    private Lifecycle _lifecycle;

    @Override
    public void destroy() {
        this._servletConfig = null;
        this._facesContextFactory = null;
        this._lifecycle = null;
        if (log.isLoggable(Level.FINEST)) {
            log.finest("destroy");
        }
    }

    @Override
    public ServletConfig getServletConfig() {
        return this._servletConfig;
    }

    @Override
    public String getServletInfo() {
        return SERVLET_INFO;
    }

    private String getLifecycleId() {
        String serLifecycleId = this._servletConfig.getInitParameter(LIFECYCLE_ID_ATTR);
        String appLifecycleId = this._servletConfig.getServletContext().getInitParameter(LIFECYCLE_ID_ATTR);
        appLifecycleId = serLifecycleId == null ? appLifecycleId : serLifecycleId;
        return appLifecycleId != null ? appLifecycleId : "DEFAULT";
    }

    @Override
    public void init(ServletConfig servletConfig) throws ServletException {
        if (log.isLoggable(Level.FINEST)) {
            log.finest("init begin");
        }
        this._servletConfig = servletConfig;
        this._facesContextFactory = (FacesContextFactory)FactoryFinder.getFactory("javax.faces.context.FacesContextFactory");
        LifecycleFactory lifecycleFactory = (LifecycleFactory)FactoryFinder.getFactory("javax.faces.lifecycle.LifecycleFactory");
        this._lifecycle = lifecycleFactory.getLifecycle(this.getLifecycleId());
        if (log.isLoggable(Level.FINEST)) {
            log.finest("init end");
        }
    }

    @Override
    public void service(ServletRequest request, ServletResponse response) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        String pathInfo = httpRequest.getPathInfo();
        if (pathInfo != null && (pathInfo.startsWith("/WEB-INF") || pathInfo.startsWith("/META-INF"))) {
            StringBuffer buffer = new StringBuffer();
            buffer.append(" Someone is trying to access a secure resource : ").append(pathInfo);
            buffer.append("\n remote address is ").append(httpRequest.getRemoteAddr());
            buffer.append("\n remote host is ").append(httpRequest.getRemoteHost());
            buffer.append("\n remote user is ").append(httpRequest.getRemoteUser());
            buffer.append("\n request URI is ").append(httpRequest.getRequestURI());
            log.warning(buffer.toString());
            ((HttpServletResponse)response).sendError(404);
            return;
        }
        if (log.isLoggable(Level.FINEST)) {
            log.finest("service begin");
        }
        FacesContext facesContext = this.prepareFacesContext(request, response);
        try {
            try {
                ResourceHandler resourceHandler = facesContext.getApplication().getResourceHandler();
                if (resourceHandler.isResourceRequest(facesContext)) {
                    resourceHandler.handleResourceRequest(facesContext);
                } else {
                    this._lifecycle.execute(facesContext);
                    this._lifecycle.render(facesContext);
                }
            }
            catch (FacesException e) {
                Throwable cause = e.getCause();
                if (cause == null) {
                    throw new ServletException(e.getLocalizedMessage(), e);
                }
                if (cause instanceof ServletException) {
                    throw (ServletException)cause;
                }
                if (cause instanceof IOException) {
                    throw (IOException)cause;
                }
                throw new ServletException(cause.getLocalizedMessage(), cause);
            }
        }
        finally {
            facesContext.release();
        }
        if (log.isLoggable(Level.FINEST)) {
            log.finest("service end");
        }
    }

    private FacesContext prepareFacesContext(ServletRequest request, ServletResponse response) {
        FacesContext facesContext = this._facesContextFactory.getFacesContext(this._servletConfig.getServletContext(), request, response, this._lifecycle);
        return facesContext;
    }
}

