/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.model;

import javax.faces.model.DataModel;
import javax.faces.model.DataModelEvent;
import javax.faces.model.DataModelListener;

public class ScalarDataModel<E>
extends DataModel<E> {
    private int _rowIndex = -1;
    private E _data;

    public ScalarDataModel() {
    }

    public ScalarDataModel(E scalar) {
        this.setWrappedData(scalar);
    }

    @Override
    public int getRowCount() {
        return this._data != null ? 1 : -1;
    }

    @Override
    public E getRowData() {
        if (this._data == null) {
            return null;
        }
        if (!this.isRowAvailable()) {
            throw new IllegalArgumentException("row is unavailable");
        }
        return this._data;
    }

    @Override
    public int getRowIndex() {
        return this._rowIndex;
    }

    @Override
    public Object getWrappedData() {
        return this._data;
    }

    @Override
    public boolean isRowAvailable() {
        return this._data != null && this._rowIndex == 0;
    }

    @Override
    public void setRowIndex(int rowIndex) {
        if (rowIndex < -1) {
            throw new IllegalArgumentException("illegal rowIndex " + rowIndex);
        }
        int oldRowIndex = this._rowIndex;
        this._rowIndex = rowIndex;
        if (this._data != null && oldRowIndex != this._rowIndex) {
            Object data = this.isRowAvailable() ? this.getRowData() : null;
            DataModelEvent event = new DataModelEvent(this, this._rowIndex, data);
            DataModelListener[] listeners = this.getDataModelListeners();
            int i = 0;
            while (i < listeners.length) {
                listeners[i].rowSelected(event);
                ++i;
            }
        }
    }

    @Override
    public void setWrappedData(Object data) {
        if (data == null) {
            this.setRowIndex(-1);
            this._data = null;
        } else {
            this._data = data;
            this._rowIndex = -1;
            this.setRowIndex(0);
        }
    }
}

