/*
 * Decompiled with CFR 0.152.
 */
package javax.faces;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.faces.FacesException;
import javax.faces._FactoryFinderProviderFactory;
import javax.faces.application.ApplicationFactory;
import javax.faces.component.visit.VisitContextFactory;
import javax.faces.context.ExceptionHandlerFactory;
import javax.faces.context.ExternalContextFactory;
import javax.faces.context.FacesContextFactory;
import javax.faces.context.PartialViewContextFactory;
import javax.faces.lifecycle.LifecycleFactory;
import javax.faces.render.RenderKitFactory;
import javax.faces.view.ViewDeclarationLanguageFactory;
import javax.faces.view.facelets.FaceletCacheFactory;
import javax.faces.view.facelets.TagHandlerDelegateFactory;

public final class FactoryFinder {
    public static final String APPLICATION_FACTORY = "javax.faces.application.ApplicationFactory";
    public static final String EXCEPTION_HANDLER_FACTORY = "javax.faces.context.ExceptionHandlerFactory";
    public static final String EXTERNAL_CONTEXT_FACTORY = "javax.faces.context.ExternalContextFactory";
    public static final String FACES_CONTEXT_FACTORY = "javax.faces.context.FacesContextFactory";
    public static final String LIFECYCLE_FACTORY = "javax.faces.lifecycle.LifecycleFactory";
    public static final String PARTIAL_VIEW_CONTEXT_FACTORY = "javax.faces.context.PartialViewContextFactory";
    public static final String RENDER_KIT_FACTORY = "javax.faces.render.RenderKitFactory";
    public static final String TAG_HANDLER_DELEGATE_FACTORY = "javax.faces.view.facelets.TagHandlerDelegateFactory";
    public static final String VIEW_DECLARATION_LANGUAGE_FACTORY = "javax.faces.view.ViewDeclarationLanguageFactory";
    public static final String VISIT_CONTEXT_FACTORY = "javax.faces.component.visit.VisitContextFactory";
    public static final String FACELET_CACHE_FACTORY = "javax.faces.view.facelets.FaceletCacheFactory";
    private static Map<ClassLoader, Map<String, List<String>>> registeredFactoryNames = new HashMap<ClassLoader, Map<String, List<String>>>();
    private static Map<ClassLoader, Map<String, Object>> factories = new HashMap<ClassLoader, Map<String, Object>>();
    private static final Set<String> VALID_FACTORY_NAMES = new HashSet<String>();
    private static final Map<String, Class<?>> ABSTRACT_FACTORY_CLASSES = new HashMap();
    private static final ClassLoader MYFACES_CLASSLOADER;
    private static Object factoryFinderProviderFactoryInstance;
    private static volatile boolean initialized;

    static {
        VALID_FACTORY_NAMES.add(APPLICATION_FACTORY);
        VALID_FACTORY_NAMES.add(EXCEPTION_HANDLER_FACTORY);
        VALID_FACTORY_NAMES.add(EXTERNAL_CONTEXT_FACTORY);
        VALID_FACTORY_NAMES.add(FACES_CONTEXT_FACTORY);
        VALID_FACTORY_NAMES.add(LIFECYCLE_FACTORY);
        VALID_FACTORY_NAMES.add(PARTIAL_VIEW_CONTEXT_FACTORY);
        VALID_FACTORY_NAMES.add(RENDER_KIT_FACTORY);
        VALID_FACTORY_NAMES.add(TAG_HANDLER_DELEGATE_FACTORY);
        VALID_FACTORY_NAMES.add(VIEW_DECLARATION_LANGUAGE_FACTORY);
        VALID_FACTORY_NAMES.add(VISIT_CONTEXT_FACTORY);
        VALID_FACTORY_NAMES.add(FACELET_CACHE_FACTORY);
        ABSTRACT_FACTORY_CLASSES.put(APPLICATION_FACTORY, ApplicationFactory.class);
        ABSTRACT_FACTORY_CLASSES.put(EXCEPTION_HANDLER_FACTORY, ExceptionHandlerFactory.class);
        ABSTRACT_FACTORY_CLASSES.put(EXTERNAL_CONTEXT_FACTORY, ExternalContextFactory.class);
        ABSTRACT_FACTORY_CLASSES.put(FACES_CONTEXT_FACTORY, FacesContextFactory.class);
        ABSTRACT_FACTORY_CLASSES.put(LIFECYCLE_FACTORY, LifecycleFactory.class);
        ABSTRACT_FACTORY_CLASSES.put(PARTIAL_VIEW_CONTEXT_FACTORY, PartialViewContextFactory.class);
        ABSTRACT_FACTORY_CLASSES.put(RENDER_KIT_FACTORY, RenderKitFactory.class);
        ABSTRACT_FACTORY_CLASSES.put(TAG_HANDLER_DELEGATE_FACTORY, TagHandlerDelegateFactory.class);
        ABSTRACT_FACTORY_CLASSES.put(VIEW_DECLARATION_LANGUAGE_FACTORY, ViewDeclarationLanguageFactory.class);
        ABSTRACT_FACTORY_CLASSES.put(VISIT_CONTEXT_FACTORY, VisitContextFactory.class);
        ABSTRACT_FACTORY_CLASSES.put(FACELET_CACHE_FACTORY, FaceletCacheFactory.class);
        try {
            ClassLoader classLoader = System.getSecurityManager() != null ? (ClassLoader)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() {
                    return FactoryFinder.class.getClassLoader();
                }
            }) : FactoryFinder.class.getClassLoader();
            if (classLoader == null) {
                throw new FacesException("jsf api class loader cannot be identified", null);
            }
            MYFACES_CLASSLOADER = classLoader;
        }
        catch (Exception e) {
            throw new FacesException("jsf api class loader cannot be identified", e);
        }
        initialized = false;
    }

    private static void initializeFactoryFinderProviderFactory() {
        if (!initialized) {
            factoryFinderProviderFactoryInstance = _FactoryFinderProviderFactory.getInstance();
            initialized = true;
        }
    }

    FactoryFinder() {
    }

    public static Object getFactory(String factoryName) throws FacesException {
        if (factoryName == null) {
            throw new NullPointerException("factoryName may not be null");
        }
        FactoryFinder.initializeFactoryFinderProviderFactory();
        if (factoryFinderProviderFactoryInstance == null) {
            return FactoryFinder._getFactory(factoryName);
        }
        try {
            Object ffp = _FactoryFinderProviderFactory.FACTORY_FINDER_PROVIDER_FACTORY_GET_FACTORY_FINDER_METHOD.invoke(factoryFinderProviderFactoryInstance, null);
            return _FactoryFinderProviderFactory.FACTORY_FINDER_PROVIDER_GET_FACTORY_METHOD.invoke(ffp, factoryName);
        }
        catch (InvocationTargetException e) {
            Throwable targetException = e.getCause();
            if (targetException instanceof NullPointerException) {
                throw (NullPointerException)targetException;
            }
            if (targetException instanceof FacesException) {
                throw (FacesException)targetException;
            }
            if (targetException instanceof IllegalArgumentException) {
                throw (IllegalArgumentException)targetException;
            }
            if (targetException instanceof IllegalStateException) {
                throw (IllegalStateException)targetException;
            }
            if (targetException == null) {
                throw new FacesException(e);
            }
            throw new FacesException(targetException);
        }
        catch (Exception e) {
            throw new FacesException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object _getFactory(String factoryName) throws FacesException {
        List<String> classNames;
        Object factory;
        ClassLoader classLoader = FactoryFinder.getClassLoader();
        Map<String, List<String>> factoryClassNames = null;
        Map<String, Object> factoryMap = null;
        Map<ClassLoader, Map<String, List<String>>> map = registeredFactoryNames;
        synchronized (map) {
            factoryClassNames = registeredFactoryNames.get(classLoader);
            if (factoryClassNames == null) {
                String message = "No Factories configured for this Application. This happens if the faces-initialization does not work at all - make sure that you properly include all configuration settings necessary for a basic faces application and that all the necessary libs are included. Also check the logging output of your web application and your container for any exceptions!\nIf you did that and find nothing, the mistake might be due to the fact that you use some special web-containers which do not support registering context-listeners via TLD files and a context listener is not setup in your web.xml.\nA typical config looks like this;\n<listener>\n  <listener-class>org.apache.myfaces.webapp.StartupServletContextListener</listener-class>\n</listener>\n";
                throw new IllegalStateException(message);
            }
            if (!factoryClassNames.containsKey(factoryName)) {
                throw new IllegalArgumentException("no factory " + factoryName + " configured for this application.");
            }
            factoryMap = factories.get(classLoader);
            if (factoryMap == null) {
                factoryMap = new HashMap<String, Object>();
                factories.put(classLoader, factoryMap);
            }
        }
        Map<String, List<String>> map2 = factoryClassNames;
        synchronized (map2) {
            factory = factoryMap.get(factoryName);
            if (factory != null) {
                return factory;
            }
            classNames = factoryClassNames.get(factoryName);
        }
        factory = FactoryFinder.newFactoryInstance(ABSTRACT_FACTORY_CLASSES.get(factoryName), classNames.iterator(), classLoader);
        map2 = factoryClassNames;
        synchronized (map2) {
            if (factoryMap.get(factoryName) == null) {
                factoryMap.put(factoryName, factory);
            }
        }
        return factory;
    }

    private static Object newFactoryInstance(Class<?> interfaceClass, Iterator<String> classNamesIterator, ClassLoader classLoader) {
        try {
            Object current = null;
            while (classNamesIterator.hasNext()) {
                String implClassName = classNamesIterator.next();
                Class<?> implClass = null;
                try {
                    implClass = classLoader.loadClass(implClassName);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    implClass = MYFACES_CLASSLOADER.loadClass(implClassName);
                }
                if (!interfaceClass.isAssignableFrom(implClass)) {
                    throw new IllegalArgumentException("Class " + implClassName + " is no " + interfaceClass.getName());
                }
                if (current == null) {
                    current = implClass.newInstance();
                    continue;
                }
                try {
                    Constructor<?> delegationConstructor = implClass.getConstructor(interfaceClass);
                    try {
                        current = delegationConstructor.newInstance(current);
                    }
                    catch (InstantiationException e) {
                        throw new FacesException(e);
                    }
                    catch (IllegalAccessException e) {
                        throw new FacesException(e);
                    }
                    catch (InvocationTargetException e) {
                        throw new FacesException(e);
                    }
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    current = implClass.newInstance();
                }
            }
            return current;
        }
        catch (ClassNotFoundException e) {
            throw new FacesException(e);
        }
        catch (InstantiationException e) {
            throw new FacesException(e);
        }
        catch (IllegalAccessException e) {
            throw new FacesException(e);
        }
    }

    public static void setFactory(String factoryName, String implName) {
        if (factoryName == null) {
            throw new NullPointerException("factoryName may not be null");
        }
        FactoryFinder.initializeFactoryFinderProviderFactory();
        if (factoryFinderProviderFactoryInstance == null) {
            FactoryFinder._setFactory(factoryName, implName);
        } else {
            try {
                Object ffp = _FactoryFinderProviderFactory.FACTORY_FINDER_PROVIDER_FACTORY_GET_FACTORY_FINDER_METHOD.invoke(factoryFinderProviderFactoryInstance, null);
                _FactoryFinderProviderFactory.FACTORY_FINDER_PROVIDER_SET_FACTORY_METHOD.invoke(ffp, factoryName, implName);
            }
            catch (InvocationTargetException e) {
                Throwable targetException = e.getCause();
                if (targetException instanceof NullPointerException) {
                    throw (NullPointerException)targetException;
                }
                if (targetException instanceof FacesException) {
                    throw (FacesException)targetException;
                }
                if (targetException instanceof IllegalArgumentException) {
                    throw (IllegalArgumentException)targetException;
                }
                if (targetException == null) {
                    throw new FacesException(e);
                }
                throw new FacesException(targetException);
            }
            catch (Exception e) {
                throw new FacesException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void _setFactory(String factoryName, String implName) {
        FactoryFinder.checkFactoryName(factoryName);
        ClassLoader classLoader = FactoryFinder.getClassLoader();
        Map<String, List<String>> factoryClassNames = null;
        Map<Object, Object> map = registeredFactoryNames;
        synchronized (map) {
            Map<String, Object> factories = FactoryFinder.factories.get(classLoader);
            if (factories != null && factories.containsKey(factoryName)) {
                return;
            }
            factoryClassNames = registeredFactoryNames.get(classLoader);
            if (factoryClassNames == null) {
                factoryClassNames = new HashMap<String, List<String>>();
                registeredFactoryNames.put(classLoader, factoryClassNames);
            }
        }
        map = factoryClassNames;
        synchronized (map) {
            List<String> classNameList = factoryClassNames.get(factoryName);
            if (classNameList == null) {
                classNameList = new ArrayList<String>();
                factoryClassNames.put(factoryName, classNameList);
            }
            classNameList.add(implName);
        }
    }

    public static void releaseFactories() throws FacesException {
        FactoryFinder.initializeFactoryFinderProviderFactory();
        if (factoryFinderProviderFactoryInstance == null) {
            FactoryFinder._releaseFactories();
        } else {
            try {
                Object ffp = _FactoryFinderProviderFactory.FACTORY_FINDER_PROVIDER_FACTORY_GET_FACTORY_FINDER_METHOD.invoke(factoryFinderProviderFactoryInstance, null);
                _FactoryFinderProviderFactory.FACTORY_FINDER_PROVIDER_RELEASE_FACTORIES_METHOD.invoke(ffp, null);
            }
            catch (InvocationTargetException e) {
                Throwable targetException = e.getCause();
                if (targetException instanceof FacesException) {
                    throw (FacesException)targetException;
                }
                if (targetException == null) {
                    throw new FacesException(e);
                }
                throw new FacesException(targetException);
            }
            catch (Exception e) {
                throw new FacesException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void _releaseFactories() throws FacesException {
        ClassLoader classLoader = FactoryFinder.getClassLoader();
        Map<ClassLoader, Map<String, List<String>>> map = registeredFactoryNames;
        synchronized (map) {
            factories.remove(classLoader);
            Map<String, List<String>> factoryClassNames = registeredFactoryNames.get(classLoader);
            if (factoryClassNames != null) {
                factoryClassNames.clear();
            }
            registeredFactoryNames.remove(classLoader);
        }
    }

    private static void checkFactoryName(String factoryName) {
        if (!VALID_FACTORY_NAMES.contains(factoryName)) {
            throw new IllegalArgumentException("factoryName '" + factoryName + "'");
        }
    }

    private static ClassLoader getClassLoader() {
        try {
            ClassLoader classLoader = null;
            classLoader = System.getSecurityManager() != null ? (ClassLoader)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() {
                    return Thread.currentThread().getContextClassLoader();
                }
            }) : Thread.currentThread().getContextClassLoader();
            if (classLoader == null) {
                throw new FacesException("web application class loader cannot be identified", null);
            }
            return classLoader;
        }
        catch (Exception e) {
            throw new FacesException("web application class loader cannot be identified", e);
        }
    }
}

