/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.shared_core.structure;

import java.util.List;
import org.python.pydev.shared_core.string.FastStringBuffer;
import org.python.pydev.shared_core.structure.LowMemoryArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeNode<T> {
    private T data;
    protected final LowMemoryArrayList<TreeNode<T>> children = new LowMemoryArrayList();
    private Object parent;

    public TreeNode(Object parent, T data) {
        this.parent = parent;
        if (parent instanceof TreeNode) {
            ((TreeNode)parent).addChild(this);
        }
        this.setData(data);
    }

    public List<TreeNode<T>> getChildren() {
        return this.children;
    }

    public T getData() {
        return this.data;
    }

    public void setData(T data) {
        this.data = data;
    }

    private void addChild(TreeNode<T> treeNode) {
        this.children.add(treeNode);
    }

    public Object getParent() {
        return this.parent;
    }

    public boolean hasChildren() {
        return this.children.size() > 0;
    }

    public String toString() {
        FastStringBuffer buf = new FastStringBuffer();
        this.fillBuf(this, buf, 0);
        return buf.toString();
    }

    private void fillBuf(TreeNode<T> treeNode, FastStringBuffer buf, int level) {
        buf.appendN("    ", level).append("TreeNode:").appendObject(treeNode.data).append('\n');
        for (TreeNode<T> child : treeNode.children) {
            this.fillBuf(child, buf, level + 1);
        }
    }
}

