/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.shared_core.structure;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LowMemoryArrayList<E>
implements List<E> {
    private transient E[] data;
    private int size;

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public boolean contains(Object o) {
        return this.indexOf(o) >= 0;
    }

    @Override
    public Iterator<E> iterator() {
        return new Iterator(){
            private int curr;

            public boolean hasNext() {
                if (LowMemoryArrayList.this.data == null) {
                    return false;
                }
                return this.curr < LowMemoryArrayList.this.size;
            }

            public Object next() {
                Object e = LowMemoryArrayList.this.data[this.curr];
                ++this.curr;
                return e;
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public Object[] toArray() {
        Object[] result = new Object[this.size];
        if (this.data != null) {
            System.arraycopy(this.data, 0, result, 0, this.size);
        }
        return result;
    }

    public E[] internalArray() {
        return this.data;
    }

    @Override
    public <T> T[] toArray(T[] a) {
        if (a.length < this.size) {
            a = (Object[])Array.newInstance(a.getClass().getComponentType(), this.size);
        }
        if (this.data != null) {
            System.arraycopy(this.data, 0, a, 0, this.size);
        }
        if (a.length > this.size) {
            a[this.size] = null;
        }
        return a;
    }

    public void sortAndTrim(Comparator<? super E> comparator) {
        this.trim();
        if (this.size > 1) {
            Arrays.sort(this.data, comparator);
        }
    }

    public void trim() {
        int oldCapacity;
        if (this.size == 0) {
            this.data = null;
        } else if (this.size > 0 && this.size < (oldCapacity = this.data.length)) {
            E[] oldData = this.data;
            this.data = new Object[this.size];
            System.arraycopy(oldData, 0, this.data, 0, this.size);
        }
    }

    public void ensureCapacity(int minCapacity) {
        if (this.data == null) {
            if (minCapacity < 3) {
                minCapacity = 3;
            }
            this.data = new Object[minCapacity];
            return;
        }
        int oldCapacity = this.data.length;
        if (minCapacity > oldCapacity) {
            E[] oldData = this.data;
            int newCapacity = oldCapacity * 3 / 2 + 1;
            if (newCapacity < minCapacity) {
                newCapacity = minCapacity;
            }
            this.data = new Object[newCapacity];
            System.arraycopy(oldData, 0, this.data, 0, this.size);
        }
    }

    @Override
    public boolean add(E o) {
        this.ensureCapacity(this.size + 1);
        this.data[this.size++] = o;
        return true;
    }

    @Override
    public boolean remove(Object o) {
        if (this.data == null) {
            return false;
        }
        if (o == null) {
            int index = 0;
            while (index < this.size) {
                if (this.data[index] == null) {
                    this.fastRemove(index);
                    return true;
                }
                ++index;
            }
        } else {
            int index = 0;
            while (index < this.size) {
                if (o.equals(this.data[index])) {
                    this.fastRemove(index);
                    return true;
                }
                ++index;
            }
        }
        return false;
    }

    private void fastRemove(int index) {
        int numMoved = this.size - index - 1;
        if (numMoved > 0) {
            System.arraycopy(this.data, index + 1, this.data, index, numMoved);
        }
        this.data[--this.size] = null;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        throw new RuntimeException("Not implemented");
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        Object[] a = c.toArray();
        int numNew = a.length;
        this.ensureCapacity(this.size + numNew);
        System.arraycopy(a, 0, this.data, this.size, numNew);
        this.size += numNew;
        return numNew != 0;
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        throw new RuntimeException("Not implemented");
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new RuntimeException("Not implemented");
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new RuntimeException("Not implemented");
    }

    @Override
    public void clear() {
        if (this.data == null) {
            return;
        }
        this.data = null;
        this.size = 0;
    }

    private void RangeCheck(int index) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
        }
    }

    @Override
    public E get(int index) {
        this.RangeCheck(index);
        return this.data[index];
    }

    @Override
    public E set(int index, E element) {
        throw new RuntimeException("Not implemented");
    }

    @Override
    public void add(int index, E element) {
        if (index > this.size || index < 0) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
        }
        this.ensureCapacity(this.size + 1);
        System.arraycopy(this.data, index, this.data, index + 1, this.size - index);
        this.data[index] = element;
        ++this.size;
    }

    @Override
    public E remove(int index) {
        this.RangeCheck(index);
        E oldValue = this.data[index];
        int numMoved = this.size - index - 1;
        if (numMoved > 0) {
            System.arraycopy(this.data, index + 1, this.data, index, numMoved);
        }
        this.data[--this.size] = null;
        return oldValue;
    }

    @Override
    public int indexOf(Object elem) {
        if (this.data == null) {
            return -1;
        }
        if (elem == null) {
            int i = 0;
            while (i < this.size) {
                if (this.data[i] == null) {
                    return i;
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.size) {
                if (elem.equals(this.data[i])) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object elem) {
        if (this.data == null) {
            return -1;
        }
        if (elem == null) {
            int i = this.size - 1;
            while (i >= 0) {
                if (this.data[i] == null) {
                    return i;
                }
                --i;
            }
        } else {
            int i = this.size - 1;
            while (i >= 0) {
                if (elem.equals(this.data[i])) {
                    return i;
                }
                --i;
            }
        }
        return -1;
    }

    @Override
    public ListIterator<E> listIterator() {
        throw new RuntimeException("Not implemented");
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        throw new RuntimeException("Not implemented");
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        throw new RuntimeException("Not implemented");
    }
}

