/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.shared_core.partitioner;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitionerExtension2;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.TypedPosition;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.python.pydev.shared_core.log.Log;
import org.python.pydev.shared_core.partitioner.PartitionMerger;
import org.python.pydev.shared_core.utils.ArrayUtils;

public class PartitionCodeReader
implements ICharacterScanner {
    public static final int EOF = -1;
    private boolean fForward = false;
    private IDocument fDocument;
    private int fOffset;
    private int fEnd = -1;
    private final String contentType;
    private int fcurrentPositionI = 0;
    private Position fCurrentPosition = null;
    private Position[] fPositions;
    private char[][] fDelimiters;
    private int fStartForwardOffset;
    private boolean fSupportKeepPositions;

    public PartitionCodeReader(String contentType) {
        this.contentType = contentType;
    }

    public int getOffset() {
        return this.fForward ? this.fOffset - 1 : this.fOffset + 1;
    }

    public void configureForwardReaderKeepingPositions(int offset, int end) throws IOException, BadPositionCategoryException {
        if (!this.fSupportKeepPositions) {
            throw new AssertionError((Object)"configureForwardReader must be called with supportKeepPositions=true.");
        }
        this.fOffset = offset;
        this.fStartForwardOffset = offset;
        this.fForward = true;
        this.fEnd = Math.min(this.fDocument.getLength(), end);
        this.fcurrentPositionI = 0;
        this.fCurrentPosition = this.fPositions.length > 0 ? this.fPositions[0] : null;
    }

    public void configureForwardReader(IDocument document, int offset, int end) throws IOException, BadPositionCategoryException {
        this.configureForwardReader(document, offset, end, false);
    }

    public void configureForwardReader(IDocument document, int offset, int end, boolean supportKeepPositions) throws IOException, BadPositionCategoryException {
        this.fSupportKeepPositions = supportKeepPositions;
        this.fDocument = document;
        this.fOffset = offset;
        this.fStartForwardOffset = offset;
        this.fForward = true;
        this.fEnd = Math.min(this.fDocument.getLength(), end);
        this.fcurrentPositionI = 0;
        this.fPositions = this.createPositions(document);
        this.fCurrentPosition = this.fPositions.length > 0 ? this.fPositions[0] : null;
    }

    public void configureBackwardReader(IDocument document, int offset) throws IOException, BadPositionCategoryException {
        this.fStartForwardOffset = 0;
        this.fDocument = document;
        this.fOffset = offset;
        this.fForward = false;
        this.fcurrentPositionI = 0;
        this.fPositions = this.createPositions(document);
        this.fCurrentPosition = this.fPositions.length > 0 ? this.fPositions[0] : null;
    }

    private Position[] createPositions(IDocument document) throws BadPositionCategoryException {
        Position[] positions = PartitionCodeReader.getDocumentTypedPositions(document, this.contentType);
        List<TypedPosition> typedPositions = PartitionMerger.sortAndMergePositions(positions, document.getLength());
        int size = typedPositions.size();
        ArrayList<Position> list = new ArrayList<Position>(size);
        int i = 0;
        while (i < size) {
            Position position = (Position)typedPositions.get(i);
            if (this.isPositionValid(position, this.contentType)) {
                list.add(position);
            }
            ++i;
        }
        Object[] ret = list.toArray(new Position[list.size()]);
        if (!this.fForward) {
            ArrayUtils.reverse(ret);
        }
        return ret;
    }

    private boolean isPositionValid(Position position, String contentType) {
        if (this.fSupportKeepPositions || this.fForward && position.getOffset() + position.getLength() >= this.fOffset || !this.fForward && position.getOffset() <= this.fOffset) {
            if (position instanceof TypedPosition) {
                TypedPosition typedPosition = (TypedPosition)position;
                if (contentType != null && !contentType.equals(typedPosition.getType())) {
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public static Position[] getDocumentTypedPositions(IDocument document, String defaultContentType) {
        Position[] positions;
        try {
            IDocumentPartitionerExtension2 partitioner = (IDocumentPartitionerExtension2)document.getDocumentPartitioner();
            String[] managingPositionCategories = partitioner.getManagingPositionCategories();
            Assert.isTrue((managingPositionCategories.length == 1 ? 1 : 0) != 0);
            positions = document.getPositions(managingPositionCategories[0]);
            if (positions == null) {
                positions = new Position[]{new TypedPosition(0, document.getLength(), defaultContentType)};
            }
        }
        catch (Exception e) {
            Log.log("Unable to get positions for: " + defaultContentType, e);
            positions = new Position[]{new TypedPosition(0, document.getLength(), defaultContentType)};
        }
        return positions;
    }

    public void close() throws IOException {
        this.fDocument = null;
    }

    public int read() {
        try {
            return this.fForward ? this.readForwards() : this.readBackwards();
        }
        catch (BadLocationException badLocationException) {
            return -1;
        }
    }

    public char[][] getLegalLineDelimiters() {
        if (this.fDelimiters == null) {
            String[] delimiters = this.fDocument.getLegalLineDelimiters();
            this.fDelimiters = new char[delimiters.length][];
            int i = 0;
            while (i < delimiters.length) {
                this.fDelimiters[i] = delimiters[i].toCharArray();
                ++i;
            }
        }
        return this.fDelimiters;
    }

    public int getColumn() {
        try {
            int offset = this.getOffset();
            int line = this.fDocument.getLineOfOffset(offset);
            int start = this.fDocument.getLineOffset(line);
            return offset - start;
        }
        catch (BadLocationException badLocationException) {
            return -1;
        }
    }

    public void unread() {
        if (this.fForward) {
            if (this.fCurrentPosition == null) {
                if (this.fPositions.length > 0) {
                    this.fcurrentPositionI = this.fPositions.length - 1;
                    this.fCurrentPosition = this.fPositions[this.fcurrentPositionI];
                    this.fOffset = this.fCurrentPosition.offset + this.fCurrentPosition.length;
                    if (this.fOffset < this.fStartForwardOffset) {
                        this.fOffset = this.fStartForwardOffset;
                    }
                }
                return;
            }
            --this.fOffset;
            if (this.fOffset < this.fStartForwardOffset) {
                this.fOffset = this.fStartForwardOffset;
                return;
            }
            while (this.fOffset < this.fCurrentPosition.offset) {
                if (this.fcurrentPositionI > 0) {
                    --this.fcurrentPositionI;
                    this.fCurrentPosition = this.fPositions[this.fcurrentPositionI];
                    if (this.fCurrentPosition.offset + this.fCurrentPosition.length > this.fOffset) continue;
                    this.fOffset = this.fCurrentPosition.offset + this.fCurrentPosition.length - 1;
                    if (this.fOffset < this.fStartForwardOffset) {
                        this.fOffset = this.fStartForwardOffset;
                    }
                    return;
                }
                return;
            }
        } else {
            throw new AssertionError((Object)"Unread when going backward not supported yet");
        }
    }

    private int readForwards() throws BadLocationException {
        while (true) {
            if (this.fCurrentPosition == null) {
                return -1;
            }
            if (this.fCurrentPosition.offset + this.fCurrentPosition.length > this.fOffset) break;
            ++this.fcurrentPositionI;
            if (this.fcurrentPositionI >= this.fPositions.length) {
                this.fCurrentPosition = null;
                return -1;
            }
            this.fCurrentPosition = this.fPositions[this.fcurrentPositionI];
        }
        if (this.fCurrentPosition.offset > this.fOffset) {
            this.fOffset = this.fCurrentPosition.offset;
        }
        if (this.fOffset < this.fEnd) {
            char current = this.fDocument.getChar(this.fOffset);
            ++this.fOffset;
            return current;
        }
        this.fCurrentPosition = null;
        return -1;
    }

    private int readBackwards() throws BadLocationException {
        while (true) {
            if (this.fCurrentPosition == null) {
                return -1;
            }
            if (this.fCurrentPosition.offset <= this.fOffset) break;
            ++this.fcurrentPositionI;
            if (this.fcurrentPositionI >= this.fPositions.length) {
                return -1;
            }
            this.fCurrentPosition = this.fPositions[this.fcurrentPositionI];
        }
        if (this.fCurrentPosition.offset + this.fCurrentPosition.length <= this.fOffset) {
            this.fOffset = this.fCurrentPosition.offset + this.fCurrentPosition.length - 1;
        }
        if (this.fOffset >= 0) {
            char current = this.fDocument.getChar(this.fOffset);
            --this.fOffset;
            return current;
        }
        return -1;
    }
}

