/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.shared_core.parsing;

import org.python.pydev.shared_core.log.Log;
import org.python.pydev.shared_core.parsing.BaseParserManager;
import org.python.pydev.shared_core.parsing.ParserScheduler;

public class ParsingThread
extends Thread {
    volatile boolean okToGo;
    volatile boolean force = false;
    private final ParserScheduler parser;
    private final Object[] argsToReparse;
    private volatile boolean disposed;
    private final BaseParserManager parserManager;

    protected ParsingThread(BaseParserManager parserManager, ParserScheduler parser, Object ... argsToReparse) {
        this.parser = parser;
        this.argsToReparse = argsToReparse;
        this.parserManager = parserManager;
    }

    public void run() {
        try {
            if (!this.force) {
                this.makeOkAndSleepUntilIdleTimeElapses();
            }
            while (!(this.okToGo || this.force || this.disposed)) {
                this.makeOkAndSleepUntilIdleTimeElapses();
            }
            if (this.disposed) {
                return;
            }
            try {
                this.parser.state = 3;
                this.parser.reparseDocument(this.argsToReparse);
            }
            catch (Throwable e) {
                Log.log(e);
            }
            this.force = false;
            this.parser.state = 0;
        }
        finally {
            this.parser.parsingThread = null;
        }
    }

    private void makeOkAndSleepUntilIdleTimeElapses() {
        try {
            this.okToGo = true;
            ParsingThread.sleep(this.parserManager.getElapseMillisBeforeAnalysis());
        }
        catch (Exception exception) {}
    }

    public void dispose() {
        this.disposed = true;
    }
}

