/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.shared_core.parsing;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.text.IDocument;
import org.python.pydev.shared_core.editor.IBaseEditor;
import org.python.pydev.shared_core.parsing.IParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseParserManager {
    private static final boolean DEBUG = false;
    protected final Object lock = new Object();
    private static final String KEY_IN_CACHE = "ParserManager_Parser";
    public static final String USE_PYDEV_ANALYSIS_ONLY_ON_DOC_SAVE = "USE_PYDEV_ONLY_ON_DOC_SAVE";
    public static final String PYDEV_ELAPSE_BEFORE_ANALYSIS = "PYDEV_ELAPSE_BEFORE_ANALYSIS";
    protected int millisBeforeAnalysis = 3000;
    protected boolean useOnlyOnSave = false;
    protected volatile Map<IParser, List<IBaseEditor>> parsers = new HashMap<IParser, List<IBaseEditor>>();

    public int getElapseMillisBeforeAnalysis() {
        return this.millisBeforeAnalysis;
    }

    public boolean useAnalysisOnlyOnDocSave() {
        return this.useOnlyOnSave;
    }

    protected BaseParserManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized List<IParser> getParsers() {
        Object object = this.lock;
        synchronized (object) {
            ArrayList<IParser> ret = new ArrayList<IParser>(this.parsers.keySet());
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void attachParserTo(IBaseEditor edit) {
        Object object = this.lock;
        synchronized (object) {
            IParser existingParser = this.getParser(edit);
            if (existingParser != null) {
                this.notifyEditorDisposed(edit);
            }
            for (Map.Entry<IParser, List<IBaseEditor>> entry : this.parsers.entrySet()) {
                for (IBaseEditor curr : entry.getValue()) {
                    if (!curr.hasSameInput(edit)) continue;
                    IParser p = this.getParser(curr);
                    this.makeParserAssociations(edit, p);
                    p.forceReparse(new Object[0]);
                    return;
                }
            }
            IParser pyParser = this.createParser(edit);
            boolean useAnalysisOnlyOnDocSave = this.useAnalysisOnlyOnDocSave();
            pyParser.resetTimeoutPreferences(useAnalysisOnlyOnDocSave);
            this.makeParserAssociations(edit, pyParser);
            IDocument doc = edit.getDocument();
            pyParser.setDocument(doc, edit.getEditorInput());
        }
    }

    protected abstract IParser createParser(IBaseEditor var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void makeParserAssociations(IBaseEditor edit, IParser pyParser) {
        Object object = this.lock;
        synchronized (object) {
            List<IBaseEditor> lst = this.parsers.get(pyParser);
            if (lst == null) {
                lst = new ArrayList<IBaseEditor>();
                this.parsers.put(pyParser, lst);
            }
            lst.add(edit);
            pyParser.addParseListener(edit);
            edit.getCache().put(KEY_IN_CACHE, pyParser);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void notifySaved(IBaseEditor edit) {
        Object object = this.lock;
        synchronized (object) {
            this.getParser(edit).notifySaved();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void notifyEditorDisposed(IBaseEditor edit) {
        Object object = this.lock;
        synchronized (object) {
            IParser parser = this.getParser(edit);
            if (parser != null) {
                boolean dispose;
                parser.removeParseListener(edit);
                List<IBaseEditor> lst = this.parsers.get(parser);
                lst.remove(edit);
                edit.getCache().remove(KEY_IN_CACHE);
                boolean bl = dispose = lst.size() == 0;
                if (dispose) {
                    parser.dispose();
                    this.parsers.remove(parser);
                } else {
                    IBaseEditor pyEdit = lst.get(0);
                    IDocument doc = pyEdit.getDocument();
                    parser.setDocument(doc, pyEdit.getEditorInput());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized IParser getParser(IBaseEditor edit) {
        Object object = this.lock;
        synchronized (object) {
            return (IParser)edit.getCache().get(KEY_IN_CACHE);
        }
    }
}

