/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.shared_core.io;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.python.pydev.shared_core.callbacks.ICallback;
import org.python.pydev.shared_core.log.Log;
import org.python.pydev.shared_core.string.FastStringBuffer;
import org.python.pydev.shared_core.string.StringUtils;
import org.python.pydev.shared_core.utils.PlatformUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileUtils {
    private static final Map<File, Set<String>> alreadyReturned = new HashMap<File, Set<String>>();
    private static Object lockTempFiles = new Object();
    private static String openDirExecutable = null;
    private static final String OPEN_DIR_EXEC_NOT_AVAILABLE = "NOT_AVAILABLE";
    public static String BOM_UTF8 = StringUtils.BOM_UTF8;
    public static String BOM_UNICODE = StringUtils.BOM_UNICODE;
    public static boolean LOG_ENCODING_ERROR = true;
    public static final Pattern ENCODING_PATTERN = Pattern.compile("coding[:=][\\s]*([-\\w.]+)");

    public static Object readFromInputStreamAndCloseIt(ICallback<Object, ObjectInputStream> readFromFileMethod, InputStream input) {
        ObjectInputStream in = null;
        Object o = null;
        try {
            try {
                in = new ObjectInputStream(input);
                o = readFromFileMethod.call(in);
            }
            finally {
                if (in != null) {
                    in.close();
                }
                input.close();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return o;
    }

    public static void appendStrToFile(String str, String file) {
        try {
            FileOutputStream stream = new FileOutputStream(file, true);
            try {
                stream.write(str.getBytes());
            }
            finally {
                stream.close();
            }
        }
        catch (FileNotFoundException e) {
            Log.log(e);
        }
        catch (IOException e) {
            Log.log(e);
        }
    }

    public static void writeStrToFile(String str, String file) {
        FileUtils.writeStrToFile(str, new File(file));
    }

    public static void writeStrToFile(String str, File file) {
        FileUtils.writeBytesToFile(str.getBytes(), file);
    }

    public static void writeBytesToFile(byte[] bytes, File file) {
        try {
            FileOutputStream stream = new FileOutputStream(file);
            try {
                stream.write(bytes);
            }
            finally {
                stream.close();
            }
        }
        catch (FileNotFoundException e) {
            Log.log(e);
        }
        catch (IOException e) {
            Log.log(e);
        }
    }

    public static void writeToFile(Object o, File file) {
        try {
            FileOutputStream out = new FileOutputStream(file);
            FileUtils.writeToStreamAndCloseIt(o, out);
        }
        catch (Exception e) {
            Log.log(e);
        }
    }

    public static void writeToStreamAndCloseIt(Object o, OutputStream out) throws IOException {
        OutputStream b = null;
        b = out instanceof BufferedOutputStream || out instanceof ByteArrayOutputStream ? out : new BufferedOutputStream(out);
        try {
            try {
                ObjectOutputStream stream = new ObjectOutputStream(b);
                stream.writeObject(o);
                stream.close();
            }
            catch (Exception e) {
                Log.log(e);
                throw new RuntimeException(e);
            }
        }
        finally {
            b.close();
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static Object readFromFile(File file) {
        try {
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));
            try {
                Object object;
                ObjectInputStream stream = new ObjectInputStream(in);
                try {
                    Object o;
                    object = o = stream.readObject();
                }
                catch (Throwable throwable) {
                    stream.close();
                    throw throwable;
                }
                stream.close();
                return object;
            }
            finally {
                ((InputStream)in).close();
            }
        }
        catch (Exception e) {
            Log.log(e);
            return null;
        }
    }

    public static String getFileAbsolutePath(String f) {
        return FileUtils.getFileAbsolutePath(new File(f));
    }

    public static String getFileAbsolutePath(File f) {
        try {
            return f.getCanonicalPath();
        }
        catch (IOException iOException) {
            return f.getAbsolutePath();
        }
    }

    public static void copyFile(String srcFilename, String dstFilename) {
        FileUtils.copyFile(new File(srcFilename), new File(dstFilename));
    }

    public static void copyFile(File srcFilename, File dstFilename) {
        FileChannel srcChannel = null;
        AbstractInterruptibleChannel dstChannel = null;
        try {
            try {
                srcChannel = new FileInputStream(srcFilename).getChannel();
                dstChannel = new FileOutputStream(dstFilename).getChannel();
                ((FileChannel)dstChannel).transferFrom(srcChannel, 0L, srcChannel.size());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        finally {
            if (srcChannel != null) {
                try {
                    srcChannel.close();
                }
                catch (IOException e) {
                    Log.log(e);
                }
            }
            if (dstChannel != null) {
                try {
                    dstChannel.close();
                }
                catch (IOException e) {
                    Log.log(e);
                }
            }
        }
    }

    public static void copyDirectory(File srcPath, File dstPath, ICallback<Boolean, File> filter, ICallback<String, String> changeFileContents) throws IOException {
        if (srcPath.isDirectory()) {
            String[] files;
            if (filter != null && filter.call(srcPath).booleanValue()) {
                return;
            }
            if (!dstPath.exists()) {
                dstPath.mkdir();
            }
            if ((files = srcPath.list()) != null) {
                int i = 0;
                while (i < files.length) {
                    FileUtils.copyDirectory(new File(srcPath, files[i]), new File(dstPath, files[i]), filter, changeFileContents);
                    ++i;
                }
            }
        } else if (srcPath.exists()) {
            if (filter != null && filter.call(srcPath).booleanValue()) {
                return;
            }
            if (changeFileContents == null) {
                FileUtils.copyFile(srcPath.getAbsolutePath(), dstPath.getAbsolutePath());
            } else {
                String fileContents = FileUtils.getFileContents(srcPath);
                fileContents = changeFileContents.call(fileContents);
                FileUtils.writeStrToFile(fileContents, dstPath);
            }
        }
    }

    public static FastStringBuffer fillBufferWithStream(InputStream contentStream, String encoding, IProgressMonitor monitor) throws IOException {
        FastStringBuffer buffer;
        Reader in = null;
        try {
            int BUFFER_SIZE = 2048;
            int DEFAULT_FILE_SIZE = 8 * BUFFER_SIZE;
            int available = contentStream.available();
            if (DEFAULT_FILE_SIZE < available) {
                DEFAULT_FILE_SIZE = available;
            }
            if (encoding == null) {
                in = new InputStreamReader(contentStream);
            } else {
                try {
                    in = new InputStreamReader(contentStream, encoding);
                }
                catch (UnsupportedEncodingException e) {
                    Log.log(e);
                    in = new InputStreamReader(contentStream);
                }
            }
            buffer = new FastStringBuffer(DEFAULT_FILE_SIZE);
            char[] readBuffer = new char[BUFFER_SIZE];
            int n = in.read(readBuffer);
            while (n > 0) {
                if (monitor != null && monitor.isCanceled()) {
                    return null;
                }
                buffer.append(readBuffer, 0, n);
                n = in.read(readBuffer);
            }
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception e) {
                Log.log(e);
            }
        }
        return buffer;
    }

    public static boolean createBackupFile(File file) {
        File parent;
        if (file != null && file.isFile() && (parent = file.getParentFile()).isDirectory()) {
            String[] list = parent.list();
            HashSet<String> set = new HashSet<String>();
            set.addAll(Arrays.asList(list));
            String initialName = file.getName();
            String name = initialName = String.valueOf(initialName) + ".bak";
            int i = 0;
            while (set.contains(name)) {
                name = String.valueOf(initialName) + i;
                ++i;
            }
            FileUtils.copyFile(file.getAbsolutePath(), new File(parent, name).getAbsolutePath());
            return true;
        }
        return false;
    }

    public static File getTempFileAt(File parentDir, String prefix) {
        return FileUtils.getTempFileAt(parentDir, prefix, "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File getTempFileAt(File parentDir, String prefix, String extension) {
        Object object = lockTempFiles;
        synchronized (object) {
            Assert.isTrue((boolean)parentDir.isDirectory());
            Set<String> current = alreadyReturned.get(parentDir);
            if (current == null) {
                current = new HashSet<String>();
                alreadyReturned.put(parentDir, current);
            }
            current.addAll(FileUtils.getFilesStartingWith(parentDir, prefix));
            FastStringBuffer buf = new FastStringBuffer();
            long i = 0L;
            while (i < Long.MAX_VALUE) {
                File file;
                String v = buf.clear().append(prefix).append(i).append(extension).toString();
                if (!current.contains(v) && !(file = new File(parentDir, v)).exists()) {
                    current.add(file.getName());
                    return file;
                }
                ++i;
            }
            return null;
        }
    }

    public static HashSet<String> getFilesStartingWith(File parentDir, String prefix) {
        String[] list = parentDir.list();
        HashSet<String> hashSet = new HashSet<String>();
        if (list != null) {
            String[] stringArray = list;
            int n = list.length;
            int n2 = 0;
            while (n2 < n) {
                String string = stringArray[n2];
                if (string.startsWith(prefix)) {
                    hashSet.add(string);
                }
                ++n2;
            }
        }
        return hashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearTempFilesAt(File parentDir, String prefix) {
        Object object = lockTempFiles;
        synchronized (object) {
            try {
                Assert.isTrue((boolean)parentDir.isDirectory());
                String[] list = parentDir.list();
                if (list != null) {
                    String[] stringArray = list;
                    int n = list.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String string = stringArray[n2];
                        if (string.startsWith(prefix)) {
                            String integer = string.substring(prefix.length());
                            try {
                                Integer.parseInt(integer);
                                try {
                                    new File(parentDir, string).delete();
                                }
                                catch (Exception exception) {}
                            }
                            catch (NumberFormatException numberFormatException) {}
                        }
                        ++n2;
                    }
                }
                alreadyReturned.remove(parentDir);
            }
            catch (Throwable e) {
                Log.log(e);
            }
        }
    }

    public static void deleteDirectoryTree(File directory) throws IOException {
        if (!directory.exists()) {
            return;
        }
        File[] files = directory.listFiles();
        if (files != null) {
            int i = 0;
            while (i < files.length) {
                File f = files[i];
                if (f.isDirectory()) {
                    FileUtils.deleteDirectoryTree(f);
                } else {
                    FileUtils.deleteFile(f);
                }
                ++i;
            }
        }
        if (!directory.delete()) {
            throw new IOException("Delete operation failed when deleting: " + directory);
        }
    }

    public static void deleteFile(File file) throws IOException {
        if (!file.exists()) {
            throw new FileNotFoundException(file.getAbsolutePath());
        }
        if (!file.delete()) {
            throw new IOException("Delete operation failed when deleting: " + file);
        }
    }

    public static void openDirectory(File dir) {
        String executable = FileUtils.getOpenDirectoryExecutable();
        if (executable != null) {
            try {
                if (executable.equals("kfmclient")) {
                    Runtime.getRuntime().exec(new String[]{executable, "exec", dir.toString()}, null, dir);
                } else {
                    Runtime.getRuntime().exec(new String[]{executable, dir.toString()}, null, dir);
                }
            }
            catch (Throwable e) {
                Log.log(e);
            }
        }
    }

    private static String getOpenDirectoryExecutable() {
        if (openDirExecutable == null) {
            Object env;
            if (PlatformUtils.isWindowsPlatform()) {
                openDirExecutable = "explorer";
                return openDirExecutable;
            }
            if (PlatformUtils.isMacOsPlatform()) {
                openDirExecutable = "open";
                return openDirExecutable;
            }
            try {
                env = System.getenv("DESKTOP_LAUNCH");
                if (env != null && ((String)env).trim().length() > 0) {
                    openDirExecutable = env;
                    return openDirExecutable;
                }
            }
            catch (Throwable throwable) {}
            try {
                env = System.getenv();
                if (env.containsKey("KDE_FULL_SESSION") || env.containsKey("KDE_MULTIHEAD")) {
                    openDirExecutable = "kfmclient";
                    return openDirExecutable;
                }
                if (env.containsKey("GNOME_DESKTOP_SESSION_ID") || env.containsKey("GNOME_KEYRING_SOCKET")) {
                    openDirExecutable = "gnome-open";
                    return openDirExecutable;
                }
            }
            catch (Throwable throwable) {}
            openDirExecutable = OPEN_DIR_EXEC_NOT_AVAILABLE;
        }
        if (openDirExecutable == OPEN_DIR_EXEC_NOT_AVAILABLE) {
            return null;
        }
        return openDirExecutable;
    }

    public static boolean getSupportsOpenDirectory() {
        return FileUtils.getOpenDirectoryExecutable() != null;
    }

    public static File createFileFromParts(String ... parts) {
        String part0 = parts[0];
        File f = new File(part0);
        int i = 1;
        while (i < parts.length) {
            String part = parts[i];
            f = new File(f, part);
            ++i;
        }
        return f;
    }

    public static Object getStreamContents(InputStream contentStream, String encoding, IProgressMonitor monitor, Class<? extends Object> returnType) throws IOException {
        FastStringBuffer buffer = FileUtils.fillBufferWithStream(contentStream, encoding, monitor);
        if (buffer == null) {
            return null;
        }
        if (returnType == null || returnType == FastStringBuffer.class) {
            return buffer;
        }
        if (returnType == IDocument.class) {
            Document doc = new Document(buffer.toString());
            return doc;
        }
        if (returnType == String.class) {
            return buffer.toString();
        }
        throw new RuntimeException("Don't know how to handle return type: " + returnType);
    }

    public static String getStreamContents(InputStream stream, String encoding, IProgressMonitor monitor) {
        try {
            String string = (String)FileUtils.getStreamContents(stream, encoding, monitor, String.class);
            return string;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                if (stream != null) {
                    stream.close();
                }
            }
            catch (Exception e) {
                Log.log(e);
            }
        }
    }

    public static Object getFileContentsCustom(File file, String encoding, Class<? extends Object> returnType) {
        FileInputStream stream = null;
        try {
            stream = new FileInputStream(file);
            Object object = FileUtils.getStreamContents(stream, null, null, returnType);
            return object;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                if (stream != null) {
                    stream.close();
                }
            }
            catch (Exception e) {
                Log.log(e);
            }
        }
    }

    public static Object getFileContentsCustom(File file, Class<? extends Object> returnType) {
        return FileUtils.getFileContentsCustom(file, null, returnType);
    }

    public static String getFileContents(File file) {
        return (String)FileUtils.getFileContentsCustom(file, null, String.class);
    }

    public static String getPyFileContents(File file) {
        return (String)FileUtils.getFileContentsCustom(file, FileUtils.getPythonFileEncoding(file), String.class);
    }

    /*
     * Unable to fully structure code
     */
    public static String getPythonFileEncoding(Reader inputStreamReader, String fileLocation) throws IllegalCharsetNameException {
        block19: {
            block18: {
                ret = null;
                reader = new BufferedReader(inputStreamReader);
                lEnc = null;
                l1 = reader.readLine();
                if (l1 == null) ** GOTO lbl18
                if (!l1.startsWith(FileUtils.BOM_UTF8)) break block18;
                try {
                    reader.close();
                }
                catch (IOException v0) {}
                return "utf-8";
            }
            try {
                try {
                    if (l1.indexOf("coding") != -1) {
                        lEnc = l1;
                    }
lbl18:
                    // 4 sources

                    if (lEnc == null) {
                        l2 = reader.readLine();
                        if (l2 != null && l2.indexOf("coding") != -1) {
                            lEnc = l2;
                        } else {
                            ret = null;
                        }
                    }
                    if (lEnc == null) break block19;
                    if ((lEnc = lEnc.trim()).length() == 0) {
                        ret = null;
                        break block19;
                    }
                    if (lEnc.charAt(0) != '#' || !(matcher = FileUtils.ENCODING_PATTERN.matcher(lEnc)).find()) break block19;
                    ret = matcher.group(1).trim();
                }
                catch (IOException e) {
                    Log.log(e);
                    try {
                        reader.close();
                    }
                    catch (IOException v1) {}
                }
            }
            catch (Throwable var7_8) {
                try {
                    reader.close();
                }
                catch (IOException v2) {}
                throw var7_8;
            }
        }
        try {
            reader.close();
        }
        catch (IOException v3) {}
        ret = FileUtils.getValidEncoding(ret, fileLocation);
        return ret;
    }

    public static String getValidEncoding(String ret, String fileLocation) {
        block8: {
            block9: {
                block10: {
                    if (ret == null) {
                        return ret;
                    }
                    String lower = ret.trim().toLowerCase();
                    if (lower.startsWith("latin") && lower.indexOf("1") != -1) {
                        return "latin1";
                    }
                    if (lower.equals("iso-latin-1-unix")) {
                        return "latin1";
                    }
                    try {
                        if (Charset.isSupported(ret)) break block8;
                        if (!LOG_ENCODING_ERROR) break block9;
                        if (fileLocation == null || !"uft-8".equals(ret) || !fileLocation.endsWith("bad_coding.py")) break block10;
                        return null;
                    }
                    catch (IllegalCharsetNameException ex) {
                        if (LOG_ENCODING_ERROR) {
                            String msg = "The encoding found: >>" + ret + "<< on " + fileLocation + " is not a valid encoding.";
                            Log.log(4, msg, ex);
                        }
                        return null;
                    }
                }
                String msg = "The encoding found: >>" + ret + "<< on " + fileLocation + " is not a valid encoding.";
                Log.log(4, msg, new UnsupportedEncodingException(msg));
            }
            return null;
        }
        return ret;
    }

    public static String getPythonFileEncoding(File f) throws IllegalCharsetNameException {
        String string;
        FileInputStream fileInputStream = new FileInputStream(f);
        try {
            String pythonFileEncoding;
            InputStreamReader inputStreamReader = new InputStreamReader(new BufferedInputStream(fileInputStream));
            string = pythonFileEncoding = FileUtils.getPythonFileEncoding(inputStreamReader, f.getAbsolutePath());
        }
        catch (Throwable throwable) {
            try {
                try {
                    fileInputStream.close();
                }
                catch (Exception e) {
                    Log.log(e);
                }
                throw throwable;
            }
            catch (FileNotFoundException fileNotFoundException) {
                return null;
            }
        }
        try {
            fileInputStream.close();
        }
        catch (Exception e) {
            Log.log(e);
        }
        return string;
    }

    /*
     * Loose catch block
     */
    public static boolean hasPythonShebang(Reader inputStreamReader) throws IllegalCharsetNameException {
        block13: {
            BufferedReader reader;
            block12: {
                reader = new BufferedReader(inputStreamReader);
                String l1 = reader.readLine();
                if (l1 == null || !FileUtils.isPythonShebangLine(l1)) break block12;
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
                return true;
                catch (IOException e) {
                    try {
                        Log.log(e);
                    }
                    catch (Throwable throwable) {
                        try {
                            reader.close();
                        }
                        catch (IOException iOException) {}
                        throw throwable;
                    }
                    try {
                        reader.close();
                    }
                    catch (IOException iOException) {}
                    break block13;
                }
            }
            try {
                reader.close();
            }
            catch (IOException iOException) {}
        }
        return false;
    }

    public static boolean isPythonShebangLine(String l1) {
        return (l1 = StringUtils.removeBom(l1)).startsWith("#!") && l1.indexOf("python") != -1;
    }
}

