/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.shared_core.auto_edit;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.python.pydev.shared_core.auto_edit.AutoEditStrategyHelper;
import org.python.pydev.shared_core.log.Log;
import org.python.pydev.shared_core.string.FastStringBuffer;
import org.python.pydev.shared_core.string.StringUtils;
import org.python.pydev.shared_core.string.TextSelectionUtils;
import org.python.pydev.shared_core.structure.Tuple;
import org.python.pydev.shared_core.utils.DocCmd;

public class AutoEditStrategyPeerHelper {
    private int linkOffset;
    private int linkExitPos;
    private int linkLen;

    public static VerifyKeyListener createVerifyKeyListener(final TextViewer viewer) {
        return new VerifyKeyListener(){
            private final AutoEditStrategyPeerHelper pyPeerLinker = new AutoEditStrategyPeerHelper();

            public void verifyKey(VerifyEvent event) {
                if (!event.doit) {
                    return;
                }
                switch (event.character) {
                    case '\"': 
                    case '\'': 
                    case '(': 
                    case '[': 
                    case '{': {
                        break;
                    }
                    default: {
                        return;
                    }
                }
                if (viewer != null && viewer.isEditable()) {
                    TextSelectionUtils ps;
                    ISelection selection;
                    boolean blockSelection = false;
                    try {
                        blockSelection = viewer.getTextWidget().getBlockSelection();
                    }
                    catch (Throwable throwable) {}
                    if (!blockSelection && (selection = viewer.getSelection()) instanceof ITextSelection && this.pyPeerLinker.perform(ps = new TextSelectionUtils(viewer.getDocument(), (ITextSelection)selection), event.character, viewer)) {
                        event.doit = false;
                    }
                }
            }
        };
    }

    protected boolean perform(TextSelectionUtils ps, char c, TextViewer viewer) {
        block12: {
            block11: {
                DocCmd docCmd;
                IDocument doc;
                block10: {
                    this.linkOffset = -1;
                    this.linkExitPos = -1;
                    this.linkLen = 0;
                    boolean literal = true;
                    switch (c) {
                        case '\"': 
                        case '\'': {
                            break;
                        }
                        case '(': 
                        case '<': 
                        case '[': 
                        case '{': {
                            literal = false;
                            break;
                        }
                        default: {
                            return false;
                        }
                    }
                    doc = ps.getDoc();
                    docCmd = new DocCmd(ps.getAbsoluteCursorOffset(), ps.getSelLength(), "" + c);
                    if (!literal) break block10;
                    if (!this.handleLiteral(doc, docCmd, ps)) {
                        return false;
                    }
                    break block11;
                }
                if (this.handleBrackets(ps, c, doc, docCmd, viewer)) break block11;
                return false;
            }
            if (this.linkOffset != -1 && this.linkExitPos != -1) break block12;
            return true;
        }
        try {
            viewer.setSelectedRange(this.linkOffset, this.linkLen);
        }
        catch (Exception e) {
            Log.log(e);
        }
        return true;
    }

    private boolean handleBrackets(TextSelectionUtils ps, char c, IDocument doc, DocCmd docCmd, TextViewer viewer) throws BadLocationException {
        char peer;
        AutoEditStrategyHelper helper = new AutoEditStrategyHelper(doc, new DocCmd(ps.getAbsoluteCursorOffset(), ps.getSelLength(), "" + c));
        if (helper.shouldClose(ps, c, peer = StringUtils.getPeer(c))) {
            int offset = ps.getAbsoluteCursorOffset();
            doc.replace(offset, ps.getSelLength(), StringUtils.getWithClosedPeer(c));
            this.linkOffset = offset + 1;
            this.linkLen = 0;
            this.linkExitPos = this.linkOffset + this.linkLen + 1;
        } else {
            docCmd.doExecute(doc);
            if (viewer != null) {
                viewer.setSelectedRange(docCmd.offset + docCmd.text.length(), 0);
            }
        }
        return true;
    }

    private boolean handleLiteral(IDocument document, DocumentCommand command, TextSelectionUtils ps) throws BadLocationException {
        boolean hasMatchesAfter;
        String cursorLineContents;
        int offset = ps.getAbsoluteCursorOffset();
        if (command.length > 0) {
            String selectedText = ps.getSelectedText();
            if (selectedText.indexOf(13) != -1 || selectedText.indexOf(10) != -1) {
                FastStringBuffer buf = new FastStringBuffer(selectedText.length() + 10);
                buf.appendN(command.text, 3);
                buf.append(selectedText);
                buf.appendN(command.text, 3);
                document.replace(offset, ps.getSelLength(), buf.toString());
                this.linkOffset = offset + 3;
                this.linkLen = selectedText.length();
                this.linkExitPos = this.linkOffset + this.linkLen + 3;
            } else {
                document.replace(offset, ps.getSelLength(), String.valueOf(command.text) + selectedText + command.text);
                this.linkOffset = offset + 1;
                this.linkLen = selectedText.length();
                this.linkExitPos = this.linkOffset + this.linkLen + 1;
            }
            return true;
        }
        char literalChar = command.text.charAt(0);
        try {
            char nextChar = ps.getCharAfterCurrentOffset();
            if (Character.isJavaIdentifierPart(nextChar)) {
                return false;
            }
        }
        catch (BadLocationException badLocationException) {}
        if ((cursorLineContents = ps.getCursorLineContents()).indexOf(literalChar) == -1) {
            document.replace(offset, ps.getSelLength(), String.valueOf(command.text) + command.text);
            this.linkOffset = offset + 1;
            this.linkLen = 0;
            this.linkExitPos = this.linkOffset + this.linkLen + 1;
            return true;
        }
        boolean balanced = this.isLiteralBalanced(cursorLineContents);
        Tuple<String, String> beforeAndAfterMatchingChars = ps.getBeforeAndAfterMatchingChars(literalChar);
        int matchesBefore = ((String)beforeAndAfterMatchingChars.o1).length();
        int matchesAfter = ((String)beforeAndAfterMatchingChars.o2).length();
        boolean hasMatchesBefore = matchesBefore != 0;
        boolean bl = hasMatchesAfter = matchesAfter != 0;
        if (!hasMatchesBefore && !hasMatchesAfter) {
            if (balanced) {
                document.replace(offset, ps.getSelLength(), String.valueOf(command.text) + command.text);
                this.linkOffset = offset + 1;
                this.linkLen = 0;
                this.linkExitPos = this.linkOffset + this.linkLen + 1;
                return true;
            }
        } else {
            return false;
        }
        return false;
    }

    private boolean isLiteralBalanced(String cursorLineContents) {
        return true;
    }

    int getLinkLen() {
        return this.linkLen;
    }

    int getLinkExitPos() {
        return this.linkExitPos;
    }

    int getLinkOffset() {
        return this.linkOffset;
    }
}

