/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.shared_core.actions;

import java.util.List;
import org.eclipse.jface.text.BadLocationException;
import org.python.pydev.shared_core.actions.LineCommentAction;
import org.python.pydev.shared_core.actions.LineUncommentAction;
import org.python.pydev.shared_core.string.StringUtils;
import org.python.pydev.shared_core.string.TextSelectionUtils;
import org.python.pydev.shared_core.structure.Tuple;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ToggleLineCommentAction {
    private TextSelectionUtils ps;
    private String commentPattern;
    private int spacesInStart;

    public ToggleLineCommentAction(TextSelectionUtils ps, String commentPattern, int spacesInStart) {
        this.ps = ps;
        this.commentPattern = commentPattern;
        this.spacesInStart = spacesInStart;
    }

    public Tuple<Integer, Integer> execute() throws BadLocationException {
        this.ps.selectCompleteLine();
        String selectedText = this.ps.getSelectedText();
        List<String> ret = StringUtils.splitInLines(selectedText);
        boolean allStartWithComments = true;
        for (String string : ret) {
            if (string.startsWith(this.commentPattern)) continue;
            allStartWithComments = false;
            break;
        }
        if (allStartWithComments) {
            return new LineUncommentAction(this.ps, this.commentPattern, this.spacesInStart).execute();
        }
        return new LineCommentAction(this.ps, this.commentPattern, this.spacesInStart).execute();
    }
}

