/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.core.internal.context.java;

import org.eclipse.jpt.common.core.resource.java.JavaResourcePackage;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.internal.collection.CollectionTools;
import org.eclipse.jpt.common.utility.internal.iterable.EmptyIterable;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.common.utility.internal.iterable.SingleElementIterable;
import org.eclipse.jpt.jaxb.core.context.JaxbPackageInfo;
import org.eclipse.jpt.jaxb.core.context.XmlNs;
import org.eclipse.jpt.jaxb.core.context.java.JavaXmlSchema;
import org.eclipse.jpt.jaxb.core.internal.context.java.AbstractJavaContextNode;
import org.eclipse.jpt.jaxb.core.resource.java.XmlNsAnnotation;
import org.eclipse.jpt.jaxb.core.xsd.XsdSchema;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericJavaXmlNs
extends AbstractJavaContextNode
implements XmlNs {
    protected final XmlNsAnnotation resourceXmlNs;
    protected String namespaceURI;
    protected String prefix;

    public GenericJavaXmlNs(JavaXmlSchema parent, XmlNsAnnotation xmlNsAnnotation) {
        super(parent);
        this.resourceXmlNs = xmlNsAnnotation;
        this.namespaceURI = this.getResourceNamespaceURI();
        this.prefix = this.getResourcePrefix();
    }

    @Override
    public XmlNsAnnotation getResourceXmlNs() {
        return this.resourceXmlNs;
    }

    @Override
    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.setNamespaceURI_(this.getResourceNamespaceURI());
        this.setPrefix_(this.getResourcePrefix());
    }

    protected JaxbPackageInfo getJaxbPackageInfo() {
        return this.getXmlSchema().getJaxbPackageInfo();
    }

    protected JavaXmlSchema getXmlSchema() {
        return (JavaXmlSchema)this.getParent();
    }

    protected JavaResourcePackage getResourcePackage() {
        return this.getJaxbPackageInfo().getResourcePackage();
    }

    @Override
    public String getNamespaceURI() {
        return this.namespaceURI;
    }

    @Override
    public void setNamespaceURI(String namespace) {
        this.resourceXmlNs.setNamespaceURI(namespace);
        this.setNamespaceURI_(namespace);
    }

    protected void setNamespaceURI_(String namespaceURI) {
        String old = this.namespaceURI;
        this.namespaceURI = namespaceURI;
        this.firePropertyChanged("namespaceURI", old, namespaceURI);
    }

    protected String getResourceNamespaceURI() {
        return this.resourceXmlNs.getNamespaceURI();
    }

    @Override
    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public void setPrefix(String prefix) {
        this.resourceXmlNs.setPrefix(prefix);
        this.setPrefix_(prefix);
    }

    protected void setPrefix_(String prefix) {
        String old = this.prefix;
        this.prefix = prefix;
        this.firePropertyChanged("prefix", old, prefix);
    }

    protected String getResourcePrefix() {
        return this.resourceXmlNs.getPrefix();
    }

    @Override
    public Iterable<String> getCompletionProposals(int pos) {
        if (this.getResourceXmlNs().namespaceURITouches(pos)) {
            return this.getNamespaceURICompletionProposals(pos);
        }
        return EmptyIterable.instance();
    }

    protected Iterable<String> getNamespaceURICompletionProposals(int pos) {
        String packageNamespace = this.getJaxbPackageInfo().getJaxbPackage().getNamespace();
        Iterable result = StringTools.isBlank((String)packageNamespace) ? EmptyIterable.instance() : new SingleElementIterable((Object)StringTools.convertToJavaStringLiteralContent((String)packageNamespace));
        XsdSchema schema = this.getJaxbPackageInfo().getJaxbPackage().getXsdSchema();
        if (schema != null) {
            result = IterableTools.concatenate((Iterable[])new Iterable[]{result, schema.getNamespaceProposals()});
        }
        return CollectionTools.set((Iterable)result);
    }

    @Override
    public TextRange getValidationTextRange() {
        return this.getResourceXmlNs().getTextRange();
    }

    public void toString(StringBuilder sb) {
        super.toString(sb);
        sb.append(this.namespaceURI);
    }
}

