/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.core.internal.context.java;

import java.util.List;
import javax.xml.namespace.QName;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.internal.collection.HashBag;
import org.eclipse.jpt.common.utility.internal.iterable.EmptyIterable;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.common.utility.iterable.ListIterable;
import org.eclipse.jpt.jaxb.core.JaxbNode;
import org.eclipse.jpt.jaxb.core.context.JaxbContextNode;
import org.eclipse.jpt.jaxb.core.context.XmlElementRef;
import org.eclipse.jpt.jaxb.core.context.XmlElementRefs;
import org.eclipse.jpt.jaxb.core.internal.AbstractJaxbNode;
import org.eclipse.jpt.jaxb.core.internal.context.java.AbstractJavaContextNode;
import org.eclipse.jpt.jaxb.core.resource.java.XmlElementRefAnnotation;
import org.eclipse.jpt.jaxb.core.validation.JptJaxbCoreValidationMessages;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericJavaXmlElementRefs
extends AbstractJavaContextNode
implements XmlElementRefs {
    protected final Context context;
    protected final AbstractJaxbNode.ContextListContainer<XmlElementRef, XmlElementRefAnnotation> xmlElementRefContainer;

    public GenericJavaXmlElementRefs(JaxbContextNode parent, Context context) {
        super(parent);
        this.context = context;
        this.xmlElementRefContainer = this.buildXmlElementRefContainer();
    }

    @Override
    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.xmlElementRefContainer.synchronizeWithResourceModel();
    }

    @Override
    public void update() {
        super.update();
        this.xmlElementRefContainer.update();
    }

    @Override
    public ListIterable<XmlElementRef> getXmlElementRefs() {
        return this.xmlElementRefContainer.getContextElements();
    }

    @Override
    public int getXmlElementRefsSize() {
        return this.xmlElementRefContainer.getContextElementsSize();
    }

    @Override
    public XmlElementRef addXmlElementRef(int index) {
        XmlElementRefAnnotation annotation = this.context.addXmlElementRefAnnotation(index);
        return (XmlElementRef)this.xmlElementRefContainer.addContextElement(index, annotation);
    }

    @Override
    public void removeXmlElementRef(int index) {
        this.context.removeXmlElementRefAnnotation(index);
        this.xmlElementRefContainer.removeContextElement(index);
    }

    @Override
    public void removeXmlElementRef(XmlElementRef xmlElementRef) {
        this.removeXmlElementRef(this.xmlElementRefContainer.indexOfContextElement(xmlElementRef));
    }

    @Override
    public void moveXmlElementRef(int targetIndex, int sourceIndex) {
        this.context.moveXmlElementRefAnnotation(targetIndex, sourceIndex);
        this.xmlElementRefContainer.moveContextElement(targetIndex, sourceIndex);
    }

    protected XmlElementRef buildXmlElementRef(XmlElementRefAnnotation xmlElementRefAnnotation) {
        return this.context.buildXmlElementRef(this, xmlElementRefAnnotation);
    }

    protected ListIterable<XmlElementRefAnnotation> getXmlElementRefAnnotations() {
        return this.context.getXmlElementRefAnnotations();
    }

    protected AbstractJaxbNode.ContextListContainer<XmlElementRef, XmlElementRefAnnotation> buildXmlElementRefContainer() {
        XmlElementRefContainer container = new XmlElementRefContainer();
        container.initialize();
        return container;
    }

    @Override
    public Iterable<String> getCompletionProposals(int pos) {
        Iterable<String> result = super.getCompletionProposals(pos);
        if (!IterableTools.isEmpty(result)) {
            return result;
        }
        for (XmlElementRef elementRef : this.getXmlElementRefs()) {
            result = elementRef.getCompletionProposals(pos);
            if (IterableTools.isEmpty(result)) continue;
            return result;
        }
        return EmptyIterable.instance();
    }

    @Override
    public TextRange getValidationTextRange() {
        return this.context.getValidationTextRange();
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter) {
        super.validate(messages, reporter);
        this.validateDuplicateTypesAndQNames(messages, reporter);
        for (XmlElementRef elementRef : this.getXmlElementRefs()) {
            elementRef.validate(messages, reporter);
        }
    }

    protected void validateDuplicateTypesAndQNames(List<IMessage> messages, IReporter reporter) {
        boolean isJaxbElement;
        String typeName;
        HashBag xmlElementRefTypes = new HashBag();
        HashBag xmlElementRefQnames = new HashBag();
        for (XmlElementRef xmlElementRef : this.getXmlElementRefs()) {
            typeName = xmlElementRef.getFullyQualifiedType();
            isJaxbElement = "javax.xml.bind.JAXBElement".equals(typeName);
            if (!isJaxbElement && !StringTools.isBlank((String)typeName)) {
                xmlElementRefTypes.add((Object)typeName);
            }
            String elementRefName = xmlElementRef.getQName().getName();
            if (!isJaxbElement || StringTools.isBlank((String)elementRefName)) continue;
            xmlElementRefQnames.add((Object)new QName(xmlElementRef.getQName().getNamespace(), elementRefName));
        }
        for (XmlElementRef xmlElementRef : this.getXmlElementRefs()) {
            typeName = xmlElementRef.getFullyQualifiedType();
            isJaxbElement = "javax.xml.bind.JAXBElement".equals(typeName);
            if (!isJaxbElement && xmlElementRefTypes.count((Object)typeName) > 1) {
                messages.add(this.buildValidationMessage((JaxbNode)xmlElementRef, xmlElementRef.getTypeTextRange(), JptJaxbCoreValidationMessages.XML_ELEMENT_REFS__DUPLICATE_XML_ELEMENT_TYPE, typeName));
            }
            String xmlElementNamespace = xmlElementRef.getQName().getNamespace();
            String xmlElementName = xmlElementRef.getQName().getName();
            if (!isJaxbElement || xmlElementRefQnames.count((Object)new QName(xmlElementNamespace, xmlElementName)) <= 1) continue;
            messages.add(this.buildValidationMessage((JaxbNode)xmlElementRef, xmlElementRef.getQName().getNameValidationTextRange(), JptJaxbCoreValidationMessages.XML_ELEMENT_REFS__DUPLICATE_XML_ELEMENT_QNAME, xmlElementName));
        }
    }

    @Override
    public Iterable<String> getReferencedXmlTypeNames() {
        return IterableTools.children(this.getXmlElementRefs(), XmlElementRef.REFERENCED_XML_TYPE_NAMES_TRANSFORMER);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Context {
        public ListIterable<XmlElementRefAnnotation> getXmlElementRefAnnotations();

        public XmlElementRefAnnotation addXmlElementRefAnnotation(int var1);

        public void removeXmlElementRefAnnotation(int var1);

        public void moveXmlElementRefAnnotation(int var1, int var2);

        public XmlElementRef buildXmlElementRef(JaxbContextNode var1, XmlElementRefAnnotation var2);

        public TextRange getValidationTextRange();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class XmlElementRefContainer
    extends AbstractJaxbNode.ContextListContainer<XmlElementRef, XmlElementRefAnnotation> {
        protected XmlElementRefContainer() {
        }

        @Override
        protected String getContextElementsPropertyName() {
            return "xmlElementRefs";
        }

        @Override
        protected XmlElementRef buildContextElement(XmlElementRefAnnotation resourceElement) {
            return GenericJavaXmlElementRefs.this.buildXmlElementRef(resourceElement);
        }

        @Override
        protected ListIterable<XmlElementRefAnnotation> getResourceElements() {
            return GenericJavaXmlElementRefs.this.getXmlElementRefAnnotations();
        }

        @Override
        protected XmlElementRefAnnotation getResourceElement(XmlElementRef contextElement) {
            return contextElement.getAnnotation();
        }
    }
}

